/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.RubyDockerProcessConnectionData;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyHelpersTransferConfig;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RubyDockerRemoteTransfer
extends RemoteTransfer
implements RubyRemoteSdkTransfer {
    private RubyDockerProcessConnectionData myDockerProcessConnectionData;

    protected RubyDockerRemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull RemoteTransfer.HelpersTransferConfig helpersTransferConfig) {
        if (helpersTransferConfig == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(0);
        }
        super(project, component, helpersTransferConfig);
        this.setTransferTaskModal(false);
    }

    protected RubyDockerRemoteTransfer(@Nullable Project project, RubyDockerProcessConnectionData dockerProcessConnectionData) {
        super(project, null, (RemoteTransfer.HelpersTransferConfig)new RubyHelpersTransferConfig(null));
        this.myDockerProcessConnectionData = dockerProcessConnectionData;
        this.setTransferTaskModal(false);
    }

    public void updateLocalGemsCopy(@NotNull Sdk sdk, @NotNull List<PathMappingSettings.PathMapping> pathMappings, @NotNull ProgressIndicator indicator) throws RemoteSdkException, InterruptedException {
        if (sdk == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(1);
        }
        if (pathMappings == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(3);
        }
        RemoteDockerApplicationRuntime applicationRuntime = this.getApplicationRuntime();
        indicator.setIndeterminate(false);
        int done = 0;
        for (PathMappingSettings.PathMapping mapping : pathMappings) {
            if (indicator.isCanceled() || RubySdkUtil.isRubySdkDisposed((Sdk)sdk)) {
                throw new InterruptedException();
            }
            try {
                File targetDir = new File(mapping.getLocalRoot());
                indicator.setText2(RubyDockerBundle.message("ruby.docker.sdk.downloading", mapping.getRemoteRoot()));
                applicationRuntime.downloadDirectory(mapping.getRemoteRoot(), targetDir, null, this.getMachineName());
                indicator.setFraction((double)(++done) / (double)pathMappings.size());
            }
            catch (WrappedNotFoundException targetDir) {
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InterruptedException) continue;
                throw e;
            }
            catch (ServerRuntimeException | IOException e) {
                throw DockerUtil.propagateRemoteSdkException((Throwable)e);
            }
        }
    }

    @NotNull
    protected RemoteDockerApplicationRuntime getApplicationRuntime() throws RemoteSdkException {
        RemoteDockerApplicationRuntime applicationRuntime;
        Project project = this.getProject();
        DockerContainerSettings containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        RubyDockerAgentDeploymentConfigImpl config = new RubyDockerAgentDeploymentConfigImpl(this.myDockerProcessConnectionData.getImage(), DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)containerSettings).build());
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.myDockerProcessConnectionData.getAccount(), (Project)this.getProject());
            applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
        }
        catch (ServerRuntimeException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = applicationRuntime;
        if (remoteDockerApplicationRuntime == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(4);
        }
        return remoteDockerApplicationRuntime;
    }

    @Nullable
    protected String getMachineName() throws RemoteSdkException {
        return this.myDockerProcessConnectionData.getImage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersTransferConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/RubyDockerRemoteTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerRemoteTransfer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalGemsCopy";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

