/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
implements Sequence {
    private List<Sequence> children = new ArrayList<Sequence>();

    public Chain(List<Sequence> children) {
        this.children = children;
    }

    @Override
    public Item head() throws XPathException {
        for (Sequence seq : this.children) {
            Item head = seq.head();
            if (head == null) continue;
            return head;
        }
        return null;
    }

    public SequenceIterator<Item> iterate() throws XPathException {
        return new ChainIterator();
    }

    public void append(Sequence sequence) {
        this.children.add(sequence);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainIterator
    implements SequenceIterator<Item> {
        private int i = 0;
        private SequenceIterator child;
        private Item current;
        private int position = 0;

        private ChainIterator() {
        }

        @Override
        public Item next() throws XPathException {
            if (this.position < 0) {
                return null;
            }
            do {
                if (this.child == null) {
                    this.child = ((Sequence)Chain.this.children.get(this.i++)).iterate();
                }
                this.current = this.child.next();
                if (this.current != null) {
                    ++this.position;
                    return this.current;
                }
                this.child = null;
            } while (this.i < Chain.this.children.size());
            this.current = null;
            this.position = -1;
            return null;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
            if (this.child != null) {
                this.child.close();
            }
        }

        public ChainIterator getAnother() throws XPathException {
            return new ChainIterator();
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

