/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.ScalaInstance$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import xsbti.Problem;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ScalaInstance;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u0013\tY!+Y<D_6\u0004\u0018\u000e\\3s\u0015\t\u0019A!A\u0002j]\u000eT!!\u0002\u0004\u0002\u0011%tG/\u001a:oC2T\u0011aB\u0001\u0004g\n$8\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u000b\u0007I\u0011\u0001\n\u0002\u001bM\u001c\u0017\r\\1J]N$\u0018M\\2f+\u0005\u0019\u0002C\u0001\u000b\u001a\u001b\u0005)\"B\u0001\f\u0018\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011\u0001G\u0001\u0006qN\u0014G/[\u0005\u00035U\u0011QbU2bY\u0006Len\u001d;b]\u000e,\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\n\u0002\u001dM\u001c\u0017\r\\1J]N$\u0018M\\2fA!Aa\u0004\u0001B\u0001B\u0003%q$\u0001\u0002daB\u0011A\u0003I\u0005\u0003CU\u0011\u0001c\u00117bgN\u0004\u0018\r\u001e5PaRLwN\\:\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n1\u0001\\8h!\t)\u0003&D\u0001'\u0015\t9c!\u0001\u0003vi&d\u0017BA\u0015'\u0005\u0019aunZ4fe\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"B!L\u00181cA\u0011a\u0006A\u0007\u0002\u0005!)\u0011C\u000ba\u0001'!)aD\u000ba\u0001?!)1E\u000ba\u0001I!)1\u0007\u0001C\u0001i\u0005)\u0011\r\u001d9msR)Q\u0007\u000f(Q%B\u00111BN\u0005\u0003o1\u0011A!\u00168ji\")\u0011H\ra\u0001u\u000591o\\;sG\u0016\u001c\bcA\u001eD\r:\u0011A(\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f!\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005\tc\u0011a\u00029bG.\fw-Z\u0005\u0003\t\u0016\u00131aU3r\u0015\t\u0011E\u0002\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006\u0011\u0011n\u001c\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\ti\u0005J\u0001\u0003GS2,\u0007\"B(3\u0001\u0004Q\u0014!C2mCN\u001c\b/\u0019;i\u0011\u0015\t&\u00071\u0001G\u0003=yW\u000f\u001e9vi\u0012K'/Z2u_JL\b\"B*3\u0001\u0004!\u0016aB8qi&|gn\u001d\t\u0004w\r+\u0006C\u0001,[\u001d\t9\u0006\f\u0005\u0002>\u0019%\u0011\u0011\fD\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Z\u0019!)a\f\u0001C\t?\u0006y1\r[3dW\u001a{'OR1jYV\u0014X\rF\u00026A\nDQ!Y/A\u0002)\t\u0001B]3q_J$XM\u001d\u0005\u0006Gv\u0003\r\u0001Z\u0001\u0005CJ<7\u000fE\u0002\fKVK!A\u001a\u0007\u0003\u000b\u0005\u0013(/Y=\t\u000b!\u0004A\u0011A5\u0002#\r|W\u000e]5mKJ\f%oZ;nK:$8/F\u0001k!\tq3.\u0003\u0002m\u0005\t\t2i\\7qS2,'/\u0011:hk6,g\u000e^:")
public class RawCompiler {
    private final ScalaInstance scalaInstance;
    private final ClasspathOptions cp;
    private final Logger log;

    public ScalaInstance scalaInstance() {
        return this.scalaInstance;
    }

    public void apply(Seq<File> sources, Seq<File> classpath, File outputDirectory, Seq<String> options) {
        String uniqueCompilerVersion = this.scalaInstance().actualVersion();
        Some compilerOut = new Some((Object)outputDirectory);
        Seq<String> arguments = this.compilerArguments().apply(sources, classpath, (Option<File>)compilerOut, options);
        String[] args = (String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class));
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("Creating plain compiler interface for ").append(uniqueCompilerVersion).append(".\n        |  > Arguments: ").append(arguments.mkString("\n\t", "\n\t", "")).append("\n      ").toString())).stripMargin());
        Object reporter = ScalaInstance$.MODULE$.isDotty(this.scalaInstance().version()) ? this.getReporter$1("dotty.tools.dotc.Main", args, true) : this.getReporter$1("scala.tools.nsc.Main", args, false);
        this.checkForFailure(reporter, (String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void checkForFailure(Object reporter, String[] args) {
        Method hasErrorsMethod = reporter.getClass().getMethod("hasErrors", new Class[0]);
        boolean failed = BoxesRunTime.unboxToBoolean((Object)hasErrorsMethod.invoke(reporter, new Object[0]));
        if (failed) {
            throw new CompileFailed(args, "Plain compile failed", (Problem[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Problem.class)));
        }
    }

    public CompilerArguments compilerArguments() {
        return new CompilerArguments(this.scalaInstance(), this.cp);
    }

    private final Object getReporter$1(String fqn, String[] args, boolean isDotty) {
        Class<?> mainClass = Class.forName(fqn, true, this.scalaInstance().loader());
        Method process = mainClass.getMethod("process", String[].class);
        Object potentialReporter = process.invoke(null, new Object[]{args});
        return isDotty ? potentialReporter : mainClass.getMethod("reporter", new Class[0]).invoke(null, new Object[0]);
    }

    public RawCompiler(ScalaInstance scalaInstance, ClasspathOptions cp, Logger log) {
        this.scalaInstance = scalaInstance;
        this.cp = cp;
        this.log = log;
    }
}

