/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;

public class AddBookmarkDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String BM_TITLE = "dialog.add.title";
    private static final String BM_NAME = "dialog.add.name";
    private static final String BM_DESCRIPTION = "dialog.add.description";
    private static final String BM_ENTER_NAME = "dialog.add.entername";
    private static final String BM_ENTER_DESCRIPTION = "dialog.add.enterdescription";
    public static final String BM_ACCESS_HINT = "dialog.add.accesshint";
    private JTextField txtName = new JTextField();
    private JTextField txtDescription = new JTextField();
    private JButton btnOK;
    private JButton btnCancel;
    private static final String BM_CANCEL = "dialog.add.cancel";
    private static final String BM_OK = "dialog.add.ok";
    private SQLBookmarkPlugin plugin;
    private boolean ok;

    public AddBookmarkDialog(Frame frame, SQLBookmarkPlugin plugin) {
        super(frame, plugin.getResourceString(BM_TITLE), true);
        this.plugin = plugin;
        this.createUI();
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddBookmarkDialog.this.onOK();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddBookmarkDialog.this.onCancel();
            }
        });
    }

    private void onCancel() {
        this.closeDialog();
    }

    private void onOK() {
        String name = this.txtName.getText();
        if (null == name || 0 == this.txtName.getText().trim().length() || this.containsWhiteSpaces(name)) {
            JOptionPane.showMessageDialog(this, this.plugin.getResourceString(BM_ENTER_NAME));
            return;
        }
        String description = this.txtDescription.getText();
        if (null == description || 0 == this.txtDescription.getText().trim().length()) {
            JOptionPane.showMessageDialog(this, this.plugin.getResourceString(BM_ENTER_DESCRIPTION));
            return;
        }
        this.ok = true;
        this.closeDialog();
    }

    private boolean containsWhiteSpaces(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isWhitespace(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void createUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.getContentPane().add((Component)new JLabel(this.plugin.getResourceString(BM_NAME)), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)this.txtName, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.getContentPane().add((Component)new JLabel(this.plugin.getResourceString(BM_DESCRIPTION)), gbc);
        gbc = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)this.txtDescription, gbc);
        gbc = new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        JLabel lblAccesshint = new JLabel(this.plugin.getResourceString(BM_ACCESS_HINT));
        lblAccesshint.setForeground(Color.red);
        this.getContentPane().add((Component)lblAccesshint, gbc);
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        this.btnOK = new JButton(this.plugin.getResourceString(BM_OK));
        gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0);
        pnlButtons.add((Component)this.btnOK, gbc);
        this.btnCancel = new JButton(this.plugin.getResourceString(BM_CANCEL));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
        pnlButtons.add((Component)this.btnCancel, gbc);
        gbc = new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)pnlButtons, gbc);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.txtName.requestFocus();
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddBookmarkDialog.this.closeDialog();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
        this.setSize(430, 130);
    }

    public boolean isOK() {
        return this.ok;
    }

    public String getDescription() {
        return this.txtDescription.getText().trim();
    }

    public String getBookmarkName() {
        return this.txtName.getText().trim();
    }
}

