/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.MainPanelTransferHandler;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextPrefs;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.UIUtil;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowScrollPane;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rtextarea.RTextScrollPane;

class RTextSplitPaneView
extends AbstractMainView
implements ListSelectionListener {
    private DockableWindow listWindow;
    private JList documentList;
    private RScrollPane documentListScrollPane;
    private DefaultListModel listModel;
    private CardLayout layout;
    private List<Component> scrollPanes;
    private int selectedIndex;
    private int listWindowPosition;
    private static final String IMAGE_FILE = "graphics/page_white_stack.png";

    public RTextSplitPaneView(RText owner, String[] filesToOpen, RTextPrefs prefs) {
        this.setLayout(new GridLayout(1, 1));
        this.documentList = new JList();
        this.documentList.setBorder(UIUtil.getEmpty5Border());
        this.documentList.setCellRenderer(new DocumentListCellRenderer());
        this.listModel = new DefaultListModel();
        this.documentList.setModel(this.listModel);
        this.documentList.setSelectionModel((ListSelectionModel)new RListSelectionModel());
        this.documentList.addListSelectionListener(this);
        this.documentList.addMouseListener(new ListListener());
        this.documentListScrollPane = new DockableWindowScrollPane((Component)this.documentList);
        String name = "Files";
        this.listWindow = new DockableWindow(name, (LayoutManager)new BorderLayout());
        this.listWindow.setPrimaryComponent((Component)this.documentList);
        URL res = this.getClass().getResource(IMAGE_FILE);
        this.listWindow.setIcon((Icon)new ImageIcon(res));
        this.listWindow.add((Component)this.documentListScrollPane);
        this.listWindow.setPosition(1);
        this.listWindow.setActive(true);
        owner.addDockableWindow(this.listWindow);
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.selectedIndex = -1;
        this.scrollPanes = new ArrayList<Component>();
        MainPanelTransferHandler th = new MainPanelTransferHandler(this);
        this.documentList.setTransferHandler(th);
        this.initialize(owner, filesToOpen, prefs);
    }

    protected void addTextAreaImpl(String title, Component component, String fileFullPath) {
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(component);
        RTextScrollPane sp = (RTextScrollPane)component;
        RTextEditorPane textArea = (RTextEditorPane)sp.getTextArea();
        ErrorStrip es = this.createErrorStrip(textArea);
        temp.add((Component)es, "After");
        int numDocuments = this.getNumDocuments();
        this.listModel.addElement(new DocumentInfo(title, this.getIconFor((RTextScrollPane)component)));
        this.add((Component)temp, new Integer(numDocuments).toString());
        this.scrollPanes.add(component);
        this.setSelectedIndex(numDocuments);
        ++numDocuments;
        for (int i = 0; i < numDocuments - 1; ++i) {
            if (!this.getRTextEditorPaneAt(i).getFileFullPath().equals(fileFullPath)) continue;
            int count = 0;
            for (int j = i; j < numDocuments; ++j) {
                RTextEditorPane pane = this.getRTextEditorPaneAt(j);
                if (!pane.getFileFullPath().equals(fileFullPath)) continue;
                String newTitle = title + " (" + ++count + ")";
                if (pane.isDirty()) {
                    newTitle = newTitle + "*";
                }
                try {
                    this.setDocumentDisplayNameAt(j, newTitle);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                }
            }
            break;
        }
    }

    protected synchronized boolean closeCurrentDocumentImpl() {
        ResourceBundle msg = this.owner.getResourceBundle();
        int rc = this.promptToSaveBeforeClosingIfDirty();
        if (rc == 2) {
            return false;
        }
        this.removeComponentAt(this.getSelectedIndex());
        if (this.getNumDocuments() > 0) {
            this.renumberDisplayNames();
        } else {
            this.addNewEmptyUntitledFile();
        }
        this.updateStatusBar();
        RTextEditorPane editor = this.getCurrentTextArea();
        if (editor.isDirty()) {
            this.owner.setMessages(editor.getFileFullPath() + "*", msg.getString("Ready"));
        } else {
            this.owner.setMessages(editor.getFileFullPath(), msg.getString("Ready"));
        }
        return true;
    }

    public void dispose() {
        this.owner.removeDockableWindow(this.listWindow);
    }

    public String getDocumentDisplayNameAt(int index) {
        if (index >= 0 && index < this.getNumDocuments()) {
            return ((DocumentInfo)this.listModel.get((int)index)).text;
        }
        return null;
    }

    public int getDocumentSelectionPlacement() {
        return this.listWindowPosition;
    }

    public int getNumDocuments() {
        return this.scrollPanes.size();
    }

    public RTextScrollPane getRTextScrollPaneAt(int index) {
        if (index < 0 || index >= this.getNumDocuments()) {
            return null;
        }
        return (RTextScrollPane)this.scrollPanes.get(index);
    }

    public Component getSelectedComponent() {
        return this.scrollPanes.get(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void refreshDisplayNames() {
        this.documentList.repaint();
    }

    protected void removeComponentAt(int index) {
        int numDocuments = this.getNumDocuments();
        if (index >= 0 && index < numDocuments) {
            this.scrollPanes.remove(index);
            --numDocuments;
            Component[] comps = this.getComponents();
            this.removeAll();
            for (int i = 0; i < numDocuments; ++i) {
                RTextScrollPane sp = (RTextScrollPane)this.scrollPanes.get(i);
                boolean reAdded = false;
                for (int j = 0; j < comps.length; ++j) {
                    RTextScrollPane sp2 = (RTextScrollPane)((JPanel)comps[j]).getComponent(0);
                    if (sp != sp2) continue;
                    this.add(comps[j], new Integer(i).toString());
                    reAdded = true;
                    break;
                }
                if (reAdded) continue;
                new Exception("Scroll pane " + i + " not re-added!").printStackTrace();
            }
            int oldSelectedIndex = this.getSelectedIndex();
            this.listModel.remove(index);
            if (oldSelectedIndex == numDocuments) {
                this.setSelectedIndex(oldSelectedIndex - 1);
            } else {
                this.setSelectedIndex(oldSelectedIndex);
            }
        }
    }

    public void setDocumentDisplayNameAt(int index, String displayName) {
        if (index >= 0 && index < this.getNumDocuments()) {
            DocumentInfo info = (DocumentInfo)this.listModel.get(index);
            info.text = displayName;
            info.icon = this.getIconFor(this.getRTextScrollPaneAt(index));
            this.documentList.repaint();
        }
    }

    public void setDocumentSelectionPlacement(int location) {
        if ((location == 1 || location == 2 || location == 3 || location == 4) && location != this.listWindowPosition) {
            this.listWindowPosition = location;
            int pos = 0;
            switch (this.listWindowPosition) {
                case 1: {
                    pos = 0;
                    break;
                }
                case 3: {
                    pos = 2;
                    break;
                }
                case 2: {
                    pos = 1;
                    break;
                }
                case 4: {
                    pos = 3;
                }
            }
            this.listWindow.setPosition(pos);
        }
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.scrollPanes.size()) {
            this.documentList.setSelectedIndex(index);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        RTextEditorPane current = this.getCurrentTextArea();
        if (current != null) {
            current.removeCaretListener(this.owner);
        }
        this.selectedIndex = this.documentList.getSelectedIndex();
        if (this.selectedIndex != -1) {
            String key = new Integer(this.selectedIndex).toString();
            this.layout.show(this, key);
            current = this.getRTextEditorPaneAt(this.selectedIndex);
            this.setCurrentTextArea(current);
            if (current.isDirty()) {
                this.owner.setMessages(current.getFileFullPath() + "*", null);
            } else {
                this.owner.setMessages(current.getFileFullPath(), null);
            }
            this.updateStatusBar();
            current.addCaretListener(this.owner);
            if (this.owner.getMainView() != null) {
                this.owner.caretUpdate(null);
            }
            current.requestFocusInWindow();
            this.firePropertyChange("MainView.currentDocument", -1, this.selectedIndex);
            this.fireCurrentTextAreaEvent(0, null, current);
        }
    }

    private class ListListener
    extends MouseAdapter {
        private ListListener() {
        }

        private JMenuItem createItem(String actionName) {
            JMenuItem item = new JMenuItem(RTextSplitPaneView.this.owner.getAction(actionName));
            item.setToolTipText(null);
            return item;
        }

        private JPopupMenu createPopupMenu() {
            JPopupMenu popup = new JPopupMenu();
            popup.add(this.createItem("saveAction"));
            popup.add(this.createItem("saveAsAction"));
            popup.add(this.createItem("closeAction"));
            popup.addSeparator();
            popup.add(this.createItem("filePropertiesAction"));
            return popup;
        }

        private void handleMouseEvent(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Rectangle r;
                Point p = e.getPoint();
                int index = RTextSplitPaneView.this.documentList.locationToIndex(p);
                if (index > -1 && (r = RTextSplitPaneView.this.documentList.getCellBounds(index, index)).contains(p)) {
                    RTextSplitPaneView.this.documentList.setSelectedIndex(index);
                    JPopupMenu popup = this.createPopupMenu();
                    popup.show(RTextSplitPaneView.this.documentList, p.x, p.y);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleMouseEvent(e);
        }
    }

    private class DocumentListCellRenderer
    extends DefaultListCellRenderer {
        private DocumentListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                RTextEditorPane textArea = RTextSplitPaneView.this.getRTextEditorPaneAt(index);
                if (textArea == null) {
                    this.setForeground(list.getForeground());
                } else if (textArea.isDirty() && RTextSplitPaneView.this.highlightModifiedDocumentDisplayNames()) {
                    this.setForeground(RTextSplitPaneView.this.getModifiedDocumentDisplayNamesColor());
                } else {
                    this.setForeground(list.getForeground());
                }
            }
            DocumentInfo info = (DocumentInfo)value;
            if (info != null) {
                this.setText(info.text);
                this.setIcon(info.icon);
            } else {
                this.setText("");
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private static class DocumentInfo {
        public String text;
        public Icon icon;

        public DocumentInfo(String text, Icon icon) {
            this.text = text;
            this.icon = icon;
        }
    }
}

