/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataRow;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataRow;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetExportData
implements IExportData {
    private static final ILogger log = LoggerController.createLogger(ResultSetExportData.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetExportData.class);
    private ResultSet resultSet;
    private List<ColumnDisplayDefinition> colDispDef;
    private DialectType dialect;
    private int rowIndex = 0;

    public ResultSetExportData(ResultSet resultSet, DialectType dialect) throws SQLException {
        this.resultSet = resultSet;
        this.colDispDef = new ArrayList<ColumnDisplayDefinition>();
        this.dialect = dialect;
        int columnCount = this.resultSet.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            this.colDispDef.add(new ColumnDisplayDefinition(resultSet, i, this.dialect, true));
        }
    }

    @Override
    public Iterator<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (ColumnDisplayDefinition col : this.colDispDef) {
            String headerValue = col.getColumnHeading();
            headers.add(headerValue);
        }
        return headers.iterator();
    }

    @Override
    public Iterator<IExportDataRow> getRows() {
        return new Iterator<IExportDataRow>(){

            @Override
            public void remove() {
                throw new IllegalStateException("not supported");
            }

            @Override
            public IExportDataRow next() {
                try {
                    ArrayList<IExportDataCell> cells = new ArrayList<IExportDataCell>();
                    for (int i = 1; i <= ResultSetExportData.this.colDispDef.size(); ++i) {
                        ColumnDisplayDefinition colDef = (ColumnDisplayDefinition)ResultSetExportData.this.colDispDef.get(i - 1);
                        Object object = CellComponentFactory.readResultSet(colDef, ResultSetExportData.this.resultSet, i, false);
                        ExportDataColumn cell = new ExportDataColumn(colDef, object, ResultSetExportData.this.rowIndex, i - 1);
                        cells.add(cell);
                    }
                    ExportDataRow data = new ExportDataRow(cells, ResultSetExportData.this.rowIndex);
                    ResultSetExportData.this.rowIndex++;
                    return data;
                }
                catch (SQLException e) {
                    log.error(i18n.ERROR_READING_RESULTSET, e);
                    throw new RuntimeException(i18n.ERROR_READING_RESULTSET, e);
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    boolean next = ResultSetExportData.this.resultSet.next();
                    return next;
                }
                catch (SQLException e) {
                    log.error(i18n.ERROR_READING_RESULTSET, e);
                    throw new RuntimeException(i18n.ERROR_READING_RESULTSET, e);
                }
            }
        };
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String ERROR_READING_RESULTSET = ResultSetExportData.access$000().getString("ResultSetExportData.errorReadingResultSet");
    }
}

