/*
 * 
 * Copyright (C) 2012-2025 Uwe Waldmann
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this font software and associated files (the "Software"),
 * to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish,
 * distribute, embed, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * (1) The above copyright notice, this permission notice, and the
 *     disclaimer below shall be included in all copies or substantial
 *     portions of the Software.
 * 
 * (2) If the design of any glyphs in the fonts that are contained in the
 *     Software or generated during the installation process is modified
 *     or if additional glyphs are added to the fonts, the fonts
 *     must be renamed. The new names may not contain the word "UW",
 *     irrespective of capitalisation; the new names may contain the word
 *     "ttyp0", irrespective of capitalisation, only if preceded by a
 *     foundry name different from "UW".
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

extern u_char UWTtyp0_Bold_8x16_data[];

struct wsdisplay_font UWTtyp0_Bold_8x16 = {
	"UW Ttyp0 Bold 8x16", /* typeface name */
	0, /* firstchar */
	256, /* numchars */
	WSDISPLAY_FONTENC_ISO, /* encoding */
	8, /* width */
	16, /* height */
	1, /* stride */
	WSDISPLAY_FONTORDER_L2R, /* bit order */
	WSDISPLAY_FONTORDER_L2R, /* byte order */
	UWTtyp0_Bold_8x16_data /* data */
};

static u_char UWTtyp0_Bold_8x16_data[] = {
	/* chr0 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0x06,    /* .....##. */
	0xC0,    /* ##...... */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr1 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x7C,    /* .#####.. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x7C,    /* .#####.. */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr2 */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */
	0x55,    /* .#.#.#.# */
	0xAA,    /* #.#.#.#. */

	/* chr3 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xD8,    /* ##.##... */
	0xD8,    /* ##.##... */
	0xF8,    /* #####... */
	0xD8,    /* ##.##... */
	0xD8,    /* ##.##... */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr4 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xF8,    /* #####... */
	0xC0,    /* ##...... */
	0xF0,    /* ####.... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */
	0x3E,    /* ..#####. */
	0x30,    /* ..##.... */
	0x3C,    /* ..####.. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr5 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x70,    /* .###.... */
	0xD8,    /* ##.##... */
	0xC0,    /* ##...... */
	0xD8,    /* ##.##... */
	0x70,    /* .###.... */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x36,    /* ..##.##. */
	0x3C,    /* ..####.. */
	0x36,    /* ..##.##. */
	0x36,    /* ..##.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr6 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xF8,    /* #####... */
	0x00,    /* ........ */
	0x3E,    /* ..#####. */
	0x30,    /* ..##.... */
	0x3C,    /* ..####.. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr7 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x44,    /* .#...#.. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr8 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr9 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC8,    /* ##..#... */
	0xE8,    /* ###.#... */
	0xF8,    /* #####... */
	0xB8,    /* #.###... */
	0x98,    /* #..##... */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x3E,    /* ..#####. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr10 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xCC,    /* ##..##.. */
	0xC8,    /* ##..#... */
	0x68,    /* .##.#... */
	0x70,    /* .###.... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr11 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xF8,    /* #####... */
	0xF8,    /* #####... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr12 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xF8,    /* #####... */
	0xF8,    /* #####... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr13 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1F,    /* ...##### */
	0x1F,    /* ...##### */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr14 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x1F,    /* ...##### */
	0x1F,    /* ...##### */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr15 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr16 */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr17 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr18 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr19 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr20 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr21 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x1F,    /* ...##### */
	0x1F,    /* ...##### */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr22 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xF8,    /* #####... */
	0xF8,    /* #####... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr23 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr24 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr25 */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */

	/* chr26 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x02,    /* ......#. */
	0x0E,    /* ....###. */
	0x38,    /* ..###... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x38,    /* ..###... */
	0x0E,    /* ....###. */
	0x02,    /* ......#. */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr27 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x40,    /* .#...... */
	0x70,    /* .###.... */
	0x1C,    /* ...###.. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x1C,    /* ...###.. */
	0x70,    /* .###.... */
	0x40,    /* .#...... */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr28 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0xFE,    /* #######. */
	0x24,    /* ..#..#.. */
	0x24,    /* ..#..#.. */
	0x66,    /* .##..##. */
	0x66,    /* .##..##. */
	0x46,    /* .#...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr29 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x06,    /* .....##. */
	0x04,    /* .....#.. */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x20,    /* ..#..... */
	0x60,    /* .##..... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr30 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0x66,    /* .##..##. */
	0x60,    /* .##..... */
	0xF8,    /* #####... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x42,    /* .#....#. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr31 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr32 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr33 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr34 */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr35 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0xFE,    /* #######. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0xFE,    /* #######. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr36 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x10,    /* ...#.... */
	0x7C,    /* .#####.. */
	0xD6,    /* ##.#.##. */
	0xD0,    /* ##.#.... */
	0xD0,    /* ##.#.... */
	0x7C,    /* .#####.. */
	0x16,    /* ...#.##. */
	0x16,    /* ...#.##. */
	0xD6,    /* ##.#.##. */
	0x7C,    /* .#####.. */
	0x10,    /* ...#.... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr37 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x46,    /* .#...##. */
	0xE6,    /* ###..##. */
	0xAC,    /* #.#.##.. */
	0xF8,    /* #####... */
	0x58,    /* .#.##... */
	0x34,    /* ..##.#.. */
	0x3E,    /* ..#####. */
	0x6A,    /* .##.#.#. */
	0xCE,    /* ##..###. */
	0xC4,    /* ##...#.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr38 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x68,    /* .##.#... */
	0x68,    /* .##.#... */
	0x68,    /* .##.#... */
	0x30,    /* ..##.... */
	0x72,    /* .###..#. */
	0xDA,    /* ##.##.#. */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr39 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x20,    /* ..#..... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr40 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr41 */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x08,    /* ....#... */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x08,    /* ....#... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr42 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x44,    /* .#...#.. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0xFE,    /* #######. */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x44,    /* .#...#.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr43 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr44 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x20,    /* ..#..... */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr45 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr46 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr47 */
	0x00,    /* ........ */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr48 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr49 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x38,    /* ..###... */
	0x78,    /* .####... */
	0x58,    /* .#.##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr50 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x06,    /* .....##. */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x42,    /* .#....#. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr51 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x04,    /* .....#.. */
	0x1C,    /* ...###.. */
	0x04,    /* .....#.. */
	0x06,    /* .....##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr52 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x1C,    /* ...###.. */
	0x3C,    /* ..####.. */
	0x2C,    /* ..#.##.. */
	0x6C,    /* .##.##.. */
	0xCC,    /* ##..##.. */
	0xFE,    /* #######. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr53 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x7C,    /* .#####.. */
	0x40,    /* .#...... */
	0x78,    /* .####... */
	0x4C,    /* .#..##.. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0xC6,    /* ##...##. */
	0xCC,    /* ##..##.. */
	0x78,    /* .####... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr54 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x60,    /* .##..... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr55 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x84,    /* #....#.. */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr56 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr57 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x0C,    /* ....##.. */
	0x78,    /* .####... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr58 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr59 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x20,    /* ..#..... */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr60 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x06,    /* .....##. */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x06,    /* .....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr61 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr62 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x60,    /* .##..... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr63 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x06,    /* .....##. */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr64 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1C,    /* ...###.. */
	0x36,    /* ..##.##. */
	0x6A,    /* .##.#.#. */
	0x5E,    /* .#.####. */
	0x52,    /* .#.#..#. */
	0x52,    /* .#.#..#. */
	0x5E,    /* .#.####. */
	0x6C,    /* .##.##.. */
	0x32,    /* ..##..#. */
	0x1E,    /* ...####. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr65 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr66 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFC,    /* ######.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xFC,    /* ######.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xFC,    /* ######.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr67 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr68 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xF8,    /* #####... */
	0xCC,    /* ##..##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCC,    /* ##..##.. */
	0xF8,    /* #####... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr69 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC8,    /* ##..#... */
	0xF8,    /* #####... */
	0xC8,    /* ##..#... */
	0xC0,    /* ##...... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr70 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC8,    /* ##..#... */
	0xF8,    /* #####... */
	0xC8,    /* ##..#... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr71 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xCE,    /* ##..###. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x66,    /* .##..##. */
	0x3E,    /* ..#####. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr72 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xFE,    /* #######. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr73 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr74 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1E,    /* ...####. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0x78,    /* .####... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr75 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC4,    /* ##...#.. */
	0xCC,    /* ##..##.. */
	0xC8,    /* ##..#... */
	0xD8,    /* ##.##... */
	0xF8,    /* #####... */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr76 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr77 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xEE,    /* ###.###. */
	0xEE,    /* ###.###. */
	0xFE,    /* #######. */
	0xB6,    /* #.##.##. */
	0xB6,    /* #.##.##. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr78 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xE2,    /* ###...#. */
	0xE2,    /* ###...#. */
	0xB2,    /* #.##..#. */
	0xB2,    /* #.##..#. */
	0x9A,    /* #..##.#. */
	0x9A,    /* #..##.#. */
	0x8E,    /* #...###. */
	0x8E,    /* #...###. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr79 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr80 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFC,    /* ######.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xFC,    /* ######.. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr81 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xF6,    /* ####.##. */
	0xDE,    /* ##.####. */
	0x7C,    /* .#####.. */
	0x06,    /* .....##. */
	0x02,    /* ......#. */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr82 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFC,    /* ######.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xFC,    /* ######.. */
	0xD8,    /* ##.##... */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr83 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC0,    /* ##...... */
	0xE0,    /* ###..... */
	0x78,    /* .####... */
	0x1C,    /* ...###.. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr84 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0x99,    /* #..##..# */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr85 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr86 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0x66,    /* .##..##. */
	0x64,    /* .##..#.. */
	0x64,    /* .##..#.. */
	0x34,    /* ..##.#.. */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr87 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xDA,    /* ##.##.#. */
	0xDA,    /* ##.##.#. */
	0xDA,    /* ##.##.#. */
	0xFE,    /* #######. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr88 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x64,    /* .##..#.. */
	0x68,    /* .##.#... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x2C,    /* ..#.##.. */
	0x4C,    /* .#..##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr89 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC3,    /* ##....## */
	0x62,    /* .##...#. */
	0x64,    /* .##..#.. */
	0x34,    /* ..##.#.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr90 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0x86,    /* #....##. */
	0x8C,    /* #...##.. */
	0x1C,    /* ...###.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x70,    /* .###.... */
	0x62,    /* .##...#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr91 */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr92 */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr93 */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr94 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0xC6,    /* ##...##. */
	0x82,    /* #.....#. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr95 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr96 */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x08,    /* ....#... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr97 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr98 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xE6,    /* ###..##. */
	0xDC,    /* ##.###.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr99 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr100 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x76,    /* .###.##. */
	0xCE,    /* ##..###. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr101 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC6,    /* ##...##. */
	0xFE,    /* #######. */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr102 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1E,    /* ...####. */
	0x32,    /* ..##..#. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0xFC,    /* ######.. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr103 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7A,    /* .####.#. */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0x78,    /* .####... */
	0xC0,    /* ##...... */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */

	/* chr104 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr105 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr106 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0x78,    /* .####... */
	0x00,    /* ........ */

	/* chr107 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC6,    /* ##...##. */
	0xCC,    /* ##..##.. */
	0xD0,    /* ##.#.... */
	0xF8,    /* #####... */
	0xCC,    /* ##..##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr108 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr109 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xAC,    /* #.#.##.. */
	0xFE,    /* #######. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr110 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr111 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr112 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xE6,    /* ###..##. */
	0xDC,    /* ##.###.. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */

	/* chr113 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x76,    /* .###.##. */
	0xCE,    /* ##..###. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x00,    /* ........ */

	/* chr114 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xEE,    /* ###.###. */
	0x76,    /* .###.##. */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr115 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC0,    /* ##...... */
	0x7C,    /* .#####.. */
	0x06,    /* .....##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr116 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0xFC,    /* ######.. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x36,    /* ..##.##. */
	0x1C,    /* ...###.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr117 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr118 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xC6,    /* ##...##. */
	0x64,    /* .##..#.. */
	0x64,    /* .##..#.. */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr119 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xDA,    /* ##.##.#. */
	0xDA,    /* ##.##.#. */
	0xDA,    /* ##.##.#. */
	0x7C,    /* .#####.. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr120 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xE6,    /* ###..##. */
	0x68,    /* .##.#... */
	0x38,    /* ..###... */
	0x2C,    /* ..#.##.. */
	0xCE,    /* ##..###. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr121 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xC6,    /* ##...##. */
	0x64,    /* .##..#.. */
	0x64,    /* .##..#.. */
	0x3C,    /* ..####.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0xD0,    /* ##.#.... */
	0xE0,    /* ###..... */
	0x00,    /* ........ */

	/* chr122 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0x8E,    /* #...###. */
	0x0C,    /* ....##.. */
	0x38,    /* ..###... */
	0x60,    /* .##..... */
	0xE2,    /* ###...#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr123 */
	0x00,    /* ........ */
	0x0E,    /* ....###. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x70,    /* .###.... */
	0x70,    /* .###.... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x0E,    /* ....###. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr124 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr125 */
	0x00,    /* ........ */
	0x70,    /* .###.... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x0E,    /* ....###. */
	0x0E,    /* ....###. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x70,    /* .###.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr126 */
	0x00,    /* ........ */
	0x32,    /* ..##..#. */
	0x7A,    /* .####.#. */
	0x5E,    /* .#.####. */
	0x4C,    /* .#..##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr127 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr128 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1E,    /* ...####. */
	0x32,    /* ..##..#. */
	0x60,    /* .##..... */
	0xFC,    /* ######.. */
	0x60,    /* .##..... */
	0xF8,    /* #####... */
	0x60,    /* .##..... */
	0x32,    /* ..##..#. */
	0x1E,    /* ...####. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr129 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr130 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr131 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1E,    /* ...####. */
	0x32,    /* ..##..#. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0xFC,    /* ######.. */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0x30,    /* ..##.... */
	0xB0,    /* #.##.... */
	0xE0,    /* ###..... */
	0x00,    /* ........ */

	/* chr132 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xCC,    /* ##..##.. */
	0xEE,    /* ###.###. */
	0x66,    /* .##..##. */
	0xCC,    /* ##..##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr133 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xDA,    /* ##.##.#. */
	0xDB,    /* ##.##.## */
	0xDA,    /* ##.##.#. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr134 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x54,    /* .#.#.#.. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x54,    /* .#.#.#.. */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x10,    /* ...#.... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr135 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x54,    /* .#.#.#.. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x54,    /* .#.#.#.. */
	0x10,    /* ...#.... */
	0x54,    /* .#.#.#.. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x54,    /* .#.#.#.. */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr136 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x44,    /* .#...#.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr137 */
	0x00,    /* ........ */
	0x40,    /* .#...... */
	0xE2,    /* ###...#. */
	0xA6,    /* #.#..##. */
	0xEC,    /* ###.##.. */
	0x58,    /* .#.##... */
	0x30,    /* ..##.... */
	0x60,    /* .##..... */
	0xD4,    /* ##.#.#.. */
	0xBE,    /* #.#####. */
	0x2A,    /* ..#.#.#. */
	0x3E,    /* ..#####. */
	0x14,    /* ...#.#.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr138 */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC0,    /* ##...... */
	0x70,    /* .###.... */
	0x3C,    /* ..####.. */
	0x0E,    /* ....###. */
	0x06,    /* .....##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr139 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr140 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0xDA,    /* ##.##.#. */
	0xD8,    /* ##.##... */
	0xD8,    /* ##.##... */
	0xDE,    /* ##.####. */
	0xD8,    /* ##.##... */
	0xD8,    /* ##.##... */
	0xD8,    /* ##.##... */
	0xDA,    /* ##.##.#. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr141 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr142 */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0x86,    /* #....##. */
	0x8C,    /* #...##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x60,    /* .##..... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr143 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr144 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr145 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr146 */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr147 */
	0x00,    /* ........ */
	0x66,    /* .##..##. */
	0xCC,    /* ##..##.. */
	0xEE,    /* ###.###. */
	0x66,    /* .##..##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr148 */
	0x00,    /* ........ */
	0xCC,    /* ##..##.. */
	0xEE,    /* ###.###. */
	0x66,    /* .##..##. */
	0xCC,    /* ##..##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr149 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x3C,    /* ..####.. */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x3C,    /* ..####.. */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr150 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr151 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr152 */
	0x00,    /* ........ */
	0x32,    /* ..##..#. */
	0x7E,    /* .######. */
	0x4C,    /* .#..##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr153 */
	0x00,    /* ........ */
	0xF6,    /* ####.##. */
	0x5E,    /* .#.####. */
	0x56,    /* .#.#.##. */
	0x56,    /* .#.#.##. */
	0x56,    /* .#.#.##. */
	0x56,    /* .#.#.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr154 */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC0,    /* ##...... */
	0x7C,    /* .#####.. */
	0x06,    /* .....##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr155 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr156 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x76,    /* .###.##. */
	0xDE,    /* ##.####. */
	0xDA,    /* ##.##.#. */
	0xDE,    /* ##.####. */
	0xD8,    /* ##.##... */
	0xDE,    /* ##.####. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr157 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr158 */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0x8E,    /* #...###. */
	0x0C,    /* ....##.. */
	0x38,    /* ..###... */
	0x60,    /* .##..... */
	0xE2,    /* ###...#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr159 */
	0x36,    /* ..##.##. */
	0x36,    /* ..##.##. */
	0x00,    /* ........ */
	0xC3,    /* ##....## */
	0x62,    /* .##...#. */
	0x64,    /* .##..#.. */
	0x34,    /* ..##.#.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr160 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x42,    /* .#....#. */
	0x42,    /* .#....#. */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr161 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */

	/* chr162 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x04,    /* .....#.. */
	0x3C,    /* ..####.. */
	0x6E,    /* .##.###. */
	0xC8,    /* ##..#... */
	0xD8,    /* ##.##... */
	0xD0,    /* ##.#.... */
	0x76,    /* .###.##. */
	0x3C,    /* ..####.. */
	0x20,    /* ..#..... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr163 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0x66,    /* .##..##. */
	0x60,    /* .##..... */
	0xF8,    /* #####... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x42,    /* .#....#. */
	0xFE,    /* #######. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr164 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x66,    /* .##..##. */
	0x7E,    /* .######. */
	0x24,    /* ..#..#.. */
	0x24,    /* ..#..#.. */
	0x7E,    /* .######. */
	0x66,    /* .##..##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr165 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC3,    /* ##....## */
	0x66,    /* .##..##. */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr166 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr167 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */

	/* chr168 */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr169 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x62,    /* .##...#. */
	0xDD,    /* ##.###.# */
	0xB5,    /* #.##.#.# */
	0xB1,    /* #.##...# */
	0xB1,    /* #.##...# */
	0xB5,    /* #.##.#.# */
	0xDD,    /* ##.###.# */
	0x62,    /* .##...#. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr170 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x06,    /* .....##. */
	0x3E,    /* ..#####. */
	0x66,    /* .##..##. */
	0x3E,    /* ..#####. */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr171 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x36,    /* ..##.##. */
	0x6C,    /* .##.##.. */
	0xD8,    /* ##.##... */
	0x6C,    /* .##.##.. */
	0x36,    /* ..##.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr172 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x06,    /* .....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr173 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr174 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xFB,    /* #####.## */
	0xAD,    /* #.#.##.# */
	0xAD,    /* #.#.##.# */
	0xB9,    /* #.###..# */
	0xAD,    /* #.#.##.# */
	0xE7,    /* ###..### */
	0x62,    /* .##...#. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr175 */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr176 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x44,    /* .#...#.. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr177 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0xFF,    /* ######## */
	0xFF,    /* ######## */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr178 */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0x46,    /* .#...##. */
	0x0C,    /* ....##.. */
	0x30,    /* ..##.... */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr179 */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x1C,    /* ...###.. */
	0x06,    /* .....##. */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr180 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x20,    /* ..#..... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr181 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xEE,    /* ###.###. */
	0xD6,    /* ##.#.##. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */

	/* chr182 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0xFE,    /* #######. */
	0x96,    /* #..#.##. */
	0x96,    /* #..#.##. */
	0xF6,    /* ####.##. */
	0x76,    /* .###.##. */
	0x16,    /* ...#.##. */
	0x16,    /* ...#.##. */
	0x16,    /* ...#.##. */
	0x16,    /* ...#.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr183 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr184 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x0C,    /* ....##.. */
	0x0C,    /* ....##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */

	/* chr185 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr186 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0x66,    /* .##..##. */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr187 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xD8,    /* ##.##... */
	0x6C,    /* .##.##.. */
	0x36,    /* ..##.##. */
	0x6C,    /* .##.##.. */
	0xD8,    /* ##.##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr188 */
	0x00,    /* ........ */
	0x60,    /* .##..... */
	0xE0,    /* ###..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x66,    /* .##..##. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0xDC,    /* ##.###.. */
	0x2C,    /* ..#.##.. */
	0x2C,    /* ..#.##.. */
	0x3E,    /* ..#####. */
	0x0C,    /* ....##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr189 */
	0x00,    /* ........ */
	0x60,    /* .##..... */
	0xE0,    /* ###..... */
	0x60,    /* .##..... */
	0x60,    /* .##..... */
	0x66,    /* .##..##. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x7C,    /* .#####.. */
	0xD6,    /* ##.#.##. */
	0x0C,    /* ....##.. */
	0x10,    /* ...#.... */
	0x3E,    /* ..#####. */
	0x3E,    /* ..#####. */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr190 */
	0x00,    /* ........ */
	0x70,    /* .###.... */
	0x98,    /* #..##... */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0xD6,    /* ##.#.##. */
	0x7C,    /* .#####.. */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0xDC,    /* ##.###.. */
	0x2C,    /* ..#.##.. */
	0x2C,    /* ..#.##.. */
	0x3E,    /* ..#####. */
	0x0C,    /* ....##.. */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr191 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x60,    /* .##..... */
	0xC0,    /* ##...... */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */

	/* chr192 */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr193 */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr194 */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr195 */
	0x36,    /* ..##.##. */
	0x5C,    /* .#.###.. */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr196 */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr197 */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x58,    /* .#.##... */
	0x4C,    /* .#..##.. */
	0x7C,    /* .#####.. */
	0xCC,    /* ##..##.. */
	0x86,    /* #....##. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr198 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x1E,    /* ...####. */
	0x3A,    /* ..###.#. */
	0x38,    /* ..###... */
	0x38,    /* ..###... */
	0x5E,    /* .#.####. */
	0x58,    /* .#.##... */
	0x78,    /* .####... */
	0xD8,    /* ##.##... */
	0x9A,    /* #..##.#. */
	0x9E,    /* #..####. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr199 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x10,    /* ...#.... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */

	/* chr200 */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0xFE,    /* #######. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC8,    /* ##..#... */
	0xF8,    /* #####... */
	0xC8,    /* ##..#... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr201 */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0xFE,    /* #######. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC8,    /* ##..#... */
	0xF8,    /* #####... */
	0xC8,    /* ##..#... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr202 */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC8,    /* ##..#... */
	0xF8,    /* #####... */
	0xC8,    /* ##..#... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr203 */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xFE,    /* #######. */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xC8,    /* ##..#... */
	0xF8,    /* #####... */
	0xC8,    /* ##..#... */
	0xC2,    /* ##....#. */
	0xC2,    /* ##....#. */
	0xFE,    /* #######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr204 */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x08,    /* ....#... */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr205 */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr206 */
	0x1C,    /* ...###.. */
	0x36,    /* ..##.##. */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr207 */
	0x36,    /* ..##.##. */
	0x36,    /* ..##.##. */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr208 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xF8,    /* #####... */
	0xCC,    /* ##..##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xF6,    /* ####.##. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCC,    /* ##..##.. */
	0xF8,    /* #####... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr209 */
	0x36,    /* ..##.##. */
	0x5C,    /* .#.###.. */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xE2,    /* ###...#. */
	0xE2,    /* ###...#. */
	0xB2,    /* #.##..#. */
	0xBA,    /* #.###.#. */
	0x9A,    /* #..##.#. */
	0x8E,    /* #...###. */
	0x8E,    /* #...###. */
	0x86,    /* #....##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr210 */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr211 */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr212 */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr213 */
	0x36,    /* ..##.##. */
	0x5C,    /* .#.###.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr214 */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr215 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x42,    /* .#....#. */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x18,    /* ...##... */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0x42,    /* .#....#. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr216 */
	0x00,    /* ........ */
	0x02,    /* ......#. */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0xCE,    /* ##..###. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0xE6,    /* ###..##. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x80,    /* #....... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr217 */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr218 */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr219 */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr220 */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr221 */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0xC3,    /* ##....## */
	0x62,    /* .##...#. */
	0x64,    /* .##..#.. */
	0x34,    /* ..##.#.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr222 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xFC,    /* ######.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xFC,    /* ######.. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr223 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x78,    /* .####... */
	0xCC,    /* ##..##.. */
	0xCC,    /* ##..##.. */
	0xD8,    /* ##.##... */
	0xDC,    /* ##.###.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xD6,    /* ##.#.##. */
	0xDC,    /* ##.###.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr224 */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x08,    /* ....#... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr225 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr226 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x3C,    /* ..####.. */
	0x24,    /* ..#..#.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr227 */
	0x00,    /* ........ */
	0x24,    /* ..#..#.. */
	0x7C,    /* .#####.. */
	0x48,    /* .#..#... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr228 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr229 */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0x66,    /* .##..##. */
	0x06,    /* .....##. */
	0x7E,    /* .######. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr230 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6E,    /* .##.###. */
	0xDA,    /* ##.##.#. */
	0x1A,    /* ...##.#. */
	0x7E,    /* .######. */
	0xD8,    /* ##.##... */
	0xDA,    /* ##.##.#. */
	0xEE,    /* ###.###. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr231 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x10,    /* ...#.... */
	0x18,    /* ...##... */
	0x30,    /* ..##.... */
	0x00,    /* ........ */

	/* chr232 */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x08,    /* ....#... */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC6,    /* ##...##. */
	0xFE,    /* #######. */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr233 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC6,    /* ##...##. */
	0xFE,    /* #######. */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr234 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x3C,    /* ..####.. */
	0x24,    /* ..#..#.. */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC6,    /* ##...##. */
	0xFE,    /* #######. */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr235 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x3C,    /* ..####.. */
	0x66,    /* .##..##. */
	0xC6,    /* ##...##. */
	0xFE,    /* #######. */
	0xC0,    /* ##...... */
	0x66,    /* .##..##. */
	0x3C,    /* ..####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr236 */
	0x00,    /* ........ */
	0x30,    /* ..##.... */
	0x18,    /* ...##... */
	0x08,    /* ....#... */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr237 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr238 */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x3C,    /* ..####.. */
	0x24,    /* ..#..#.. */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr239 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr240 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xD8,    /* ##.##... */
	0x70,    /* .###.... */
	0xD8,    /* ##.##... */
	0x3C,    /* ..####.. */
	0x6C,    /* .##.##.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x6C,    /* .##.##.. */
	0x38,    /* ..###... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr241 */
	0x00,    /* ........ */
	0x24,    /* ..#..#.. */
	0x7C,    /* .#####.. */
	0x48,    /* .#..#... */
	0x00,    /* ........ */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr242 */
	0x00,    /* ........ */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr243 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr244 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr245 */
	0x00,    /* ........ */
	0x24,    /* ..#..#.. */
	0x7C,    /* .#####.. */
	0x48,    /* .#..#... */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr246 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0x7C,    /* .#####.. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0x7C,    /* .#####.. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr247 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x7E,    /* .######. */
	0x7E,    /* .######. */
	0x00,    /* ........ */
	0x18,    /* ...##... */
	0x18,    /* ...##... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr248 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x04,    /* .....#.. */
	0x7C,    /* .#####.. */
	0xCE,    /* ##..###. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0xD6,    /* ##.#.##. */
	0xE6,    /* ###..##. */
	0x7C,    /* .#####.. */
	0x40,    /* .#...... */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr249 */
	0x00,    /* ........ */
	0x60,    /* .##..... */
	0x30,    /* ..##.... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr250 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr251 */
	0x00,    /* ........ */
	0x10,    /* ...#.... */
	0x38,    /* ..###... */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr252 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xCE,    /* ##..###. */
	0x76,    /* .###.##. */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x00,    /* ........ */

	/* chr253 */
	0x00,    /* ........ */
	0x0C,    /* ....##.. */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xC6,    /* ##...##. */
	0x64,    /* .##..#.. */
	0x64,    /* .##..#.. */
	0x3C,    /* ..####.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0xD0,    /* ##.#.... */
	0xE0,    /* ###..... */
	0x00,    /* ........ */

	/* chr254 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xDC,    /* ##.###.. */
	0xE6,    /* ###..##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xC6,    /* ##...##. */
	0xE6,    /* ###..##. */
	0xDC,    /* ##.###.. */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0xC0,    /* ##...... */
	0x00,    /* ........ */

	/* chr255 */
	0x00,    /* ........ */
	0x00,    /* ........ */
	0x6C,    /* .##.##.. */
	0x6C,    /* .##.##.. */
	0x00,    /* ........ */
	0xC2,    /* ##....#. */
	0xC6,    /* ##...##. */
	0x64,    /* .##..#.. */
	0x64,    /* .##..#.. */
	0x3C,    /* ..####.. */
	0x38,    /* ..###... */
	0x18,    /* ...##... */
	0x10,    /* ...#.... */
	0xD0,    /* ##.#.... */
	0xE0,    /* ###..... */
	0x00,    /* ........ */

};
