/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.tools.NodeProbe;

public class JmxCollector
implements Callable<GcStats> {
    final NodeProbe[] probes;
    private static final ExecutorService TPE = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new NamedThreadFactory("JmxCollector"));

    public JmxCollector(Collection<String> hosts, int port) {
        this.probes = new NodeProbe[hosts.size()];
        int i = 0;
        for (String host : hosts) {
            this.probes[i] = JmxCollector.connect(host, port);
            this.probes[i].getAndResetGCStats();
            ++i;
        }
    }

    private static NodeProbe connect(String host, int port) {
        try {
            return new NodeProbe(host, port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GcStats call() throws Exception {
        void var4_6;
        ArrayList<Future<GcStats>> futures = new ArrayList<Future<GcStats>>();
        NodeProbe[] nodeProbeArray = this.probes;
        int n = nodeProbeArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            final NodeProbe probe = nodeProbeArray[var4_6];
            futures.add(TPE.submit(new Callable<GcStats>(){

                @Override
                public GcStats call() throws Exception {
                    double[] stats = probe.getAndResetGCStats();
                    return new GcStats(stats[5], stats[4], stats[1], stats[2], stats[3]);
                }
            }));
            ++var4_6;
        }
        ArrayList<GcStats> results = new ArrayList<GcStats>();
        for (Future future : futures) {
            results.add((GcStats)future.get());
        }
        return GcStats.aggregate(results);
    }

    public static class GcStats {
        public final double count;
        public final double bytes;
        public final double maxms;
        public final double summs;
        public final double sumsqms;
        public final double sdvms;

        public GcStats(double count, double bytes, double maxms, double summs, double sumsqms) {
            this.count = count;
            this.bytes = bytes;
            this.maxms = maxms;
            this.summs = summs;
            this.sumsqms = sumsqms;
            double mean = summs / count;
            double stdev = Math.sqrt(sumsqms / count - mean * mean);
            if (Double.isNaN(stdev)) {
                stdev = 0.0;
            }
            this.sdvms = stdev;
        }

        public GcStats(double fill) {
            this(fill, fill, fill, fill, fill);
        }

        public static GcStats aggregate(List<GcStats> stats) {
            double count = 0.0;
            double bytes = 0.0;
            double maxms = 0.0;
            double summs = 0.0;
            double sumsqms = 0.0;
            for (GcStats stat : stats) {
                count += stat.count;
                bytes += stat.bytes;
                maxms += stat.maxms;
                summs += stat.summs;
                sumsqms += stat.sumsqms;
            }
            return new GcStats(count, bytes, maxms, summs, sumsqms);
        }
    }
}

