/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.conversation;

import java.security.Key;
import java.util.Vector;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import org.apache.axis.components.logger.LogFactory;
import org.apache.commons.logging.Log;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.sandbox.security.conversation.ConversationUtil;
import org.apache.ws.sandbox.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.sandbox.security.conversation.DerivedKeyTokenAdder;
import org.apache.ws.sandbox.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.sandbox.security.conversation.message.token.DerivedKeyToken;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConversationManager {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$sandbox$security$conversation$ConversationManager == null ? (class$org$apache$ws$sandbox$security$conversation$ConversationManager = ConversationManager.class$("org.apache.ws.sandbox.security.conversation.ConversationManager")) : class$org$apache$ws$sandbox$security$conversation$ConversationManager).getName());
    private int generation = 0;
    protected String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    static /* synthetic */ Class class$org$apache$ws$sandbox$security$conversation$ConversationManager;

    public DerivedKeyInfo createDerivedKeyToken(Document doc, String uuid, DerivedKeyCallbackHandler dkcbHandler, SecurityTokenReference stRef2Base, int keyLen) throws ConversationException {
        String genID = ConversationUtil.genericID();
        Reference ref = new Reference(doc);
        ref.setURI("#" + genID);
        ref.setValueType("http://schemas.xmlsoap.org/ws/2005/02/sc/dk");
        SecurityTokenReference stRef = new SecurityTokenReference(doc);
        stRef.setReference(ref);
        WSSecurityUtil.setNamespace(stRef.getElement(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        DerivedKeyToken dtoken = new DerivedKeyToken(doc);
        if (stRef2Base != null) {
            dtoken.setSecuityTokenReference(doc, stRef2Base);
        }
        dtoken.setLabel(doc, "WS-SecureConversationWS-SecureConversation");
        dtoken.setNonce(doc, ConversationUtil.generateNonce(128));
        dtoken.setID(genID);
        if (keyLen != -1) {
            dtoken.setLength(doc, keyLen);
        }
        DerivedKeyInfo dkInfo = null;
        try {
            dkInfo = new DerivedKeyInfo(dtoken);
            dkInfo.setSecTokRef2DkToken(stRef);
            dkcbHandler.addDerivedKey(uuid, dkInfo);
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            throw new ConversationException("ConversationManager:: Cannot add Derived key token to the envelope");
        }
        return dkInfo;
    }

    public void addDkToken(Document doc, DerivedKeyInfo info) {
        DerivedKeyTokenAdder adder = new DerivedKeyTokenAdder();
        adder.build(doc, info.getDkTok());
    }

    public void performDK_ENCR(String encUser, String actor, boolean mu, Document doc, SecurityTokenReference secRef, DerivedKeyCallbackHandler dkcbHandler, Vector parts, String symAlgo) throws ConversationException {
        WSEncryptBody wsEncrypt = new WSEncryptBody(actor, mu);
        wsEncrypt.setKeyIdentifierType(6);
        wsEncrypt.setSecurityTokenReference(secRef);
        WSPasswordCallback pwCb = new WSPasswordCallback(encUser, 0);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            dkcbHandler.handle(callbacks);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConversationException("ConversationManager :: PasswordCallback failed");
        }
        wsEncrypt.setKey(pwCb.getKey());
        wsEncrypt.setUserInfo(encUser);
        wsEncrypt.setParts(parts);
        wsEncrypt.setSymmetricEncAlgorithm(symAlgo);
        try {
            wsEncrypt.build(doc, null);
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            throw new ConversationException("ConversationManager :: Encryption: error during message processing");
        }
    }

    public void performDK_Sign(Document doc, DerivedKeyCallbackHandler dkcbHandler, String uuid, DerivedKeyInfo dkSigInfo, Vector parts) throws ConversationException {
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        String sigUser = ConversationUtil.generateIdentifier(uuid, dkSigInfo.getId());
        System.out.println("Signature user is ::" + sigUser);
        WSPasswordCallback pwCb = new WSPasswordCallback(sigUser, 0);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            dkcbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new ConversationException("ConversationManager :: Password callback failed");
        }
        try {
            Reference ref = dkSigInfo.getSecTokRef2DkToken().getReference();
            this.build(doc, ref, pwCb.getKey(), parts);
        }
        catch (WSSecurityException e1) {
            e1.printStackTrace();
            throw new ConversationException("ConversationManager :: Error performing signature.");
        }
    }

    public Document build(Document doc, Reference ref, byte[] sk, Vector parts) throws WSSecurityException {
        boolean doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)"Beginning signing...");
        }
        if (ref == null) {
            throw new WSSecurityException(0, "invalidData", new Object[]{"For symmeric key signatures - Reference object must be provided"});
        }
        if (sk == null) {
            throw new WSSecurityException(0, "invalidData", new Object[]{"For symmeric key signatures - Reference object must be provided"});
        }
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        log.debug((Object)("Key is " + new String(sk)));
        SecretKeySpec sharedKey = new SecretKeySpec(sk, sigAlgo);
        WSDocInfo wsDocInfo = new WSDocInfo(doc.hashCode());
        Element envelope = doc.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), true);
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(doc, null, sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(9, "noXMLSig");
        }
        KeyInfo info = sig.getKeyInfo();
        String keyInfoUri = "KeyId-" + info.hashCode();
        info.setId(keyInfoUri);
        SecurityTokenReference secRef = new SecurityTokenReference(doc);
        String strUri = "STRId-" + secRef.hashCode();
        secRef.setID(strUri);
        if (parts == null) {
            parts = new Vector<WSEncryptionPart>();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            parts.add(encP);
        }
        Transforms transforms = null;
        for (int part = 0; part < parts.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)parts.get(part);
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            try {
                if (elemName.equals("Token")) {
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    sig.addDocument("#" + keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(doc);
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    sig.addDocument("#" + strUri, transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                sig.addDocument("#" + this.setWsuId(body), transforms);
                continue;
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(9, "noXMLSig", null, e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(9, "noXMLSig", null, e1);
            }
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        WSSecurityUtil.appendChildElement(doc, securityHeader, sig.getElement());
        secRef.setReference(ref);
        info.addUnknownElement(secRef.getElement());
        try {
            sig.sign((Key)sharedKey);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        if (doDebug) {
            log.debug((Object)"Signing complete.");
        }
        return doc;
    }

    private Element createSTRParameter(Document doc) {
        Element transformParam = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
        WSSecurityUtil.setNamespace(transformParam, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        WSSecurityUtil.setNamespace(canonElem, "http://www.w3.org/2000/09/xmldsig#", "ds");
        canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformParam.appendChild(canonElem);
        return transformParam;
    }

    protected String setWsuId(Element bodyElement) {
        String prefix = WSSecurityUtil.setNamespace(bodyElement, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        String id = bodyElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            id = "id-" + Integer.toString(bodyElement.hashCode());
            bodyElement.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
        }
        return id;
    }

    public void setGenerationInfo(int i) {
        this.generation = i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

