/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.preview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.drag.effects.DefaultPreview;

public class XORPreview
extends DefaultPreview {
    public void drawPreview(Graphics2D g, Polygon p, Dockable dockable, Map dragInfo) {
        float[] pattern = new float[]{1.0f, 1.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, pattern, 0.0f);
        g.setStroke(stroke);
        g.setColor(Color.BLACK);
        g.setXORMode(Color.WHITE);
        this.drawPolygon(g, p, 3);
    }

    private void drawPolygon(Graphics2D g, Polygon p, int thickness) {
        Point center = this.getCenterOfGravity(p);
        for (int i = 0; i < thickness; ++i) {
            g.drawPolygon(p);
            this.gravitate(p, center, 1);
        }
    }

    private void gravitate(Polygon p, Point center, int step) {
        int len = p.npoints;
        int i = 0;
        while (i < len) {
            int deltaX = center.x > p.xpoints[i] ? step : -step;
            int deltaY = center.y > p.ypoints[i] ? step : -step;
            int n = i;
            p.xpoints[n] = p.xpoints[n] + deltaX;
            int n2 = i++;
            p.ypoints[n2] = p.ypoints[n2] + deltaY;
        }
    }

    private Point getCenterOfGravity(Polygon p) {
        int x = 0;
        int y = 0;
        int len = p.npoints;
        for (int i = 0; i < len; ++i) {
            x += p.xpoints[i];
            y += p.ypoints[i];
        }
        return new Point(x / len, y / len);
    }
}

