/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class ServerHello {
    private static final byte[] HELLO_RETRY_REQUEST_MAGIC = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    private final ProtocolVersion version;
    private final byte[] random;
    private final byte[] sessionID;
    private final int cipherSuite;
    private final Hashtable extensions;

    public ServerHello(byte[] byArray, int n, Hashtable hashtable) {
        this(ProtocolVersion.TLSv12, Arrays.clone(HELLO_RETRY_REQUEST_MAGIC), byArray, n, hashtable);
    }

    public ServerHello(ProtocolVersion protocolVersion, byte[] byArray, byte[] byArray2, int n, Hashtable hashtable) {
        this.version = protocolVersion;
        this.random = byArray;
        this.sessionID = byArray2;
        this.cipherSuite = n;
        this.extensions = hashtable;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public Hashtable getExtensions() {
        return this.extensions;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public boolean isHelloRetryRequest() {
        return Arrays.areEqual(HELLO_RETRY_REQUEST_MAGIC, this.random);
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream) throws IOException {
        TlsUtils.writeVersion(this.version, outputStream);
        outputStream.write(this.random);
        TlsUtils.writeOpaque8(this.sessionID, outputStream);
        TlsUtils.writeUint16(this.cipherSuite, outputStream);
        TlsUtils.writeUint8((short)0, outputStream);
        TlsProtocol.writeExtensions(outputStream, this.extensions);
    }

    public static ServerHello parse(ByteArrayInputStream byteArrayInputStream) throws IOException {
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream, 0, 32);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (0 != s2) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = TlsProtocol.readExtensions(byteArrayInputStream);
        return new ServerHello(protocolVersion, byArray, byArray2, n, hashtable);
    }
}

