/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.MediaSources;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpReceiverEventHandler;
import org.jitsi.nlj.RtpReceiverImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.RtpReceiverStats;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.nlj.util.StreamInformationStoreImpl;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.message.AddReceiverMessage;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.relay.RelayedPacketInfo;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001[B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020\"H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00103\u001a\u00020/2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020/2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020\"H\u0016J\u0018\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020>H\u0014J\u0006\u0010?\u001a\u00020/J\u000e\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u00020/2\u0006\u0010M\u001a\u00020NH\u0016J\u0016\u0010O\u001a\u00020/2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\"J\u0006\u0010S\u001a\u00020TJ\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\b\u0010Y\u001a\u00020/H\u0002J\b\u0010Z\u001a\u00020/H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010%\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010$0$0&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\"X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u00101\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010,R\u0014\u00102\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010,R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020C0B8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006\\"}, d2={"Lorg/jitsi/videobridge/relay/RelayedEndpoint;", "Lorg/jitsi/videobridge/AbstractEndpoint;", "Lorg/jitsi/videobridge/relay/Relay$IncomingRelayPacketHandler;", "conference", "Lorg/jitsi/videobridge/Conference;", "relay", "Lorg/jitsi/videobridge/relay/Relay;", "id", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/videobridge/Conference;Lorg/jitsi/videobridge/relay/Relay;Ljava/lang/String;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "getRelay", "()Lorg/jitsi/videobridge/relay/Relay;", "value", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "audioSources", "getAudioSources", "()Ljava/util/List;", "setAudioSources", "(Ljava/util/List;)V", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStore;", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "getRtcpEventNotifier", "()Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "rtpReceiver", "Lorg/jitsi/nlj/RtpReceiverImpl;", "receivesSsrc", "", "ssrc", "", "ssrcs", "Ljava/util/HashSet;", "kotlin.jvm.PlatformType", "getSsrcs", "()Ljava/util/HashSet;", "visitor", "getVisitor", "()Z", "shouldExpire", "requestKeyframe", "", "mediaSsrc", "isSendingAudio", "isSendingVideo", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "setExtmapAllowMixed", "allow", "sendVideoConstraints", "sourceName", "maxVideoConstraints", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "relayMessageTransportConnected", "_mediaSources", "Lorg/jitsi/nlj/MediaSources;", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "mediaSources", "getMediaSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "setMediaSources", "([Lorg/jitsi/nlj/MediaSourceDesc;)V", "setSrtpInformation", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "handleIncomingPacket", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "setFeature", "feature", "Lorg/jitsi/nlj/Features;", "enabled", "getIncomingStats", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "debugState", "Lorg/json/simple/JSONObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "updateStatsOnExpire", "expire", "RtpReceiverEventHandlerImpl", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nRelayedEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelayedEndpoint.kt\norg/jitsi/videobridge/relay/RelayedEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,255:1\n1855#2,2:256\n1855#2,2:262\n215#3,2:258\n13309#4:260\n13309#4:261\n13310#4:264\n13310#4:265\n63#5,4:266\n*S KotlinDebug\n*F\n+ 1 RelayedEndpoint.kt\norg/jitsi/videobridge/relay/RelayedEndpoint\n*L\n63#1:256,2\n178#1:262,2\n158#1:258,2\n176#1:260\n177#1:261\n177#1:264\n176#1:265\n229#1:266,4\n*E\n"})
public final class RelayedEndpoint
extends AbstractEndpoint
implements Relay.IncomingRelayPacketHandler {
    @NotNull
    private final Relay relay;
    @NotNull
    private List<AudioSourceDesc> audioSources;
    @NotNull
    private final StreamInformationStore streamInformationStore;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final RtpReceiverImpl rtpReceiver;
    private final boolean visitor;
    @NotNull
    private final MediaSources _mediaSources;

    /*
     * WARNING - void declaration
     */
    public RelayedEndpoint(@NotNull Conference conference, @NotNull Relay relay, @NotNull String id, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        void $this$rtpReceiver_u24lambda_u243;
        Object $this$rtcpEventNotifier_u24lambda_u241;
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(relay, "relay");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        super(conference, id, parentLogger);
        this.relay = relay;
        this.audioSources = CollectionsKt.emptyList();
        this.streamInformationStore = new StreamInformationStoreImpl();
        Object object = new RtcpEventNotifier();
        RtcpEventNotifier rtcpEventNotifier2 = object;
        RelayedEndpoint relayedEndpoint = this;
        boolean bl = false;
        ((RtcpEventNotifier)$this$rtcpEventNotifier_u24lambda_u241).addRtcpEventListener(new RtcpListener(this, id){
            final /* synthetic */ RelayedEndpoint this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
            }

            public void rtcpPacketReceived(RtcpPacket packet, Instant receivedTime) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.getRelay().rtcpPacketReceived(packet, receivedTime, this.$id);
            }

            public void rtcpPacketSent(RtcpPacket packet) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                throw new IllegalStateException("got rtcpPacketSent callback from a receiver");
            }
        }, true);
        relayedEndpoint.rtcpEventNotifier = object;
        String string = this.relay.getId() + "-" + id;
        Function1<RtcpPacket, Unit> function1 = arg_0 -> RelayedEndpoint.rtpReceiver$lambda$2(this, arg_0);
        ExecutorService executorService = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        $this$rtcpEventNotifier_u24lambda_u241 = object = new RtpReceiverImpl(string, function1, this.rtcpEventNotifier, executorService, scheduledExecutorService, this.streamInformationStore, new RtpReceiverEventHandlerImpl(), this.getLogger(), diagnosticContext);
        relayedEndpoint = this;
        boolean bl2 = false;
        $this$rtpReceiver_u24lambda_u243.setPacketHandler(new ConsumerNode(id, conference){
            final /* synthetic */ String $id;
            final /* synthetic */ Conference $conference;
            {
                this.$id = $id;
                this.$conference = $conference;
                super("receiver chain handler");
            }

            protected void consume(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                packetInfo.setEndpointId(this.$id);
                this.$conference.handleIncomingPacket(packetInfo);
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        });
        $this$rtpReceiver_u24lambda_u243.handleEvent(new SetLocalSsrcEvent(MediaType.AUDIO, conference.getLocalAudioSsrc()));
        $this$rtpReceiver_u24lambda_u243.handleEvent(new SetLocalSsrcEvent(MediaType.VIDEO, conference.getLocalVideoSsrc()));
        relayedEndpoint.rtpReceiver = object;
        this._mediaSources = new MediaSources();
    }

    @NotNull
    public final Relay getRelay() {
        return this.relay;
    }

    @Override
    @NotNull
    public List<AudioSourceDesc> getAudioSources() {
        return this.audioSources;
    }

    @Override
    public void setAudioSources(@NotNull List<AudioSourceDesc> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.audioSources = value2;
        Iterable $this$forEach$iv = value2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AudioSourceDesc it = (AudioSourceDesc)element$iv;
            boolean bl = false;
            this.streamInformationStore.addReceiveSsrc(it.getSsrc(), MediaType.AUDIO);
            this.getConference().addEndpointSsrc(this, it.getSsrc());
        }
    }

    @NotNull
    public final RtcpEventNotifier getRtcpEventNotifier() {
        return this.rtcpEventNotifier;
    }

    @Override
    public boolean receivesSsrc(long ssrc) {
        return this.streamInformationStore.getReceiveSsrcs().contains(ssrc);
    }

    @NotNull
    public HashSet<Long> getSsrcs() {
        return new HashSet<Long>((Collection)this.streamInformationStore.getReceiveSsrcs());
    }

    @Override
    public boolean getVisitor() {
        return this.visitor;
    }

    @Override
    public boolean shouldExpire() {
        return false;
    }

    @Override
    public void requestKeyframe(long mediaSsrc) {
        this.relay.getTransceiver().requestKeyFrame(mediaSsrc);
    }

    @Override
    public void requestKeyframe() {
        MediaSourceDesc mediaSourceDesc = this.getMediaSource();
        this.relay.getTransceiver().requestKeyFrame(mediaSourceDesc != null ? Long.valueOf(mediaSourceDesc.getPrimarySSRC()) : null);
    }

    @Override
    public boolean isSendingAudio() {
        return this.rtpReceiver.isReceivingAudio();
    }

    @Override
    public boolean isSendingVideo() {
        return this.rtpReceiver.isReceivingVideo();
    }

    @Override
    public void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.streamInformationStore.addRtpPayloadType(payloadType);
    }

    @Override
    public void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        this.streamInformationStore.addRtpExtensionMapping(rtpExtension);
    }

    @Override
    public void setExtmapAllowMixed(boolean allow) {
        this.streamInformationStore.setExtmapAllowMixed(allow);
    }

    @Override
    protected void sendVideoConstraints(@NotNull String sourceName, @NotNull VideoConstraints maxVideoConstraints) {
        Intrinsics.checkNotNullParameter(sourceName, "sourceName");
        Intrinsics.checkNotNullParameter(maxVideoConstraints, "maxVideoConstraints");
        this.relay.sendMessage(new AddReceiverMessage(RelayConfig.config.getRelayId(), null, sourceName, maxVideoConstraints));
    }

    public final void relayMessageTransportConnected() {
        Map<String, VideoConstraints> $this$forEach$iv = this.getMaxReceiverVideoConstraints();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, VideoConstraints>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, VideoConstraints> element$iv;
            Map.Entry<String, VideoConstraints> entry = element$iv = iterator2.next();
            boolean bl = false;
            String sourceName = entry.getKey();
            VideoConstraints constraints = entry.getValue();
            this.sendVideoConstraints(sourceName, constraints);
        }
    }

    @Override
    @NotNull
    public MediaSourceDesc[] getMediaSources() {
        return this._mediaSources.getMediaSources();
    }

    public void setMediaSources(@NotNull MediaSourceDesc[] value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.applyVideoTypeCache(value2);
        boolean changed = this._mediaSources.setMediaSources(value2);
        MediaSourceDesc[] mergedMediaSources = this._mediaSources.getMediaSources();
        MediaSourceDesc[] signaledMediaSources = MediaSourceDescKt.copy(value2);
        if (changed) {
            SetMediaSourcesEvent setMediaSourcesEvent = new SetMediaSourcesEvent(mergedMediaSources, signaledMediaSources);
            this.rtpReceiver.handleEvent(setMediaSourcesEvent);
            MediaSourceDesc[] $this$forEach$iv = this.getMediaSources();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                RtpEncodingDesc[] $this$forEach$iv2 = it.getRtpEncodings();
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    RtpEncodingDesc element$iv2;
                    RtpEncodingDesc it2 = element$iv2 = $this$forEach$iv2[j];
                    boolean bl2 = false;
                    Iterable $this$forEach$iv3 = it2.getSsrcs();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        long it3 = ((Number)element$iv3).longValue();
                        boolean bl3 = false;
                        this.streamInformationStore.addReceiveSsrc(it3, MediaType.VIDEO);
                        this.getConference().addEndpointSsrc(this, it3);
                    }
                }
            }
        }
    }

    public final void setSrtpInformation(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.rtpReceiver.setSrtpTransformers(srtpTransformers);
    }

    @Override
    public void handleIncomingPacket(@NotNull RelayedPacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        this.rtpReceiver.enqueuePacket(packetInfo);
    }

    public final void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        this.rtpReceiver.setFeature(feature, enabled2);
    }

    @NotNull
    public final PacketStreamStats.Snapshot getIncomingStats() {
        return this.rtpReceiver.getStats().getPacketStreamStats();
    }

    @Override
    @NotNull
    public JSONObject debugState(@NotNull DebugStateMode mode) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        JSONObject $this$debugState_u24lambda_u248 = jSONObject = super.debugState(mode);
        boolean bl = false;
        if (mode == DebugStateMode.FULL) {
            ((Map)$this$debugState_u24lambda_u248).put("stream_information_store", this.streamInformationStore.debugState(mode));
            ((Map)$this$debugState_u24lambda_u248).put("receiver", this.rtpReceiver.debugState(mode));
            ((Map)$this$debugState_u24lambda_u248).put("media_sources", this._mediaSources.debugState());
        }
        return jSONObject;
    }

    private final void updateStatsOnExpire() {
        Relay.Statistics statistics;
        Relay.Statistics relayStats = this.relay.getStatistics();
        RtpReceiverStats rtpReceiverStats = this.rtpReceiver.getStats();
        PacketStreamStats.Snapshot incomingStats = rtpReceiverStats.getPacketStreamStats();
        Relay.Statistics $this$updateStatsOnExpire_u24lambda_u249 = statistics = relayStats;
        boolean bl = false;
        $this$updateStatsOnExpire_u24lambda_u249.getBytesReceived().getAndAdd(incomingStats.getBytes());
        $this$updateStatsOnExpire_u24lambda_u249.getPacketsReceived().getAndAdd(incomingStats.getPackets());
    }

    @Override
    public void expire() {
        if (super.isExpired()) {
            return;
        }
        super.expire();
        try {
            this.updateStatsOnExpire();
            this.rtpReceiver.stop();
            Logger $this$cdebug$iv = this.getLogger();
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                String string = this.debugState(DebugStateMode.FULL).toJSONString();
                Intrinsics.checkNotNullExpressionValue(string, "toJSONString(...)");
                logger.debug(string);
            }
            this.rtpReceiver.tearDown();
        }
        catch (Throwable t2) {
            this.getLogger().error("Exception while expiring: ", t2);
        }
        this.getLogger().info("Expired.");
    }

    private static final Unit rtpReceiver$lambda$2(RelayedEndpoint this$0, RtcpPacket rtcpPacket) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(rtcpPacket, "rtcpPacket");
        if (rtcpPacket.length >= 1500) {
            this$0.getLogger().warn("Sending large locally-generated RTCP packet of size " + rtcpPacket.length + ", first packet of type " + rtcpPacket.getPacketType() + " rc " + rtcpPacket.getReportCount() + ".");
        }
        this$0.relay.getTransceiver().sendPacket(new PacketInfo(rtcpPacket, 0, null, 6, null));
        return Unit.INSTANCE;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0017\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/relay/RelayedEndpoint$RtpReceiverEventHandlerImpl;", "Lorg/jitsi/nlj/RtpReceiverEventHandler;", "<init>", "(Lorg/jitsi/videobridge/relay/RelayedEndpoint;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(J)V", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nRelayedEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelayedEndpoint.kt\norg/jitsi/videobridge/relay/RelayedEndpoint$RtpReceiverEventHandlerImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,255:1\n63#2,4:256\n*S KotlinDebug\n*F\n+ 1 RelayedEndpoint.kt\norg/jitsi/videobridge/relay/RelayedEndpoint$RtpReceiverEventHandlerImpl\n*L\n250#1:256,4\n*E\n"})
    private final class RtpReceiverEventHandlerImpl
    implements RtpReceiverEventHandler {
        @Override
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            return RelayedEndpoint.this.getConference().levelChanged(RelayedEndpoint.this, level);
        }

        @Override
        public void bandwidthEstimationChanged-_2icLw0(long newValue) {
            Logger $this$cdebug$iv = RelayedEndpoint.this.getLogger();
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Estimated bandwidth is now " + Bandwidth.toString-impl(newValue));
            }
        }
    }
}

