/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.mucclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;

public class MucClientConfiguration {
    private static final Logger logger = Logger.getLogger(MucClientConfiguration.class);
    public static String HOSTNAME = "HOSTNAME";
    public static String PORT = "PORT";
    public static String DOMAIN = "DOMAIN";
    public static String USERNAME = "USERNAME";
    public static String PASSWORD = "PASSWORD";
    public static String MUC_JIDS = "MUC_JIDS";
    public static String MUC_NICKNAME = "MUC_NICKNAME";
    public static String DISABLE_CERTIFICATE_VERIFICATION = "DISABLE_CERTIFICATE_VERIFICATION";
    public static String IQ_HANDLER_MODE = "IQ_HANDLER_MODE";
    public static String SECURITY_MODE = "SECURITY_MODE";
    private final HashMap<String, String> props = new HashMap();
    private final String id;

    public static Collection<MucClientConfiguration> loadFromConfigService(ConfigurationService config, String prefix, boolean removeIncomplete) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String pname : config.getPropertyNamesByPrefix(prefix, false)) {
            properties.put(pname, config.getString(pname));
        }
        return MucClientConfiguration.loadFromMap(properties, prefix, removeIncomplete);
    }

    public static Collection<MucClientConfiguration> loadFromMap(Map<String, String> properties, String prefix, boolean removeIncomplete) {
        HashMap<String, MucClientConfiguration> configurations = new HashMap<String, MucClientConfiguration>();
        for (String pname : properties.keySet()) {
            String stripped = pname.substring(prefix.length());
            String id = "";
            String prop = stripped;
            if (stripped.contains(".")) {
                id = stripped.substring(0, stripped.indexOf("."));
                prop = stripped.substring(id.length() + 1);
            }
            MucClientConfiguration c2 = configurations.computeIfAbsent(id, MucClientConfiguration::new);
            c2.setProperty(prop, properties.get(pname));
        }
        if (removeIncomplete) {
            configurations.values().removeIf(c -> {
                if (!c.isComplete()) {
                    logger.warn("Ignoring incomplete configuration with id=" + c.getId());
                    return true;
                }
                return false;
            });
        }
        return configurations.values();
    }

    public MucClientConfiguration(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getHostname() {
        return this.props.get(HOSTNAME.toUpperCase());
    }

    public void setHostname(String hostname) {
        this.props.put(HOSTNAME, hostname);
    }

    public String getPort() {
        return this.props.get(PORT.toUpperCase());
    }

    public void setPort(String port2) {
        this.props.put(PORT, port2);
    }

    public String getDomain() {
        return this.props.get(DOMAIN.toUpperCase());
    }

    public void setDomain(String domain) {
        this.props.put(DOMAIN, domain);
    }

    public String getUsername() {
        return this.props.get(USERNAME.toUpperCase());
    }

    public void setUsername(String username) {
        this.props.put(USERNAME, username);
    }

    public String getPassword() {
        return this.props.get(PASSWORD.toUpperCase());
    }

    public void setPassword(String password) {
        this.props.put(PASSWORD, password);
    }

    public List<String> getMucJids() {
        String str = this.props.get(MUC_JIDS.toUpperCase());
        if (str != null) {
            return Arrays.asList(str.split(","));
        }
        return null;
    }

    public void setMucJids(List<String> mucJids) {
        this.props.put(MUC_JIDS, String.join((CharSequence)",", mucJids));
    }

    public String getMucNickname() {
        return this.props.get(MUC_NICKNAME.toUpperCase());
    }

    public void setMucNickname(String mucNickname) {
        this.props.put(MUC_NICKNAME, mucNickname);
    }

    public boolean getDisableCertificateVerification() {
        return Boolean.parseBoolean(this.props.get(DISABLE_CERTIFICATE_VERIFICATION));
    }

    public void setDisableCertificateVerification(boolean disableCertificateVerification) {
        this.props.put(DISABLE_CERTIFICATE_VERIFICATION, Boolean.TRUE.toString());
    }

    public String getIqHandlerMode() {
        return this.props.get(IQ_HANDLER_MODE);
    }

    public void setIqHandlerMode(String iqHandlerMode) {
        this.props.put(IQ_HANDLER_MODE, iqHandlerMode);
    }

    public ConnectionConfiguration.SecurityMode getSecurityMode() {
        String securityModeStr = this.props.get(SECURITY_MODE);
        if (securityModeStr == null) {
            return null;
        }
        return ConnectionConfiguration.SecurityMode.valueOf(securityModeStr);
    }

    public void setSecurityMode(ConnectionConfiguration.SecurityMode securityMode) {
        this.props.put(SECURITY_MODE, securityMode != null ? securityMode.toString() : null);
    }

    public boolean isComplete() {
        try {
            this.getSecurityMode();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return this.getHostname() != null && this.getUsername() != null && this.getPassword() != null && this.getMucJids() != null && this.getMucNickname() != null;
    }

    public void setProperty(String name, String value2) {
        this.props.put(name.toUpperCase(), value2);
    }

    public String toString() {
        return "[ " + MucClientConfiguration.class.getName() + " id=" + this.id + " domain=" + this.getDomain() + " hostname=" + this.getHostname() + " port=" + this.getPort() + " username=" + this.getUsername() + " mucs=" + String.valueOf(this.getMucJids()) + " mucNickname=" + this.getMucNickname() + " disableCertificateVerification=" + this.getDisableCertificateVerification() + "]";
    }
}

