/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.minidns.dnsname.DnsName;
import org.minidns.record.SRV;

public abstract class DNSResolver {
    protected static final Logger LOGGER = Logger.getLogger(DNSResolver.class.getName());
    private final boolean supportsDnssec;

    protected DNSResolver(boolean supportsDnssec) {
        this.supportsDnssec = supportsDnssec;
    }

    public final Collection<SRV> lookupSrvRecords(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        return this.lookupSrvRecords0(name, lookupFailures, dnssecMode);
    }

    protected abstract Collection<SRV> lookupSrvRecords0(DnsName var1, List<RemoteConnectionEndpointLookupFailure> var2, ConnectionConfiguration.DnssecMode var3);

    public final List<InetAddress> lookupHostAddress(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        return this.lookupHostAddress0(name, lookupFailures, dnssecMode);
    }

    protected List<InetAddress> lookupHostAddress0(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        InetAddress[] inetAddressArray;
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(name.toString());
        }
        catch (UnknownHostException e) {
            lookupFailures.add(new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)e));
            return null;
        }
        return Arrays.asList(inetAddressArray);
    }

    protected static boolean shouldContinue(CharSequence name, CharSequence hostname, List<InetAddress> hostAddresses) {
        if (hostAddresses == null) {
            return true;
        }
        if (hostAddresses.isEmpty()) {
            LOGGER.log(Level.INFO, "The DNS name " + name + ", points to a hostname (" + hostname + ") which has neither A or AAAA resource records. This is an indication of a broken DNS setup.");
            return true;
        }
        return false;
    }

    private void checkIfDnssecRequestedAndSupported(ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled && !this.supportsDnssec) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
    }
}

