/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.SQLException;
import java.util.Vector;
import org.parosproxy.paros.core.spider.SpiderListener;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.TableSession;

public class Database {
    private static Database database = null;
    private DatabaseServer databaseServer = null;
    private TableHistory tableHistory = null;
    private TableSession tableSession = null;
    private TableAlert tableAlert = null;
    private TableScan tableScan = null;
    private Vector listenerList = new Vector();

    public Database() {
        this.tableHistory = new TableHistory();
        this.tableSession = new TableSession();
        this.tableAlert = new TableAlert();
        this.tableScan = new TableScan();
        this.addDatabaseListener(this.tableHistory);
        this.addDatabaseListener(this.tableSession);
        this.addDatabaseListener(this.tableAlert);
        this.addDatabaseListener(this.tableScan);
    }

    public DatabaseServer getDatabaseServer() {
        return this.databaseServer;
    }

    private void setDatabaseServer(DatabaseServer databaseServer) {
        this.databaseServer = databaseServer;
    }

    private void setTableHistory(TableHistory tableHistory) {
        this.tableHistory = tableHistory;
    }

    public TableHistory getTableHistory() {
        return this.tableHistory;
    }

    public TableSession getTableSession() {
        return this.tableSession;
    }

    private void setTableSession(TableSession tableSession) {
        this.tableSession = tableSession;
    }

    public static Database getSingleton() {
        if (database == null) {
            database = new Database();
        }
        return database;
    }

    public void addDatabaseListener(DatabaseListener databaseListener) {
        this.listenerList.add(databaseListener);
    }

    public void removeDatabaseListener(SpiderListener spiderListener) {
        this.listenerList.remove(spiderListener);
    }

    private void notifyListenerDatabaseOpen() throws SQLException {
        DatabaseListener databaseListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            databaseListener = (DatabaseListener)this.listenerList.get(i);
            databaseListener.databaseOpen(this.getDatabaseServer());
        }
    }

    public void open(String string) throws ClassNotFoundException, Exception {
        this.setDatabaseServer(new DatabaseServer(string));
        this.notifyListenerDatabaseOpen();
    }

    public void close(boolean bl) {
        if (this.databaseServer == null) {
            return;
        }
        try {
            this.getTableHistory().deleteTemporary();
            this.getDatabaseServer().shutdown(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TableAlert getTableAlert() {
        return this.tableAlert;
    }

    public void setTableAlert(TableAlert tableAlert) {
        this.tableAlert = tableAlert;
    }

    public TableScan getTableScan() {
        return this.tableScan;
    }

    public void setTableScan(TableScan tableScan) {
        this.tableScan = tableScan;
    }
}

