/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.DirectoryItem;
import com.intellij.util.io.FileItem;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.Item;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.intellij.xdebugger.XDebugSession;
import io.netty.util.CharsetUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0000\u001a\u001c\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0001\u001a&\u0010$\u001a\u0004\u0018\u00010\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\b\u001a\u0012\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\bH\u0002\u001a\u0012\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a$\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-H\u0002\u001a\u0010\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u001a\u0010/\u001a\u0004\u0018\u00010\f*\u00020\u001e2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0014\u00100\u001a\u0004\u0018\u00010\u0001*\u0002012\u0006\u0010\r\u001a\u00020\u0001\u001a\n\u00102\u001a\u000203*\u00020\b\u001a\n\u00104\u001a\u00020 *\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"ASAR", "", "REFERENCE_LINE", "REFERENCE_PATTERN_FILE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REFERENCE_PATTERN_LINE", "canonicalizeUrl", "Lcom/intellij/util/Url;", "url", "baseUrl", "decodeLocalSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "path", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "decodeString", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "charBuffer", "Ljava/nio/CharBuffer;", "findSourceMap", "parsedUrl", "findSourceMapLocally", "script", "Lorg/jetbrains/debugger/Script;", "getSourceMapUrl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/nio/file/Path;", "string", "", "pattern", "getStringFromDataUri", "dataUrl", "loadFromDataUri", "sourceMapUrl", "baseFileUrl", "loadRemoteSourceMapData", "regularFile", "tail", "channel", "Ljava/nio/channels/SeekableByteChannel;", "size", "", "offset", "decodeSourceMap", "getSourceMapUrlFromAsar", "Lcom/intellij/util/io/AsarFileSystem;", "isInternalNodeJsScript", "", "loadFile", "intellij.javascript.debugger"})
public final class SourceMapLoaderKt {
    @NotNull
    public static final String ASAR = ".asar/";
    private static final String REFERENCE_LINE = "//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$";
    private static final Pattern REFERENCE_PATTERN_FILE;
    private static final Pattern REFERENCE_PATTERN_LINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getSourceMapUrlFromAsar(@NotNull AsarFileSystem $receiver, @NotNull String path) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileItem fileItem = $receiver.getFile(path);
        if (fileItem != null) {
            FileItem fileItem2;
            FileItem fileItem3 = fileItem2 = fileItem;
            Closeable closeable = $receiver.openFileChannel();
            Throwable throwable = null;
            try {
                SeekableByteChannel it = (SeekableByteChannel)closeable;
                CharSequence charSequence = SourceMapLoaderKt.tail(it, fileItem3.getSize(), fileItem3.getOffset());
                Pattern pattern = REFERENCE_PATTERN_LINE;
                Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
                String string2 = SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string = null;
        }
        return string;
    }

    public static final boolean isInternalNodeJsScript(@NotNull Url $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return !FileUtil.isAbsolutePlatformIndependent((String)$receiver.getPath()) && Intrinsics.areEqual((Object)$receiver.getPath(), (Object)"evalmachine.<anonymous>") ^ true;
    }

    @Nullable
    public static final SourceMap findSourceMapLocally(@NotNull Script script, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        if (SourceMapLoaderKt.isInternalNodeJsScript(script.getUrl())) {
            return null;
        }
        String string = script.getUrl().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.url.path");
        String scriptPath = string;
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)ASAR, (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            Object object = scriptPath;
            int n = 0;
            int n2 = index + 5;
            JavaScriptDebugProcess<?> javaScriptDebugProcess = debugProcess;
            String string2 = object;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            AsarFileSystem asarFileSystem = javaScriptDebugProcess.getAsarFs$intellij_javascript_debugger(string4);
            if (asarFileSystem != null) {
                Object fs = object = asarFileSystem;
                String string5 = scriptPath;
                int n3 = index + ASAR.length();
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                String scriptRelativePath = string7;
                String string8 = SourceMapLoaderKt.getSourceMapUrlFromAsar((AsarFileSystem)fs, scriptRelativePath);
                if (string8 != null) {
                    SourceMap sourceMap;
                    string5 = string8;
                    String url = string5;
                    Object object2 = url;
                    if (object2.length() == 0) {
                        return null;
                    }
                    if (URLUtil.isDataUri((String)url)) {
                        return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
                    }
                    if (FileUtil.isAbsolutePlatformIndependent((String)url)) {
                        return SourceMapLoaderKt.decodeLocalSourceMap(url, debugProcess);
                    }
                    String string9 = PathUtilRt.getParentPath((String)scriptRelativePath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"PathUtilRt.getParentPath(scriptRelativePath)");
                    DirectoryItem directoryItem = ((AsarFileSystem)fs).getDir(string9);
                    Item item = directoryItem != null ? directoryItem.findChild(url) : null;
                    if (!(item instanceof FileItem)) {
                        item = null;
                    }
                    FileItem fileItem = (FileItem)item;
                    if (fileItem != null) {
                        CharSequence charSequence;
                        Object it = object2 = fileItem;
                        CharSequence it2 = charSequence = ((AsarFileSystem)fs).loadText((FileItem)it);
                        sourceMap = debugProcess.decodeSourceMap(it2, script.getUrl(), true);
                    } else {
                        sourceMap = null;
                    }
                    return sourceMap;
                }
            }
        }
        if ((path = SourceMapLoaderKt.regularFile(scriptPath)) == null) {
            XDebugSession xDebugSession = debugProcess.getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
            Project project = xDebugSession.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            VirtualFile virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(scriptPath, project);
            if (virtualFile != null) {
                VirtualFile fs;
                VirtualFile it = fs = virtualFile;
                String string10 = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"it.path");
                path = SourceMapLoaderKt.regularFile(string10);
            } else {
                path = null;
            }
        }
        if (path == null) {
            return null;
        }
        Path path2 = path;
        String url = SourceMapLoaderKt.getSourceMapUrl(path2);
        if (url == null) {
            Path mapPath = path2.getParent().resolve(path2.getFileName() + ".map");
            if (Files.isRegularFile(mapPath, new LinkOption[0]) && Files.getLastModifiedTime(mapPath, new LinkOption[0]).toMillis() + (long)100 >= Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis()) {
                Path path3 = mapPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"mapPath");
                return debugProcess.decodeSourceMap(PathKt.readChars((Path)path3), script.getUrl(), true);
            }
            return null;
        }
        CharSequence charSequence = url;
        if (charSequence.length() == 0) {
            return null;
        }
        if (URLUtil.isDataUri((String)url)) {
            return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
        }
        Path path4 = path2.getParent().resolve(url);
        Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"path.parent.resolve(url)");
        return SourceMapLoaderKt.decodeSourceMap(path4, debugProcess);
    }

    private static final SourceMap decodeLocalSourceMap(String path, JavaScriptDebugProcess<?> debugProcess) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return SourceMapLoaderKt.decodeSourceMap(path2, debugProcess);
    }

    private static final SourceMap decodeSourceMap(@NotNull Path $receiver, JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMap;
        if (Files.isRegularFile($receiver, new LinkOption[0])) {
            CharSequence charSequence;
            Path path = $receiver.normalize();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"normalize()");
            CharSequence it = charSequence = PathKt.readChars((Path)path);
            sourceMap = debugProcess.decodeSourceMap(it, Urls.newLocalFileUrl((String)((Object)$receiver).toString()), true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    private static final SourceMap loadFromDataUri(JavaScriptDebugProcess<?> debugProcess, Script script, String url) {
        SourceMap sourceMap;
        CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(url, script.getUrl());
        if (charSequence != null) {
            CharSequence charSequence2;
            CharSequence it = charSequence2 = charSequence;
            sourceMap = debugProcess.decodeSourceMap(it, script.getUrl(), true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    @Nullable
    public static final Path regularFile(@NotNull String path) {
        Path path2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path it = path2 = Paths.get(path, new String[0]);
        return Files.isRegularFile(it, new LinkOption[0]) ? it : null;
    }

    @Nullable
    public static final SourceMap findSourceMap(@NotNull Url parsedUrl, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMap;
        Intrinsics.checkParameterIsNotNull((Object)parsedUrl, (String)"parsedUrl");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        DebuggableFileFinder debuggableFileFinder = debugProcess.getFinder();
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        VirtualFile sourceMapFile = debuggableFileFinder.findFile(parsedUrl, project, false, null, null);
        if (sourceMapFile != null) {
            sourceMapFile.refresh(false, false);
            String string = VfsUtil.loadText((VirtualFile)sourceMapFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtil.loadText(sourceMapFile)");
            return debugProcess.decodeSourceMap(string, Urls.newLocalFileUrl((VirtualFile)sourceMapFile), true);
        }
        if (parsedUrl.isInLocalFileSystem()) {
            String string = parsedUrl.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUrl.path");
            return SourceMapLoaderKt.decodeLocalSourceMap(string, debugProcess);
        }
        if (!Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"https")) {
            CommandProcessorKt.getLOG().warn("Cannot load source map from '" + parsedUrl + "': scheme " + parsedUrl.getScheme() + " is not supported");
            return null;
        }
        CharSequence charSequence = SourceMapLoaderKt.loadRemoteSourceMapData(parsedUrl);
        if (charSequence != null) {
            CharSequence charSequence2;
            CharSequence it = charSequence2 = charSequence;
            sourceMap = debugProcess.decodeSourceMap(it, parsedUrl, true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private static final CharSequence loadRemoteSourceMapData(Url parsedUrl) {
        CharSequence charSequence;
        long start = System.nanoTime();
        String string = parsedUrl.toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUrl.toExternalForm()");
        String url = string;
        try {
            CharSequence result2;
            CharSequence charSequence2 = HttpRequests.request((Url)parsedUrl).productNameAsUserAgent().tuner(new HttpRequests.ConnectionTuner(parsedUrl){
                final /* synthetic */ Url $parsedUrl;

                public final void tune(@NotNull URLConnection it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (BuiltInServerManager.getInstance().isOnBuiltInWebServer(this.$parsedUrl)) {
                        it.setRequestProperty("x-ijt", BuiltInWebServerKt.acquireToken());
                    }
                }
                {
                    this.$parsedUrl = url;
                }
            }).readChars();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"HttpRequests.request(par\u2026     }\n      .readChars()");
            charSequence = result2 = charSequence2;
            charSequence = charSequence.length() == 0 ? null : result2;
        }
        catch (HttpRequests.HttpStatusException e) {
            CommandProcessorKt.getLOG().debug((Throwable)e);
            CharSequence charSequence3 = null;
            Logger $receiver$iv = CommandProcessorKt.getLOG();
            Exception e$iv = null;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string2 = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
                String string32 = string2;
                logger.debug(string32, (Throwable)e$iv);
            }
            return charSequence3;
        }
        catch (Exception e2) {
            CommandProcessorKt.getLOG().error((Throwable)e2);
            {
                catch (Throwable throwable) {
                    Logger $receiver$iv = CommandProcessorKt.getLOG();
                    Exception e$iv = null;
                    if ($receiver$iv.isDebugEnabled()) {
                        Logger logger = $receiver$iv;
                        String string4 = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
                        String string5 = string4;
                        logger.debug(string5, (Throwable)e$iv);
                    }
                    throw throwable;
                }
            }
            Logger $receiver$iv2 = CommandProcessorKt.getLOG();
            Exception e$iv2 = null;
            if ($receiver$iv2.isDebugEnabled()) {
                Logger logger = $receiver$iv2;
                String string6 = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
                String string7 = string6;
                logger.debug(string7, (Throwable)e$iv2);
            }
        }
        Logger $receiver$iv = CommandProcessorKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string8 = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
            String string9 = string8;
            logger.debug(string9, (Throwable)e$iv);
        }
        return charSequence;
        return null;
    }

    @Nullable
    public static final String getStringFromDataUri(@NotNull String dataUrl) {
        Intrinsics.checkParameterIsNotNull((Object)dataUrl, (String)"dataUrl");
        Matcher matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl));
        if (matcher.matches()) {
            try {
                String string;
                String content = matcher.group(4);
                if (StringsKt.equals((String)";base64", (String)matcher.group(3), (boolean)true)) {
                    byte[] byArray = Base64.getDecoder().decode(content);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(content)");
                    byte[] byArray2 = byArray;
                    Charset charset = Charsets.UTF_8;
                    string = new String(byArray2, charset);
                } else {
                    string = content;
                }
                return string;
            }
            catch (IllegalArgumentException e) {
                CommandProcessorKt.getLOG().warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static final CharSequence loadFromDataUri(@NotNull String sourceMapUrl, @NotNull Url baseFileUrl) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMapUrl, (String)"sourceMapUrl");
        Intrinsics.checkParameterIsNotNull((Object)baseFileUrl, (String)"baseFileUrl");
        String string = baseFileUrl.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseFileUrl.path");
        if (StringsKt.endsWith$default((String)string, (String)"nodent.min.js", (boolean)false, (int)2, null)) {
            return null;
        }
        String sourceMapData = SourceMapLoaderKt.getStringFromDataUri(sourceMapUrl);
        if (sourceMapData == null) {
            String message = "Cannot decode sourcemap data URI " + baseFileUrl;
            CommandProcessorKt.getLOG().error(message);
            return null;
        }
        CharSequence charSequence = sourceMapData;
        return charSequence.length() == 0 ? null : (CharSequence)sourceMapData;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null)) {
            return Urls.newFromEncoded((String)url);
        }
        return SourceResolverKt.doCanonicalize((String)url, (Url)baseUrl, (boolean)true, (boolean)false);
    }

    @NotNull
    public static final CharSequence loadFile(@NotNull VirtualFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IoKt.readCharSequence((InputStreamReader)new InputStreamReader($receiver.getInputStream(), $receiver.getCharset()), (int)((int)$receiver.getLength()));
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            if (file.isInLocalFileSystem()) {
                Path path = Paths.get(file.getPath(), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(file.path)");
                return SourceMapLoaderKt.getSourceMapUrl(path);
            }
            CharSequence charSequence = SourceMapLoaderKt.loadFile(file);
            Pattern pattern = REFERENCE_PATTERN_FILE;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_FILE");
            return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
        }
        catch (IOException e) {
            CommandProcessorKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull Path file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CharSequence charSequence = SourceMapLoaderKt.tail(file);
        Pattern pattern = REFERENCE_PATTERN_LINE;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
        return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
    }

    private static final String getSourceMapUrl(CharSequence string, Pattern pattern) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final CharSequence tail(@NotNull Path file) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Closeable closeable = Files.newByteChannel(file, new OpenOption[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it;
            SeekableByteChannel seekableByteChannel = it = (SeekableByteChannel)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)seekableByteChannel, (String)"it");
            charSequence = SourceMapLoaderKt.tail$default(seekableByteChannel, (int)Files.size(file), 0, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return charSequence;
    }

    /*
     * Unable to fully structure code
     */
    private static final CharSequence tail(SeekableByteChannel channel, int size, int offset) {
        bufferSize = Math.min(4096, size);
        trim = true;
        stringBuilder = null;
        charBuffer = null;
        buffer = ByteBuffer.allocate(bufferSize);
        position = offset + (size - bufferSize);
        while (position >= offset) {
            channel.position(position);
            for (count = 0; count < bufferSize && (n = channel.read(buffer)) > 0; count += n) {
            }
            n = buffer.position() - 1;
            var11_11 = false;
            while (n >= 0) {
                c = (char)buffer.get((int)p);
                if (!trim) ** GOTO lbl22
                if (c == '\n' || c == '\r' || c == ';' || c == ')' || c == '}') {
                    buffer.limit((int)p);
                } else {
                    trim = false;
lbl22:
                    // 2 sources

                    if (c == '\n') {
                        buffer.position((int)(p + true));
                        if (charBuffer == null) {
                            charBuffer = CharBuffer.allocate(buffer.remaining());
                        }
                        v0 = buffer;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"buffer");
                        v1 = charBuffer;
                        if (v1 == null) {
                            Intrinsics.throwNpe();
                        }
                        SourceMapLoaderKt.decodeString(v0, v1);
                        return stringBuilder == null ? (CharSequence)charBuffer : (CharSequence)stringBuilder.insert(0, charBuffer);
                    }
                }
                --p;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(bufferSize * 2);
            }
            if (charBuffer == null) {
                charBuffer = CharBuffer.allocate(bufferSize);
            }
            buffer.position(0);
            v2 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"buffer");
            v3 = charBuffer;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            SourceMapLoaderKt.decodeString(v2, v3);
            stringBuilder.insert(0, charBuffer);
            buffer.clear();
            charBuffer.clear();
            if (position == 0) break;
            if (position < bufferSize) {
                bufferSize = position;
                buffer.limit(position);
                position = 0;
                continue;
            }
            position -= bufferSize;
        }
        return null;
    }

    static /* synthetic */ CharSequence tail$default(SeekableByteChannel seekableByteChannel, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return SourceMapLoaderKt.tail(seekableByteChannel, n, n2);
    }

    private static final void decodeString(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)CharsetToolkit.UTF8_CHARSET);
        CoderResult coderResult2 = coderResult = decoder.decode(byteBuffer, charBuffer, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)coderResult2, (String)"coderResult");
        if (!coderResult2.isUnderflow()) {
            coderResult.throwException();
        }
        CoderResult coderResult3 = coderResult = decoder.flush(charBuffer);
        Intrinsics.checkExpressionValueIsNotNull((Object)coderResult3, (String)"coderResult");
        if (!coderResult3.isUnderflow()) {
            coderResult.throwException();
        }
        charBuffer.flip();
    }

    static {
        REFERENCE_LINE = REFERENCE_LINE;
        REFERENCE_PATTERN_FILE = Pattern.compile("[\\r\\n]" + REFERENCE_LINE);
        REFERENCE_PATTERN_LINE = Pattern.compile(REFERENCE_LINE);
    }
}

