/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.TableResultView;
import java.awt.Point;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum GridSelectionGrowerStrategy {
    CELL{

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                1.$$$reportNull$$$0(0);
            }
            if (selectedColumns == null) {
                1.$$$reportNull$$$0(1);
            }
            return selectedRows.size() == 0 || selectedColumns.size() == 0;
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                1.$$$reportNull$$$0(2);
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            JScrollPane pane = panel.getScrollPane();
            Point position = pane.getViewport() == null ? new Point(0, 0) : pane.getViewport().getViewPosition();
            TableResultView table = panel.getTable();
            int rowAtPoint = this.get(table.rowAtPoint(position), table.getRowCount());
            int columnAtPoint = this.get(table.columnAtPoint(position), table.getColumnCount());
            boolean transposed = panel.isTransposed();
            selectionModel.setRowSelection(ViewIndex.forRow(panel, !transposed ? rowAtPoint : columnAtPoint).toModel(panel));
            selectionModel.setColumnSelection(ViewIndex.forColumn(panel, !transposed ? columnAtPoint : rowAtPoint).toModel(panel));
        }

        private int get(int value, int upperBound) {
            return value < 0 || value >= upperBound ? 0 : value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRows";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/GridSelectionGrowerStrategy$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeSelection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    COLUMN(true){

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                2.$$$reportNull$$$0(0);
            }
            if (selectedColumns == null) {
                2.$$$reportNull$$$0(1);
            }
            return GridSelectionGrowerStrategy.notAllSelected(selectedRows, selectedColumns, rowCount, columnCount) && (!transposed && selectedRows.size() < rowCount || transposed && selectedColumns.size() < columnCount);
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                2.$$$reportNull$$$0(2);
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            selectionModel.selectWholeColumn();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRows";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/GridSelectionGrowerStrategy$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeSelection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    LINE(true, false){

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                3.$$$reportNull$$$0(0);
            }
            if (selectedColumns == null) {
                3.$$$reportNull$$$0(1);
            }
            return GridSelectionGrowerStrategy.notAllSelected(selectedRows, selectedColumns, rowCount, columnCount) && (!transposed && selectedRows.size() == rowCount || transposed && selectedColumns.size() == columnCount);
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                3.$$$reportNull$$$0(2);
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            selectionModel.selectWholeRow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRows";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/GridSelectionGrowerStrategy$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeSelection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    ALL{

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                4.$$$reportNull$$$0(0);
            }
            if (selectedColumns == null) {
                4.$$$reportNull$$$0(1);
            }
            return GridSelectionGrowerStrategy.notAllSelected(selectedRows, selectedColumns, rowCount, columnCount) && (transposed && selectedColumns.size() == columnCount || !transposed && selectedRows.size() == rowCount);
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                4.$$$reportNull$$$0(2);
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            selectionModel.selectWholeRow();
            selectionModel.selectWholeColumn();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRows";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedColumns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/GridSelectionGrowerStrategy$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeSelection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private final boolean myNeedRestore;
    private final boolean myNeedStore;

    private GridSelectionGrowerStrategy() {
        this(false, false);
    }

    private GridSelectionGrowerStrategy(boolean needStore) {
        this(false, needStore);
    }

    private GridSelectionGrowerStrategy(boolean needRestore, boolean needStore) {
        this.myNeedRestore = needRestore;
        this.myNeedStore = needStore;
    }

    boolean isNeedRestore() {
        return this.myNeedRestore;
    }

    boolean isNeedStore() {
        return this.myNeedStore;
    }

    abstract void changeSelection(@NotNull TableResultPanel var1);

    abstract boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> var1, @NotNull ViewIndexSet<DataConsumer.Column> var2, int var3, int var4, boolean var5);

    @Nullable
    static GridSelectionGrowerStrategy of(@NotNull DataGrid grid) {
        if (grid == null) {
            GridSelectionGrowerStrategy.$$$reportNull$$$0(0);
        }
        SelectionModel model = grid.getSelectionModel();
        ViewIndexSet<DataConsumer.Row> rows = model.getSelectedRows().toView(grid);
        ViewIndexSet<DataConsumer.Column> columns = model.getSelectedColumns().toView(grid);
        int rowCount = grid.getVisibleRows().size();
        int columnCount = grid.getVisibleColumns().size();
        boolean transposed = grid.isTransposed();
        for (GridSelectionGrowerStrategy grower : GridSelectionGrowerStrategy.values()) {
            if (!grower.isSuitable(rows, columns, rowCount, columnCount, transposed)) continue;
            return grower;
        }
        return null;
    }

    private static boolean notAllSelected(@NotNull ViewIndexSet<DataConsumer.Row> rows, @NotNull ViewIndexSet<DataConsumer.Column> columns, int rowCount, int columnCount) {
        if (rows == null) {
            GridSelectionGrowerStrategy.$$$reportNull$$$0(1);
        }
        if (columns == null) {
            GridSelectionGrowerStrategy.$$$reportNull$$$0(2);
        }
        return rows.size() * columns.size() < rowCount * columnCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/GridSelectionGrowerStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "of";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notAllSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

