/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.plugins.remotesdk.RemoteSdkFactoryImpl;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkDialog;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyCredentialsContribution;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

final class RubyCreateRemoteInterpreterDialog
extends CreateRemoteSdkDialog<RubyRemoteSdkAdditionalData> {
    private static final String DEFAULT_RUBYMINE_HELPERS_PATH = "/opt/.rubymine_helpers";
    private static final CreateRemoteSdkForm.BundleAccessor BUNDLE_ACCESSOR = new CreateRemoteSdkForm.BundleAccessor(){

        @NotNull
        public String message(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = RBundle.message((String)key, (Object[])params);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String messageOrNull(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(2);
            }
            return RBundle.messageOfNull((String)key, (Object[])params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "message";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "messageOrNull";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final SdkType[] mySdkTypes;

    RubyCreateRemoteInterpreterDialog(@Nullable Project project, @NotNull Collection<Sdk> existingSdks, @NotNull SdkType[] sdkTypes) {
        if (existingSdks == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(0);
        }
        if (sdkTypes == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(1);
        }
        super(project, existingSdks);
        this.mySdkTypes = sdkTypes;
        this.setTitle(RBundle.message((String)"remote.interpreter.configure.title"));
        this.init();
    }

    @NotNull
    protected RemoteSdkFactoryImpl<RubyRemoteSdkAdditionalData> createRemoteSdkFactory() {
        RubyRemoteInterpreterFactory rubyRemoteInterpreterFactory = new RubyRemoteInterpreterFactory();
        if (rubyRemoteInterpreterFactory == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(2);
        }
        return rubyRemoteInterpreterFactory;
    }

    @NotNull
    protected CreateRemoteSdkForm<RubyRemoteSdkAdditionalData> createRemoteSdkForm() {
        RubyCreateRemoteSdkForm rubyCreateRemoteSdkForm = new RubyCreateRemoteSdkForm(this);
        if (rubyCreateRemoteSdkForm == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(3);
        }
        return rubyCreateRemoteSdkForm;
    }

    protected boolean isModified(@NotNull RubyRemoteSdkAdditionalData oldData, @NotNull RubyRemoteSdkAdditionalData newData) {
        if (oldData == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(4);
        }
        if (newData == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected void doOKAction() {
        new Task.Modal(null, RBundle.message((String)"remote.interpreter.creating"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                RubyCreateRemoteInterpreterDialog.super.doOKAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$2", "run"));
            }
        }.queue();
    }

    protected boolean validateRemoteSdkData(RubyRemoteSdkAdditionalData data) {
        for (Sdk sdk : this.myExistingSdks) {
            if (!(sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) || !data.equals((Object)sdk.getSdkAdditionalData())) continue;
            this.validationFailed(RBundle.message((String)"remote.interpreter.already.existing", (Object[])new Object[]{sdk.getName()}), false);
            return false;
        }
        return true;
    }

    @NotNull
    protected String getDefaultHelpersPath() {
        if (DEFAULT_RUBYMINE_HELPERS_PATH == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(6);
        }
        return DEFAULT_RUBYMINE_HELPERS_PATH;
    }

    @Nullable
    public static SdkType selectSdkType(@NotNull String interpreterPath, boolean isWindows, SdkType ... sdkTypes) {
        File interpreterFile;
        if (interpreterPath == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(7);
        }
        if (RVMSupportUtil.isRvmSdk((File)(interpreterFile = new File(interpreterPath)))) {
            return RVMSupportUtil.getRubySdkType((String)interpreterFile.getName());
        }
        for (SdkType sdkType : sdkTypes) {
            if (!(sdkType instanceof RubySdkType) || !((RubySdkType)sdkType).isValidInterpreter(interpreterFile, isWindows)) continue;
            return sdkType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteSdkFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteSdkForm";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHelpersPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectSdkType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RubyRemoteInterpreterFactory
    extends RemoteSdkFactoryImpl<RubyRemoteSdkAdditionalData> {
        private RubyRemoteInterpreterFactory() {
        }

        @NotNull
        protected SdkType getSdkType(@NotNull RubyRemoteSdkAdditionalData data) {
            SdkType type;
            if (data == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(0);
            }
            if ((type = RubyCreateRemoteInterpreterDialog.selectSdkType(data.getInterpreterPath(), RubySdkUtil.isWindows((String)data.getPlatform()), RubyCreateRemoteInterpreterDialog.this.mySdkTypes)) != null) {
                SdkType sdkType = type;
                if (sdkType == null) {
                    RubyRemoteInterpreterFactory.$$$reportNull$$$0(1);
                }
                return sdkType;
            }
            throw new IllegalArgumentException("unrecognized sdk type for " + data);
        }

        @NotNull
        protected String getInterpreterName(@NotNull RubyRemoteSdkAdditionalData data, @Nullable String version) throws RemoteSdkException {
            String normalizedVersionString;
            if (data == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(2);
            }
            if ((normalizedVersionString = data.getNormalizedVersionString()) == null) {
                throw new RemoteSdkException(RBundle.message((String)"remote.interpreter.cannot.find.interpreter.path"));
            }
            String patchLevel = RubyVersionUtil.getPatchLevel((String)normalizedVersionString);
            String shortVersion = RubyVersionUtil.getShortVersion((String)normalizedVersionString);
            String suggestedSdkName = ((RubySdkType)this.getSdkType(data)).createSuggestedSdkName(shortVersion, patchLevel);
            RubyVersionManagerSdkData versionManagerSdkAdditionalData = data.getVersionManagerSdkAdditionalData();
            String string = "Remote" + versionManagerSdkAdditionalData.getHandler().getRemoteNameSuffix() + ": " + suggestedSdkName + versionManagerSdkAdditionalData.getRemoteSdkNameSuffix();
            if (string == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        protected String getInterpreterVersion(Project project, @NotNull RubyRemoteSdkAdditionalData data) throws RemoteSdkException {
            if (data == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(4);
            }
            if (data.getNormalizedVersionString() == null) {
                try {
                    data.setNormalizedVersionString(RubyVersionUtil.getFullVersion((RubyRunner)data.getRunner(null), (String)data.getInterpreterPath(), (boolean)true));
                }
                catch (ExecutionException e) {
                    throw new RemoteSdkException(e.getMessage(), (Throwable)e);
                }
            }
            return data.getNormalizedVersionString();
        }

        public boolean canSaveUnfinished() {
            return false;
        }

        @NotNull
        public String sdkName() {
            if ("Ruby" == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(5);
            }
            return "Ruby";
        }

        public void initSdk(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) throws RemoteSdkException {
            if (sdk == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(6);
            }
            try {
                ((RubySdkType)sdk.getSdkType()).setupSdkPaths(sdk);
            }
            catch (Exception e) {
                throw new RemoteSdkException(e.getMessage(), (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$RubyRemoteInterpreterFactory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$RubyRemoteInterpreterFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInterpreterName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sdkName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSdkType";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getInterpreterName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getInterpreterVersion";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "initSdk";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class RubyCreateRemoteSdkForm
    extends CreateRemoteSdkForm<RubyRemoteSdkAdditionalData> {
        RubyCreateRemoteSdkForm(CreateRemoteSdkDialog<RubyRemoteSdkAdditionalData> dialog) {
            if (dialog == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(0);
            }
            super(dialog, BUNDLE_ACCESSOR);
        }

        @NotNull
        protected List<CredentialsLanguageContribution> getContributions() {
            List list = ContainerUtil.filter((Object[])CredentialsLanguageContribution.EP_NAME.getExtensions(), (Condition)FilteringIterator.instanceOf(RubyCredentialsContribution.class));
            if (list == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        protected RubyRemoteSdkAdditionalData doCreateSdkData(@NotNull String interpreterPath) {
            if (interpreterPath == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(2);
            }
            RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = RubyRemoteSdkAdditionalData.create((String)interpreterPath);
            if (rubyRemoteSdkAdditionalData == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(3);
            }
            return rubyRemoteSdkAdditionalData;
        }

        public RubyRemoteSdkAdditionalData createSdkData() throws RemoteSdkException {
            RubyRemoteSdkAdditionalData additionalData = (RubyRemoteSdkAdditionalData)super.createSdkData();
            return (RubyRemoteSdkAdditionalData)ObjectUtils.tryCast((Object)additionalData.withVersionManagerSdkAdditionalData(RubyVersionManagerHandler.createAdditionalData((RubyRemoteSdkAdditionalData)additionalData)), RubyRemoteSdkAdditionalData.class);
        }

        @Nullable
        public ValidationInfo validateRemoteInterpreter() {
            String reason = Verifier.checkCharacterData((String)this.getInterpreterPath());
            if (reason != null) {
                return new ValidationInfo(BUNDLE_ACCESSOR.message("remote.interpreter.invalid.chars.in.interpreter.path", new Object[]{reason}), (JComponent)this.myInterpreterPathField);
            }
            return super.validateRemoteInterpreter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$RubyCreateRemoteSdkForm";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyCreateRemoteInterpreterDialog$RubyCreateRemoteSdkForm";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doCreateSdkData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateSdkData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

