/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.NotNull;

public class XmlTagInjection
extends AbstractTagInjection {
    public XmlTagInjection() {
        this.setTagName("<none>");
    }

    public boolean isApplicable(@NotNull XmlTag context) {
        if (context == null) {
            XmlTagInjection.$$$reportNull$$$0(0);
        }
        return this.matches(context) && this.matchXPath((XmlElement)context);
    }

    public String getGeneratedName() {
        String name = this.getTagName();
        return name.length() > 0 ? name : "*";
    }

    @Override
    public XmlTagInjection copy() {
        return new XmlTagInjection().copyFrom(this);
    }

    @Override
    public XmlTagInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            XmlTagInjection.$$$reportNull$$$0(1);
        }
        super.copyFrom(o);
        return this;
    }

    @Override
    public void generatePlaces() {
        if (StringUtil.isEmpty((String)this.getDisplayName())) {
            this.setDisplayName(this.getGeneratedName());
        }
        this.setInjectionPlaces(new InjectionPlace((ElementPattern<? extends PsiElement>)this.getCompiler().createElementPattern(XmlTagInjection.getPatternString(this), this.getDisplayName()), true));
    }

    public static String getPatternString(AbstractTagInjection injection) {
        String name = injection.getTagName();
        String namespace = injection.getTagNamespace();
        StringBuilder result = new StringBuilder("xmlTag()");
        if (StringUtil.isNotEmpty((String)name)) {
            InjectorUtils.appendStringPattern(result, ".withLocalName(", name, ")");
        }
        if (StringUtil.isNotEmpty((String)namespace)) {
            InjectorUtils.appendStringPattern(result, ".withNamespace(", namespace, ")");
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/intelliLang/inject/config/XmlTagInjection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

