/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import b.h.la;
import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageDataManagerImpl;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuiteChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String b = "Local";
    private final Project g;
    private final CheckboxTree c;
    private final CoverageDataManager f;
    private static final Logger d;
    private final CheckedTreeNode a;
    private CoverageEngine e;
    private static final long h;

    public CoverageSuiteChooserDialog(Project project) {
        long l2 = h ^ 0x606EABFA1BF6L;
        super(project, true);
        this.g = project;
        this.f = CoverageDataManager.getInstance(project);
        this.a = new CheckedTreeNode((Object)"");
        this.d();
        this.c = new CheckboxTree(new SuitesRenderer(), this.a){

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, treePath -> {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof CoverageSuite) {
                        return ((CoverageSuite)object).getPresentableName();
                    }
                    return object.toString();
                });
            }
        };
        this.c.getEmptyText().appendText("No coverage suites configured.");
        this.c.setRootVisible(false);
        this.c.setShowsRootHandles(false);
        TreeUtil.installActions((JTree)this.c);
        TreeUtil.expandAll((JTree)this.c);
        TreeUtil.selectFirstNode((JTree)this.c);
        this.c.setMinimumSize(new Dimension(25, -1));
        this.setOKButtonText("Show selected");
        this.init();
        this.setTitle("Choose Coverage Suite to Display");
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.c);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.c;
    }

    protected JComponent createNorthPanel() {
        long l2 = h ^ 0x7A308BEC0184L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new AddExternalSuiteAction(this));
        defaultActionGroup.add((AnAction)new DeleteSuiteAction(this));
        defaultActionGroup.add((AnAction)new SwitchEngineAction());
        return ActionManager.getInstance().createActionToolbar("CoverageSuiteChooser", (ActionGroup)defaultActionGroup, true).getComponent();
    }

    protected void doOKAction() {
        List<CoverageSuite> list2 = this.c();
        this.f.chooseSuitesBundle(list2.isEmpty() ? null : new CoverageSuitesBundle(list2.toArray(new CoverageSuite[0])));
        ((CoverageDataManagerImpl)this.f).addRootsToWatch(list2);
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new NoCoverageAction(this), this.getCancelAction()};
        if (actionArray == null) {
            CoverageSuiteChooserDialog.a(0);
        }
        return actionArray;
    }

    private Set<CoverageEngine> b() {
        HashSet<CoverageEngine> hashSet = new HashSet<CoverageEngine>();
        for (CoverageSuite coverageSuite : this.f.getSuites()) {
            hashSet.add(coverageSuite.getCoverageEngine());
        }
        return hashSet;
    }

    private static String a(CoverageRunner coverageRunner) {
        long l2 = h ^ 0x48CEE05FBB06L;
        return coverageRunner.getPresentableName() + " Coverage";
    }

    @Nullable
    private static CoverageRunner a(VirtualFile virtualFile) {
        for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
            for (String string : coverageRunner.getDataFileExtensions()) {
                if (!Comparing.strEqual((String)virtualFile.getExtension(), (String)string)) continue;
                return coverageRunner;
            }
        }
        return null;
    }

    private List<CoverageSuite> c() {
        ArrayList<CoverageSuite> arrayList = new ArrayList<CoverageSuite>();
        TreeUtil.traverse((TreeNode)this.a, object -> {
            Object object2;
            if (object instanceof CheckedTreeNode && ((CheckedTreeNode)object).isChecked() && (object2 = ((CheckedTreeNode)object).getUserObject()) instanceof CoverageSuite) {
                arrayList.add((CoverageSuite)object2);
            }
            return true;
        });
        return arrayList;
    }

    private void d() {
        long l2 = h ^ 0x4DBE582B6763L;
        this.a.removeAllChildren();
        HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> hashMap = new HashMap<CoverageRunner, Map<String, List<CoverageSuite>>>();
        CoverageSuiteChooserDialog.a(hashMap, this.f.getSuites(), this.e);
        CoverageSuitesBundle coverageSuitesBundle = this.f.getCurrentSuitesBundle();
        ArrayList<CoverageRunner> arrayList = new ArrayList<CoverageRunner>(hashMap.keySet());
        Collections.sort(arrayList, (coverageRunner, coverageRunner2) -> coverageRunner.getPresentableName().compareToIgnoreCase(coverageRunner2.getPresentableName()));
        for (CoverageRunner coverageRunner3 : arrayList) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.a(coverageRunner3));
            Map<String, List<CoverageSuite>> map = hashMap.get(coverageRunner3);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Remote");
            if (map.size() == 1) {
                object2 = map.keySet().iterator().next();
                Object object3 = defaultMutableTreeNode;
                if (!Comparing.strEqual((String)object2, (String)DefaultCoverageFileProvider.class.getName())) {
                    object3 = defaultMutableTreeNode2;
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                List<CoverageSuite> list2 = map.get(object2);
                Collections.sort(list2, (coverageSuite, coverageSuite2) -> coverageSuite.getPresentableName().compareToIgnoreCase(coverageSuite2.getPresentableName()));
                for (Object object : list2) {
                    CheckedTreeNode checkedTreeNode = new CheckedTreeNode(object);
                    checkedTreeNode.setChecked((coverageSuitesBundle != null && coverageSuitesBundle.contains((CoverageSuite)object) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                    ((DefaultMutableTreeNode)object3).add((MutableTreeNode)checkedTreeNode);
                }
            } else {
                object2 = new DefaultMutableTreeNode(b);
                defaultMutableTreeNode.add((MutableTreeNode)object2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                for (String string : map.keySet()) {
                    Object object;
                    Object object3 = Comparing.strEqual((String)string, (String)DefaultCoverageFileProvider.class.getName()) ? object2 : defaultMutableTreeNode2;
                    object = map.get(string).iterator();
                    while (object.hasNext()) {
                        CoverageSuite coverageSuite3 = (CoverageSuite)object.next();
                        CheckedTreeNode checkedTreeNode = new CheckedTreeNode((Object)coverageSuite3);
                        checkedTreeNode.setChecked((coverageSuitesBundle != null && coverageSuitesBundle.contains(coverageSuite3) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                        ((DefaultMutableTreeNode)object3).add((MutableTreeNode)checkedTreeNode);
                    }
                }
            }
            this.a.add((MutableTreeNode)defaultMutableTreeNode);
        }
    }

    private static void a(HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> hashMap, CoverageSuite[] coverageSuiteArray, CoverageEngine coverageEngine) {
        for (CoverageSuite coverageSuite : coverageSuiteArray) {
            String string;
            List<CoverageSuite> list2;
            CoverageFileProvider coverageFileProvider;
            if (coverageEngine != null && coverageSuite.getCoverageEngine() != coverageEngine || (coverageFileProvider = coverageSuite.getCoverageDataFileProvider()) instanceof DefaultCoverageFileProvider && Comparing.strEqual((String)((DefaultCoverageFileProvider)coverageFileProvider).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName()) && !coverageFileProvider.ensureFileExists()) continue;
            CoverageRunner coverageRunner = coverageSuite.getRunner();
            Map<String, List<CoverageSuite>> map = hashMap.get(coverageRunner);
            if (map == null) {
                map = new HashMap<String, List<CoverageSuite>>();
                hashMap.put(coverageRunner, map);
            }
            if ((list2 = map.get(string = coverageFileProvider instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)coverageFileProvider).getSourceProvider() : coverageFileProvider.getClass().getName())) == null) {
                list2 = new ArrayList<CoverageSuite>();
                map.put(string, list2);
            }
            list2.add(coverageSuite);
        }
    }

    private void a() {
        ((DefaultTreeModel)this.c.getModel()).reload();
        TreeUtil.expandAll((JTree)this.c);
    }

    static {
        h = la.a(4281782182758236491L, 6252961505377514084L, MethodHandles.lookup().lookupClass()).a(70089119664858L);
        d = Logger.getInstance(CoverageSuiteChooserDialog.class);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = h ^ 0x580917916DFL;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/actions/CoverageSuiteChooserDialog", "createActions"));
    }

    private class SwitchEngineAction
    extends ComboBoxAction {
        private static final long a = la.a(4669261446969228020L, 4184670357736583266L, MethodHandles.lookup().lookupClass()).a(151378970321131L);

        private SwitchEngineAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            for (final CoverageEngine coverageEngine : CoverageSuiteChooserDialog.this.b()) {
                defaultActionGroup.add(new AnAction(coverageEngine.getPresentableText()){
                    private static final long a = la.a(-7842812796502667144L, 6836638100848310294L, MethodHandles.lookup().lookupClass()).a(215641688727122L);

                    public void actionPerformed(@NotNull AnActionEvent e10) {
                        if (e10 == null) {
                            1.a(0);
                        }
                        CoverageSuiteChooserDialog.this.e = coverageEngine;
                        CoverageSuiteChooserDialog.this.d();
                        CoverageSuiteChooserDialog.this.a();
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x6CB521E28134L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction$1", "actionPerformed"));
                    }
                });
            }
            DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
            if (defaultActionGroup2 == null) {
                SwitchEngineAction.a(0);
            }
            return defaultActionGroup2;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SwitchEngineAction.a(1);
            }
            super.update(e10);
            e10.getPresentation().setVisible(CoverageSuiteChooserDialog.this.b().size() > 1);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x234B60E616D3L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DeleteSuiteAction
    extends AnAction {
        final /* synthetic */ CoverageSuiteChooserDialog this$0;
        private static final long a = la.a(8179013292624185940L, 4128076862922550373L, MethodHandles.lookup().lookupClass()).a(4181731814396L);

        DeleteSuiteAction(CoverageSuiteChooserDialog coverageSuiteChooserDialog) {
            long l2 = a ^ 0x9B56EA8C077L;
            this.this$0 = coverageSuiteChooserDialog;
            super("Delete", "Delete", PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)coverageSuiteChooserDialog.c);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            CheckedTreeNode[] checkedTreeNodeArray;
            if (e10 == null) {
                DeleteSuiteAction.a(0);
            }
            for (CheckedTreeNode checkedTreeNode : checkedTreeNodeArray = (CheckedTreeNode[])this.this$0.c.getSelectedNodes(CheckedTreeNode.class, null)) {
                CoverageSuite coverageSuite;
                Object object = checkedTreeNode.getUserObject();
                if (!(object instanceof CoverageSuite) || !((coverageSuite = (CoverageSuite)object).getCoverageDataFileProvider() instanceof DefaultCoverageFileProvider) || !Comparing.strEqual((String)((DefaultCoverageFileProvider)coverageSuite.getCoverageDataFileProvider()).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName())) continue;
                this.this$0.f.removeCoverageSuite(coverageSuite);
                TreeUtil.removeLastPathComponent((JTree)this.this$0.c, (TreePath)new TreePath(checkedTreeNode.getPath()));
            }
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                DeleteSuiteAction.a(1);
            }
            CheckedTreeNode[] checkedTreeNodeArray = (CheckedTreeNode[])this.this$0.c.getSelectedNodes(CheckedTreeNode.class, null);
            Presentation presentation = e10.getPresentation();
            presentation.setEnabled(false);
            for (CheckedTreeNode checkedTreeNode : checkedTreeNodeArray) {
                CoverageSuite coverageSuite;
                Object object = checkedTreeNode.getUserObject();
                if (!(object instanceof CoverageSuite) || !((coverageSuite = (CoverageSuite)object).getCoverageDataFileProvider() instanceof DefaultCoverageFileProvider) || !Comparing.strEqual((String)((DefaultCoverageFileProvider)coverageSuite.getCoverageDataFileProvider()).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName())) continue;
                presentation.setEnabled(true);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x2274B19AA571L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$DeleteSuiteAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddExternalSuiteAction
    extends AnAction {
        final /* synthetic */ CoverageSuiteChooserDialog this$0;
        private static final long a = la.a(-9193048663177640670L, 593871098235697155L, MethodHandles.lookup().lookupClass()).a(223212538100143L);

        AddExternalSuiteAction(CoverageSuiteChooserDialog coverageSuiteChooserDialog) {
            long l2 = a ^ 0x6E8A9BB7729FL;
            this.this$0 = coverageSuiteChooserDialog;
            super("Add", "Add", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)coverageSuiteChooserDialog.c);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            VirtualFile virtualFile;
            long l2 = a ^ 0x41EFBE73BDDDL;
            if (e10 == null) {
                AddExternalSuiteAction.a(0);
            }
            if ((virtualFile = FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileSelectable(VirtualFile file) {
                    return CoverageSuiteChooserDialog.a(file) != null;
                }
            }, (Project)this.this$0.g, null)) != null) {
                TreeNode treeNode;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
                CoverageRunner coverageRunner = CoverageSuiteChooserDialog.a(virtualFile);
                if (coverageRunner == null) {
                    Messages.showErrorDialog((Project)this.this$0.g, (String)("No coverage runner available for " + virtualFile.getName()), (String)CommonBundle.getErrorTitle());
                    return;
                }
                CoverageSuite coverageSuite = this.this$0.f.addExternalCoverageSuite(virtualFile.getName(), virtualFile.getTimeStamp(), coverageRunner, new DefaultCoverageFileProvider(virtualFile.getPath()));
                String string = CoverageSuiteChooserDialog.a(coverageRunner);
                DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.this$0.a, (Object)string);
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                    this.this$0.a.add((MutableTreeNode)defaultMutableTreeNode);
                }
                if (defaultMutableTreeNode.getChildCount() > 0 && !((treeNode = defaultMutableTreeNode.getChildAt(0)) instanceof CheckedTreeNode)) {
                    if (CoverageSuiteChooserDialog.b.equals(((DefaultMutableTreeNode)treeNode).getUserObject())) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                    } else {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.b);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                    }
                }
                treeNode = new CheckedTreeNode((Object)coverageSuite);
                treeNode.setChecked(true);
                defaultMutableTreeNode.add((MutableTreeNode)treeNode);
                TreeUtil.sort((DefaultMutableTreeNode)defaultMutableTreeNode, (object, object2) -> {
                    if (object instanceof CheckedTreeNode && object2 instanceof CheckedTreeNode) {
                        Object object3 = ((CheckedTreeNode)object).getUserObject();
                        Object object4 = ((CheckedTreeNode)object2).getUserObject();
                        if (object3 instanceof CoverageSuite && object4 instanceof CoverageSuite) {
                            String string = ((CoverageSuite)object3).getPresentableName();
                            String string2 = ((CoverageSuite)object4).getPresentableName();
                            return string.compareToIgnoreCase(string2);
                        }
                    }
                    return 0;
                });
                this.this$0.a();
                TreeUtil.selectNode((JTree)this.this$0.c, (TreeNode)treeNode);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x3F4120B97719L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$AddExternalSuiteAction", "actionPerformed"));
        }
    }

    private class NoCoverageAction
    extends DialogWrapper.DialogWrapperAction {
        final /* synthetic */ CoverageSuiteChooserDialog this$0;
        private static final long a = la.a(-6756698077920659128L, -8485198174460684030L, MethodHandles.lookup().lookupClass()).a(125221391653773L);

        NoCoverageAction(CoverageSuiteChooserDialog coverageSuiteChooserDialog) {
            long l2 = a ^ 0x714F9EE19C67L;
            this.this$0 = coverageSuiteChooserDialog;
            super((DialogWrapper)coverageSuiteChooserDialog, "&No Coverage");
        }

        protected void doAction(ActionEvent e10) {
            this.this$0.f.chooseSuitesBundle(null);
            this.this$0.close(0);
        }
    }

    private static class SuitesRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private static final long a = la.a(557753145243947317L, 5240994860786632876L, MethodHandles.lookup().lookupClass()).a(74722675580010L);

        private SuitesRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object object;
            long l2 = a ^ 0x7DBD6BD23C37L;
            if (value instanceof CheckedTreeNode) {
                Object object2 = ((CheckedTreeNode)value).getUserObject();
                if (object2 instanceof CoverageSuite) {
                    CoverageSuite coverageSuite = (CoverageSuite)object2;
                    this.getTextRenderer().append(coverageSuite.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String string = " (" + DateFormatUtil.formatPrettyDateTime((long)coverageSuite.getLastCoverageTimeStamp()) + ")";
                    this.getTextRenderer().append(string, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String) {
                this.getTextRenderer().append((String)object);
            }
        }
    }
}

