/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovCoverageType;
import org.jetbrains.plugins.ruby.coverage.RCovRawFileData;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.yaml.snakeyaml.error.YAMLException;

public class RubyCoverageUtil {
    private static final Logger b;
    private static final Pattern c;
    private static final Pattern a;
    private static final Pattern e;
    private static final Pattern d;
    private static final long f;

    private RubyCoverageUtil() {
    }

    public static boolean[] determineSrcCodeLines(String[] lines, @Nullable List<RCovCoverageType> coverage) {
        SrcLineState srcLineState = SrcLineState.CODE;
        boolean[] blArray = new boolean[lines.length];
        int n2 = lines.length;
        block4: for (int i10 = 0; i10 < n2; ++i10) {
            blArray[i10] = false;
            if (srcLineState == SrcLineState.FILE_END_DATA) continue;
            if (RubyCoverageUtil.a(i10, coverage)) {
                blArray[i10] = true;
                continue;
            }
            String string = lines[i10];
            if (d.matcher(string).find()) continue;
            switch (srcLineState) {
                case CODE: {
                    if (c.matcher(string).find()) {
                        srcLineState = SrcLineState.COMMENT;
                        continue block4;
                    }
                    if (e.matcher(string).find()) {
                        srcLineState = SrcLineState.FILE_END_DATA;
                        continue block4;
                    }
                    blArray[i10] = true;
                    continue block4;
                }
                case COMMENT: {
                    if (!a.matcher(string).find()) continue block4;
                    srcLineState = SrcLineState.CODE;
                }
            }
        }
        return blArray;
    }

    private static boolean a(int n2, List<RCovCoverageType> list2) {
        return list2 != null && n2 < list2.size() && list2.get(n2) == RCovCoverageType.COVERED;
    }

    @Nullable
    public static boolean[] determineSrcCodeLines(@NotNull File file) {
        String string;
        long l2 = f ^ 0x326CAFA62F09L;
        if (file == null) {
            RubyCoverageUtil.a(0);
        }
        try {
            string = FileUtil.loadFile((File)file);
        }
        catch (IOException iOException) {
            string = null;
            b.warn("Unable to read content of : " + file.getPath());
        }
        if (string == null) {
            return null;
        }
        List list2 = StringUtil.split((String)string, (String)"\n", (boolean)false);
        return RubyCoverageUtil.determineSrcCodeLines(list2.toArray(ArrayUtil.EMPTY_STRING_ARRAY), null);
    }

    public static boolean isMostLikelyNonSrcCode(int line, RCovRawFileData rawFileData) {
        RCovCoverageType rCovCoverageType = rawFileData.getCoverage(line);
        return !rawFileData.isSourceCode(line) && (rCovCoverageType == RCovCoverageType.INFERRED || rCovCoverageType == RCovCoverageType.NOT_COVERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadYaml(String serializedDataPath, Logger log) {
        long l2 = f ^ 0x269BB15DEF84L;
        File file = new File(serializedDataPath);
        if (!file.exists()) {
            return null;
        }
        Map map = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            map = RubyUtil.loadYaml(fileInputStream);
        }
        catch (YAMLException yAMLException) {
            log.error("Cannot parse yaml report: " + serializedDataPath, (Throwable)yAMLException);
            map = null;
        }
        catch (Exception exception) {
            log.error("Cannot parse yaml report: non-yaml error " + serializedDataPath, (Throwable)exception);
            map = null;
        }
        return map;
    }

    static {
        f = la.a(986784041654963796L, 3262951245681398477L, MethodHandles.lookup().lookupClass()).a(272197072015602L);
        long l2 = f ^ 0x65466907746AL;
        b = Logger.getInstance(RubyCoverageUtil.class);
        c = Pattern.compile("^=begin\\b");
        a = Pattern.compile("^=end\\b");
        e = Pattern.compile("^__END__\\b");
        d = Pattern.compile("^\\s*(#|$)");
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = f ^ 0x3FD6C987C3A9L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/coverage/RubyCoverageUtil", "determineSrcCodeLines"));
    }

    private static final class SrcLineState
    extends Enum<SrcLineState> {
        public static final /* enum */ SrcLineState CODE;
        public static final /* enum */ SrcLineState COMMENT;
        public static final /* enum */ SrcLineState FILE_END_DATA;
        private static final /* synthetic */ SrcLineState[] a;

        public static SrcLineState[] values() {
            return (SrcLineState[])a.clone();
        }

        public static SrcLineState valueOf(String name) {
            return Enum.valueOf(SrcLineState.class, name);
        }

        static {
            long l2 = la.a(-11942010302446046L, -8701646120134876592L, MethodHandles.lookup().lookupClass()).a(96368757816799L) ^ 0x3C9FD9F889DCL;
            CODE = new SrcLineState();
            COMMENT = new SrcLineState();
            FILE_END_DATA = new SrcLineState();
            a = new SrcLineState[]{CODE, COMMENT, FILE_END_DATA};
        }
    }
}

