/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pullUp;

import b.h.la;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.pullUp.RubyPullUpDialog;

public class RubyPullUpHandler
extends RubyClassRefactoringHandlerBase {
    private static final long a = la.a(8504915269985916349L, 3204600412366264075L, MethodHandles.lookup().lookupClass()).a(270825055077958L);

    protected void showDialog(Project project, PsiElement element, Editor editor, PsiFile file, DataContext dataContext) {
        long l2 = a ^ 0x547524372FABL;
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        RContainer rContainer = RubyPsiUtil.getContainingRClassOrModule(element);
        assert (rContainer != null);
        RubyMemberInfoStorage rubyMemberInfoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos(rContainer, element);
        if (rubyMemberInfoStorage.getClassMemberInfos((PsiElement)rContainer).isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)"No members to pull up found"), (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        Set<RContainer> set = rubyMemberInfoStorage.getInstanceClasses();
        Set<RContainer> set2 = rubyMemberInfoStorage.getStaticClasses();
        if (set.size() == 0 && set2.size() == 0) {
            String string = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)rContainer)}).replace("interfaces", "modules"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)string, (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        if (ApplicationManagerEx.getApplicationEx().isUnitTestMode()) {
            return;
        }
        RubyPullUpDialog rubyPullUpDialog = new RubyPullUpDialog(project, rContainer, set, set2, rubyMemberInfoStorage);
        if (rubyPullUpDialog.showAndGet()) {
            RubyPullUpHandler.pullUp(rContainer, rubyPullUpDialog.getSelectedMemberInfos(), rubyPullUpDialog.getSuperClass(), rubyPullUpDialog.isStatic());
        }
    }

    protected String getInvalidPositionMessage() {
        long l2 = a ^ 0x47285181C86DL;
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");
    }

    static void pullUp(RContainer clazz, Collection<RubyMemberInfo> selectedMemberInfos, RContainer superClass, boolean isStatic) {
        long l2 = a ^ 0x5A91A8DD569BL;
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> RubyPullUpHandler.navigate((PsiElement)RubyPullUpHandler.b(selectedMemberInfos, superClass, isStatic)))), RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    @Nullable
    private static PsiElement b(Collection<RubyMemberInfo> collection, RContainer rContainer, boolean bl2) {
        long l2 = a ^ 0x4A53F2725698L;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        RubyClassMembersPsiHelper.splitByAccess(collection, arrayList, arrayList2, arrayList3);
        PsiElement psiElement = RubyClassMembersPsiHelper.insertMethods(rContainer, arrayList3, "private", bl2);
        PsiElement psiElement2 = RubyClassMembersPsiHelper.insertMethods(rContainer, arrayList2, "protected", bl2);
        PsiElement psiElement3 = RubyClassMembersPsiHelper.insertMethods(rContainer, arrayList, "public", bl2);
        RubyClassMembersPsiHelper.removeMembers(collection);
        return psiElement3 != null ? psiElement3 : (psiElement2 != null ? psiElement2 : psiElement);
    }

    protected String getHelpId() {
        long l2 = a ^ 0x62CA1E1E2ADEL;
        return "members.pull.up";
    }

    protected String getTitle() {
        long l2 = a ^ 0x57FFEFCAACB2L;
        return RefactoringBundle.message((String)"pull.members.up.title");
    }
}

