/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewUnloadedModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewProjectNode
extends AbstractProjectNode {
    public ProjectViewProjectNode(@NotNull Project project, ViewSettings viewSettings) {
        if (project == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(0);
        }
        super(project, project, viewSettings);
    }

    public boolean canRepresent(Object element) {
        Project project = (Project)this.getValue();
        return project == element || project != null && element instanceof VirtualFile && element.equals(project.getBaseDir());
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        VirtualFile[] files2;
        if (this.myProject.isDisposed()) {
            List<AbstractTreeNode> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VirtualFile> topLevelContentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelRoots();
        LinkedHashSet<LoadedModuleDescriptionImpl> modules = new LinkedHashSet<LoadedModuleDescriptionImpl>(topLevelContentRoots.size());
        for (VirtualFile root : topLevelContentRoots) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)root, (Project)this.myProject);
            if (module != null) {
                modules.add(new LoadedModuleDescriptionImpl(module));
                continue;
            }
            String unloadedModuleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(root, this.myProject);
            if (unloadedModuleName == null) continue;
            ContainerUtil.addIfNotNull(modules, (Object)ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(unloadedModuleName));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>(this.modulesAndGroups(modules));
        VirtualFile baseDir = this.getProject().getBaseDir();
        if (baseDir == null) {
            ArrayList<AbstractTreeNode> arrayList = nodes;
            if (arrayList == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        for (VirtualFile file2 : files2 = baseDir.getChildren()) {
            PsiFile psiFile;
            if (file2.isDirectory() || ProjectFileIndex.SERVICE.getInstance((Project)this.getProject()).getModuleForFile(file2, false) != null || (psiFile = psiManager.findFile(file2)) == null) continue;
            nodes.add((AbstractTreeNode)new PsiFileNode(this.getProject(), psiFile, this.getSettings()));
        }
        if (this.getSettings().isShowLibraryContents()) {
            nodes.add((AbstractTreeNode)new ExternalLibrariesNode(this.getProject(), this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = nodes;
        if (arrayList == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected AbstractTreeNode createModuleGroup(@NotNull Module module) {
        PsiDirectory psi;
        List<VirtualFile> roots;
        if (module == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(4);
        }
        if ((roots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelModuleRoots(module, this.getSettings())).size() == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots.get(0))) != null) {
            PsiDirectoryNode psiDirectoryNode = new PsiDirectoryNode(this.myProject, psi, this.getSettings());
            if (psiDirectoryNode == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(5);
            }
            return psiDirectoryNode;
        }
        ProjectViewModuleNode projectViewModuleNode = new ProjectViewModuleNode(this.getProject(), module, this.getSettings());
        if (projectViewModuleNode == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(6);
        }
        return projectViewModuleNode;
    }

    @Override
    protected AbstractTreeNode createUnloadedModuleNode(@NotNull UnloadedModuleDescription moduleDescription) {
        PsiDirectory psi;
        List<VirtualFile> roots;
        if (moduleDescription == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(7);
        }
        if ((roots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(moduleDescription, this.getSettings())).size() == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewUnloadedModuleNode(this.getProject(), moduleDescription, this.getSettings());
    }

    @Override
    @NotNull
    protected AbstractTreeNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        if (moduleGroup == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(8);
        }
        ProjectViewModuleGroupNode projectViewModuleGroupNode = new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
        if (projectViewModuleGroupNode == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(9);
        }
        return projectViewModuleGroupNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescription";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroupNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUnloadedModuleNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

