/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FUStatisticsWhiteListGroupsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.whiteList.FUStatisticsWhiteListGroupsService");

    @NotNull
    public static Set<String> getApprovedGroups(@NotNull String serviceUrl, @NotNull BuildNumber current) {
        if (serviceUrl == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(0);
        }
        if (current == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(1);
        }
        String content = null;
        try {
            content = HttpRequests.request((String)serviceUrl).productNameAsUserAgent().readString(null);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        if (content == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<String> set = FUStatisticsWhiteListGroupsService.parseApprovedGroups(content, current);
        if (set == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(3);
        }
        return set;
    }

    @VisibleForTesting
    @NotNull
    public static Set<String> parseApprovedGroups(String content, @NotNull BuildNumber build2) {
        if (build2 == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(4);
        }
        WLGroups groups = null;
        try {
            groups = (WLGroups)new GsonBuilder().create().fromJson(content, WLGroups.class);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        Set<String> set = groups == null ? Collections.emptySet() : groups.groups.stream().filter(group -> {
            if (build2 == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(6);
            }
            return group.accepts(build2);
        }).map(group -> group.id).collect(Collectors.toSet());
        if (set == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApprovedGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseApprovedGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApprovedGroups";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseApprovedGroups";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseApprovedGroups$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WLBuild {
        public final String from;
        public final String to;

        private WLBuild(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public boolean contains(BuildNumber build2) {
            return !(!StringUtil.isEmpty((String)this.to) && BuildNumber.fromString((String)this.to).compareTo(build2) <= 0 || !StringUtil.isEmpty((String)this.from) && BuildNumber.fromString((String)this.from).compareTo(build2) > 0);
        }
    }

    private static class WLGroup {
        @NotNull
        public final String id;
        @NotNull
        public final ArrayList<WLBuild> builds;

        WLGroup(@NotNull String id) {
            if (id == null) {
                WLGroup.$$$reportNull$$$0(0);
            }
            this.builds = new ArrayList();
            this.id = id;
        }

        public boolean accepts(BuildNumber current) {
            return this.builds.stream().anyMatch(build2 -> build2.contains(current));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService$WLGroup", "<init>"));
        }
    }

    private static class WLGroups {
        @NotNull
        public final ArrayList<WLGroup> groups = new ArrayList();

        private WLGroups() {
        }
    }
}

