/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Enumeration;
import java.util.Vector;
import org.sablecc.sablecc.Cast;

public class CharSet
implements Cloneable {
    private final Vector intervals = new Vector(0);

    public CharSet(char c) {
        this.intervals.addElement(new Interval(c, c));
    }

    public CharSet(char start, char end) {
        this.intervals.addElement(new Interval(start, end));
    }

    private CharSet(Vector intervals) {
        Enumeration e = intervals.elements();
        while (e.hasMoreElements()) {
            this.intervals.addElement(((Interval)e.nextElement()).clone());
        }
    }

    public Object clone() {
        return new CharSet(this.intervals);
    }

    public Interval findOverlap(Interval interval1) {
        int low = 0;
        int high = this.intervals.size() - 1;
        Interval result = null;
        while (high >= low) {
            int middle = (high + low) / 2;
            Interval interval2 = (Interval)this.intervals.elementAt(middle);
            if (interval1.start <= interval2.end) {
                if (interval1.end >= interval2.start) {
                    result = interval2;
                }
                high = middle - 1;
                continue;
            }
            low = middle + 1;
        }
        return result;
    }

    private void remove(Interval interval) {
        this.intervals.removeElement(interval);
    }

    private void add(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            Interval iv = (Interval)this.intervals.elementAt(i);
            if (iv.start <= interval.start) continue;
            this.intervals.insertElementAt(interval, i);
            return;
        }
        this.intervals.addElement(interval);
    }

    public CharSet union(CharSet chars) {
        CharSet result = (CharSet)this.clone();
        Enumeration e = chars.intervals.elements();
        while (e.hasMoreElements()) {
            Interval overlap;
            Interval interval = (Interval)((Interval)e.nextElement()).clone();
            do {
                Interval largeInterval;
                if ((overlap = result.findOverlap(largeInterval = new Interval(interval.start == '\u0000' ? (char)'\u0000' : (char)(interval.start - '\u0001'), interval.end == '\uffff' ? (char)'\uffff' : (char)(interval.end + '\u0001')))) == null) continue;
                result.remove(overlap);
                interval.start = (char)Math.min(interval.start, overlap.start);
                interval.end = (char)Math.max(interval.end, overlap.end);
            } while (overlap != null);
            result.add(interval);
        }
        return result;
    }

    public CharSet diff(CharSet chars) {
        CharSet result = (CharSet)this.clone();
        Enumeration e = chars.intervals.elements();
        while (e.hasMoreElements()) {
            Interval overlap;
            Interval interval = (Interval)((Interval)e.nextElement()).clone();
            do {
                if ((overlap = result.findOverlap(interval)) == null) continue;
                result.remove(overlap);
                if (overlap.start < interval.start) {
                    result.add(new Interval(overlap.start, (char)(interval.start - '\u0001')));
                }
                if (overlap.end <= interval.end) continue;
                result.add(new Interval((char)(interval.end + '\u0001'), overlap.end));
            } while (overlap != null);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Enumeration e = this.intervals.elements();
        while (e.hasMoreElements()) {
            result.append("[" + e.nextElement() + "] ");
        }
        return "" + result;
    }

    public static class IntervalCast
    implements Cast {
        public static final IntervalCast instance = new IntervalCast();

        private IntervalCast() {
        }

        @Override
        public Object cast(Object o) {
            return (Interval)o;
        }
    }

    public static class Interval
    implements Cloneable {
        public char start;
        public char end;

        public Interval(char start, char end) {
            this.start = start;
            this.end = end;
        }

        public Object clone() {
            return new Interval(this.start, this.end);
        }

        private String c(char c) {
            if (c >= ' ' && c < '\u007f') {
                return "" + c;
            }
            return "" + c;
        }

        public String toString() {
            if (this.start < this.end) {
                return this.c(this.start) + " .. " + this.c(this.end);
            }
            return this.c(this.start);
        }
    }
}

