# encoding:utf-8

"""Custom exceptions used or raised by tmdb_api
"""

__author__ = 'Prinz23'
__version__ = '1.0'

__all__ = ['TmdbException', 'TmdbError', 'TmdbUserabort', 'TmdbShownotfound',
           'TmdbSeasonnotfound', 'TmdbEpisodenotfound', 'TmdbAttributenotfound', 'TmdbTokenexpired']

from lib.tvinfo_base.exceptions import *


class TmdbException(BaseTVinfoException):
    """Any exception generated by tvdb_api
    """
    pass


class TmdbError(BaseTVinfoError, TmdbException):
    """An error with thetvdb.com (Cannot connect, for example)
    """
    pass


class TmdbUserabort(BaseTVinfoUserabort, TmdbError):
    """User aborted the interactive selection (via
    the q command, ^c etc)
    """
    pass


class TmdbShownotfound(BaseTVinfoShownotfound, TmdbError):
    """Show cannot be found on thetvdb.com (non-existant show)
    """
    pass


class TmdbSeasonnotfound(BaseTVinfoSeasonnotfound, TmdbError):
    """Season cannot be found on thetvdb.com
    """
    pass


class TmdbEpisodenotfound(BaseTVinfoEpisodenotfound, TmdbError):
    """Episode cannot be found on thetvdb.com
    """
    pass


class TmdbAttributenotfound(BaseTVinfoAttributenotfound, TmdbError):
    """Raised if an episode does not have the requested
    attribute (such as a episode name)
    """
    pass


class TmdbTokenexpired(BaseTVinfoAuthenticationerror, TmdbError):
    """token expired or missing thetvdb.com
    """
    pass
