/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.util.Vector;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomerListener;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ZoomerXmlBean;

public class Zoomer {
    private double _zoom = 1.0;
    private double _oldZoom = 1.0;
    Vector<ZoomerListener> _listeners = new Vector();
    private boolean _enabled;
    private boolean _hideScrollBars;

    public Zoomer(ZoomerXmlBean xmlBean) {
        if (null != xmlBean) {
            this._zoom = xmlBean.getZoom();
            this._oldZoom = xmlBean.getOldZoom();
            this._enabled = xmlBean.isEnabled();
            this._hideScrollBars = xmlBean.isHideScrollbars();
        }
    }

    public void setEnabled(boolean b) {
        if (this._enabled == b) {
            return;
        }
        this._enabled = b;
        if (this._enabled) {
            this.setZoom(this._oldZoom, false);
        } else {
            this.setZoom(1.0, false);
        }
    }

    public void setZoom(double zoom, boolean adjusting) {
        this._oldZoom = this._zoom;
        this._zoom = zoom;
        ZoomerListener[] listeners = this._listeners.toArray(new ZoomerListener[this._listeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].zoomChanged(this._zoom, this._oldZoom, adjusting);
        }
    }

    public double getZoom() {
        return this._zoom;
    }

    public void addZoomListener(ZoomerListener l) {
        this._listeners.remove(l);
        this._listeners.add(l);
    }

    public void removeZoomListener(ZoomerListener l) {
        this._listeners.remove(l);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setHideScrollBars(boolean b) {
        this._hideScrollBars = b;
        ZoomerListener[] listeners = this._listeners.toArray(new ZoomerListener[this._listeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].setHideScrollBars(b);
        }
    }

    public ZoomerXmlBean getXmlBean() {
        ZoomerXmlBean xmlBean = new ZoomerXmlBean();
        xmlBean.setZoom(this._zoom);
        xmlBean.setOldZoom(this._oldZoom);
        xmlBean.setEnabled(this._enabled);
        xmlBean.setHideScrollbars(this._hideScrollBars);
        return xmlBean;
    }

    public boolean isHideScrollbars() {
        return this._hideScrollBars;
    }
}

