/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.breadcrumbbar;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

public class ScrollableJPopupMenu
extends JPopupMenu {
    private int visibleRowCount;
    private List children;
    JMenuItem previousItem;
    JMenuItem nextItem;
    private static Icon upIcon;
    private static Icon downIcon;
    private Timer previousTimer = new Timer(100, new MenuScrollAction(-1));
    private Timer nextTimer = new Timer(100, new MenuScrollAction(1));
    private int firstItemIndex;
    private static final int DEFAULT_ROW_COUNT = 15;
    private static final int DELAY = 100;
    private static final String PROPERTY_TIMER = "ScrollableJPopupMenu.timer";

    public ScrollableJPopupMenu() {
        this(15);
    }

    public ScrollableJPopupMenu(int rowCount) {
        this.enableEvents(131072L);
        this.visibleRowCount = rowCount;
        this.children = new ArrayList(rowCount);
        MenuMouseAdapter adapter = new MenuMouseAdapter();
        this.previousItem = new ArrowMenuItem(upIcon);
        this.previousItem.putClientProperty(PROPERTY_TIMER, this.previousTimer);
        this.previousItem.addMouseListener(adapter);
        this.nextItem = new ArrowMenuItem(downIcon);
        this.nextItem.putClientProperty(PROPERTY_TIMER, this.nextTimer);
        this.nextItem.addMouseListener(adapter);
        this.refresh();
    }

    public void addComponent(Component c) {
        this.children.add(c);
    }

    public void addSeparator() {
        this.addComponent(new JPopupMenu.Separator());
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        for (Component c : this.children) {
            c.applyComponentOrientation(o);
        }
    }

    public Dimension getPreferredSize() {
        this.refresh();
        return super.getPreferredSize();
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (this.getComponent(0) == this.previousItem) {
            int amt = e.getUnitsToScroll() > 0 ? 1 : -1;
            this.firstItemIndex += amt;
            this.refresh();
        }
        super.processMouseWheelEvent(e);
    }

    private void refresh() {
        this.removeAll();
        int itemCount = this.children.size();
        if (itemCount > this.visibleRowCount) {
            for (int i = 0; i < itemCount; ++i) {
                this.add((Component)this.children.get(i));
            }
            int w = super.getPreferredSize().width;
            this.removeAll();
            this.firstItemIndex = Math.min(itemCount - this.visibleRowCount, this.firstItemIndex);
            this.firstItemIndex = Math.max(0, this.firstItemIndex);
            this.previousItem.setEnabled(this.firstItemIndex > 0);
            this.nextItem.setEnabled(this.firstItemIndex < itemCount - this.visibleRowCount);
            this.add(this.previousItem);
            for (int i = 0; i < this.visibleRowCount && this.firstItemIndex + i < itemCount; ++i) {
                this.add((Component)this.children.get(this.firstItemIndex + i));
            }
            this.add(this.nextItem);
            Dimension size = super.getPreferredSize();
            size.width = w;
            this.setSize(size);
            this.revalidate();
            this.repaint();
        } else {
            for (int i = 0; i < itemCount; ++i) {
                this.add((Component)this.children.get(i));
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.refresh();
        }
        super.setVisible(visible);
    }

    static {
        ClassLoader cl = ScrollableJPopupMenu.class.getClassLoader();
        URL url = cl.getResource("org/fife/ui/breadcrumbbar/up.png");
        if (url == null) {
            try {
                url = new URL("file:///src/org/fife/ui/breadcrumbbar/up.png");
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        upIcon = new ImageIcon(url);
        url = cl.getResource("org/fife/ui/breadcrumbbar/down.png");
        if (url == null) {
            try {
                url = new URL("file:///src/org/fife/ui/breadcrumbbar/down.png");
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        downIcon = new ImageIcon(url);
    }

    private class MenuScrollAction
    extends AbstractAction {
        private int increment;

        public MenuScrollAction(int increment) {
            this.increment = increment;
        }

        public void actionPerformed(ActionEvent e) {
            ScrollableJPopupMenu.this.firstItemIndex += this.increment;
            ScrollableJPopupMenu.this.refresh();
        }
    }

    private static class MenuMouseAdapter
    extends MouseAdapter {
        private MenuMouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            Timer timer = (Timer)item.getClientProperty(ScrollableJPopupMenu.PROPERTY_TIMER);
            timer.start();
        }

        public void mouseExited(MouseEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            Timer timer = (Timer)item.getClientProperty(ScrollableJPopupMenu.PROPERTY_TIMER);
            timer.stop();
        }
    }

    private static class ArrowMenuItem
    extends JMenuItem {
        private Icon arrowIcon;
        private Icon disabledArrowIcon;

        public ArrowMenuItem(Icon icon) {
            super(icon);
            this.arrowIcon = icon;
            this.disabledArrowIcon = this.getDisabledIcon();
            this.setIcon(null);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Icon icon = this.isEnabled() ? this.arrowIcon : this.disabledArrowIcon;
            int x = (this.getWidth() - icon.getIconWidth()) / 2;
            int y = (this.getHeight() - icon.getIconHeight()) / 2;
            icon.paintIcon(this, g, x, y);
        }
    }
}

