'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH Tnm n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm \- Tcl extensions for network management applications.
.BE

.SH DESCRIPTION
The Tnm Tcl extensions has been written to simplify the development of
network management applications. The primary goal of the Tnm extension
is to provide a string-based API to access network protocols and
services relevant for network management applications.  Some of the
Tcl commands provided by the Tnm extension are useful for more general
networked applications as well.
.PP
A string-based API simplifies the development of site specific
management solutions because higher-level interfaces encapsulate the
complexity of some of the protocols supported by the Tnm extension.
The use of the Tcl language allows to integrate this extension with
the Tk toolkit. Management applications can thus be prototyped in a
cost-effective and platform independent way.

.SH COMMAND OVERVIEW
Below is a short overview over the Tcl commands provided the Tnm
extension. There are separate man pages for each command listed below
which describes the command and its options in more detail.
.TP 8
.B dns
Query the Domain Name System of the Internet.
.TP
.B http
Send and process HTTP requests.
.TP
.B icmp
Send ICMP messages to hosts on the Internet.
.TP
.B ined
Access and manipulate tkined objects.
.TP
.B job
Invoke Tcl procedures at regular intervals.
.TP
.B mib
Load and query SNMP MIB definitions.
.TP
.B netdb
Access the local network databases.
.TP
.B ntp
Retrieve control variables from NTP peers.
.TP
.B snmp
Send SNMP messages to devices on the Internet.
.TP
.B sunrpc
Call and probe selected Sun RPC services.
.TP
.B syslog
Write messages to the system logger.
.TP
.B udp
Send and receive UDP datagrams.

.SH ENVIRONMENT VARIABLES
.TP 18
TNM_LIBRARY
Path to the Tnm library directory.
.TP 18
TNM_NTPING
Path and name of ntping executable.
.TP 18
TNM_STRAPS
Path and name of straps executable.
.TP 18
TNM_RCFILE
Path and name of the initialization file.

.SH TCL VARIABLES
The Tnm extension defines the following global Tcl variables:
.TP 18
\fBtnm(library)\fR
The path to the scotty library directory. This variable is
initialized to the compiled in default. You can overwrite this
default by setting the TNM_LIBRARY environment variable.
.TP 18
\fBtnm(version)\fR
The version number of the Tnm extension.
.TP 18
\fBtnm(arch)\fR
A string that identifies the architecture and operating system.
Note, this will only work with Tcl version 7.5 and higher.
.TP 18
\fBtnm(host)\fR
The name of the local host executing the Tcl process.
.TP 18
\fBtnm(user)\fR
The name of the user running the Tcl process.
.TP 18
\fBtnm(mibs)\fR
This variable contains a list of SNMP MIB files that are loaded
automatically if not preceded by a mib load command.
.TP 18
\fBtnm(mibs:core)\fR
This variable contains a list of core SNMP MIB files that are
loaded even if the first mib command is a load command.

.SH FILES
.TP 18
~/.scottyrc
Personal initialization file. May be overwritten by the TNM_RCFILE
environment variable.
.TP 18
$tnm(library)/site/init.tcl
Site initialization file. Use this file to customize Tnm to your
site specific needs.
.TP 18
$tnm(library)/library/init.tcl
Tnm initialization file. Do not edit.
.TP 18
$tnm(library)/mibs
Archive of MIB and GDMO files.

.SH AVAILABILITY

The \fBTnm\fR Tcl extension is freely available in source form via
anonymous FTP. The source distribution is available from:
.PP
.RS
ftp://ftp.ibr.cs.tu-bs.de/pub/local/tkined/
.RE
.PP
The Tnm extension is contained in the scotty.tar.gz file which is
a link to the latest public-ally available version of this software.
Additional information about the Tnm extension is available on the
World Wide Web. The URL to the home-page of the scotty package is:
.PP
.RS
http://www.cs.utwente.nl/~schoenw/scotty/
.RE

.SH LICENSE
This software is copyrighted by Juergen Schoenwaelder, the Technical
University of Braunschweig, the University of Twente and other parties.
The following terms apply to all files associated with the software
unless explicitly disclaimed in individual files.
.PP
The authors hereby grant permission to use, copy, modify, distribute,
and license this software and its documentation for any purpose, provided
that existing copyright notices are retained in all copies and that this
notice is included verbatim in any distributions. No written agreement,
license, or royalty fee is required for any of the authorized uses.
Modifications to this software may be copyrighted by their authors
and need not follow the licensing terms described here, provided that
the new terms are clearly indicated on the first page of each file where
they apply.
.PP
IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
.PP
THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
MODIFICATIONS.
 
.SH SEE ALSO
scotty(1), Tcl(n)

.SH AUTHORS
The Tnm extension includes work contributed by students at the
Technical University of Braunschweig. The names of individuals who
provided major contributions are listed on the man pages for every
command. The current version also includes many improvements and bug
fixes contributed by the user community. Please read the README file
contained in the sources for a more complete list of individuals.
.PP
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
