package TDS::Navigator::Base;
#$Id: Base.pm,v 1.10 2000/12/08 02:02:31 tom Exp $
################################################################    

use strict qw(vars);
use Exporter;

use ObjectTemplate;
use DateTime::Date;
use Template;

use TDS::System;
use TDS::Collection;
use TDS::Mode;

use vars qw(@ISA @EXPORT
	    $Template $TemplateNoHref
	    );

@ISA = qw(DateTime::Date);
@EXPORT = qw(attributes);

{
    $Template = qq(<a href="%href" %accesskey_body>%label</a>);
    $TemplateNoHref = qq(%label);
}
attributes qw(use_accesskey);

################################################################
sub AsHTML($$;$)
{
    my ($self, $label, $params,  $nohref) = @_;

    my $class = ref $self;
    my $var;
    if (TDS::Mode::IsStatic()){
	$var = "${class}::HrefTemplateStatic";
    } else {
	$var = "${class}::HrefTemplateDynamic";
    }
    my $href_template = $$var;

    $params->{suffix} = $TDS::Static::HtmlSuffix;
    my $path = $ENV{'SCRIPT_NAME'} || "";
    $path =~ s![^/]*$!!;
    $params->{path} = $path;
    $params->{href} = Expand($href_template, $params);
    $params->{label} =  Expand($label, $params);
    if ($self->use_accesskey){
	$params->{accesskey_body} =
	    Expand(qq(accesskey=%accesskey), $params);
    }
    my $template = ($nohref) ? $TemplateNoHref : $Template;
    return Expand($template, $params);
}

1;
