/*
 * Decompiled with CFR 0.152.
 */
package org.openide.io;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.io.Bundle;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOContainer;
import org.openide.windows.IOFolding;
import org.openide.windows.IOPosition;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class BridgingIOProvider<IO, S extends PrintWriter, P, F>
extends IOProvider {
    private static final Logger LOG = Logger.getLogger(BridgingIOProvider.class.getName());
    private static final Set<ShowOperation> DEFAULT_SHOW_OPERATIONS = EnumSet.of(ShowOperation.OPEN, ShowOperation.MAKE_VISIBLE);
    private final InputOutputProvider<IO, S, P, F> providerDelegate;
    private Lookup lookup = null;

    public static <A, B extends PrintWriter, C, D> IOProvider create(InputOutputProvider<A, B, C, D> inputOutputProvider) {
        return new BridgingIOProvider<A, B, C, D>(inputOutputProvider);
    }

    private BridgingIOProvider(InputOutputProvider<IO, S, P, F> inputOutputProvider) {
        this.providerDelegate = inputOutputProvider;
    }

    @Override
    public InputOutput getIO(String string, boolean bl) {
        return new BridgingInputOutput(this.providerDelegate.getIO(string, bl, Lookup.EMPTY));
    }

    @Override
    public InputOutput getIO(String string, Action[] actionArray) {
        return new BridgingInputOutput(this.providerDelegate.getIO(string, true, Lookups.fixed((Object[])actionArray)));
    }

    @Override
    public InputOutput getIO(String string, Action[] actionArray, IOContainer iOContainer) {
        return this.getIO(string, true, actionArray, iOContainer);
    }

    @Override
    public InputOutput getIO(String string, boolean bl, Action[] actionArray, IOContainer iOContainer) {
        Action[] actionArray2;
        if (iOContainer != null) {
            actionArray2 = Arrays.copyOf(actionArray, actionArray.length + 1, Object[].class);
            actionArray2[actionArray.length] = iOContainer;
        } else {
            actionArray2 = actionArray;
        }
        return new BridgingInputOutput(this.providerDelegate.getIO(string, bl, Lookups.fixed((Object[])actionArray2)));
    }

    @Override
    public OutputWriter getStdOut() {
        Object object = this.providerDelegate.getIO(Bundle.LBL_STDOUT(), false, Lookup.EMPTY);
        PrintWriter printWriter = this.providerDelegate.getOut(object);
        return new BridgingOutputWriter(this, object, printWriter);
    }

    private Hyperlink listenerToHyperlink(final OutputListener outputListener, boolean bl) {
        return outputListener == null ? null : Hyperlink.from((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    outputListener.outputLineAction(null);
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "Cannot process output listener action", exception);
                }
            }
        }, (boolean)bl);
    }

    private class BridgingIOFolding
    extends IOFolding {
        private final IO ioDelegate;

        public BridgingIOFolding(IO IO) {
            this.ioDelegate = IO;
        }

        @Override
        protected IOFolding.FoldHandleDefinition startFold(boolean bl) {
            PrintWriter printWriter = BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate);
            Object object = BridgingIOProvider.this.providerDelegate.startFold(this.ioDelegate, printWriter, bl);
            return new BridgingFoldHandleDefinition(this, printWriter, object);
        }

        private static class BridgingFoldHandleDefinition
        extends IOFolding.FoldHandleDefinition {
            private final S writer;
            private final F fold;
            final /* synthetic */ BridgingIOFolding this$1;

            public BridgingFoldHandleDefinition(S s, F f) {
                this.this$1 = var1_1;
                this.writer = s;
                this.fold = f;
            }

            @Override
            public void finish() {
                this.this$1.BridgingIOProvider.this.providerDelegate.endFold(this.this$1.ioDelegate, this.writer, this.fold);
            }

            @Override
            public IOFolding.FoldHandleDefinition startFold(boolean bl) {
                Object object = this.this$1.BridgingIOProvider.this.providerDelegate.startFold(this.this$1.ioDelegate, this.writer, bl);
                return new BridgingFoldHandleDefinition(this.this$1, this.writer, object);
            }

            @Override
            public void setExpanded(boolean bl) {
                this.this$1.BridgingIOProvider.this.providerDelegate.setFoldExpanded(this.this$1.ioDelegate, this.writer, this.fold, bl);
            }
        }
    }

    private class BridgingIOPosition
    extends IOPosition {
        private final IO ioDelegate;

        public BridgingIOPosition(IO IO) {
            this.ioDelegate = IO;
        }

        @Override
        protected IOPosition.Position currentPosition() {
            final PrintWriter printWriter = BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate);
            final Object object = BridgingIOProvider.this.providerDelegate.getCurrentPosition(this.ioDelegate, printWriter);
            return new IOPosition.Position(){

                @Override
                public void scrollTo() {
                    BridgingIOProvider.this.providerDelegate.scrollTo(BridgingIOPosition.this.ioDelegate, printWriter, object);
                }
            };
        }
    }

    private class BridgingIOColorPrint
    extends IOColorPrint {
        private final IO ioDelegate;

        public BridgingIOColorPrint(IO IO) {
            this.ioDelegate = IO;
        }

        @Override
        protected void print(CharSequence charSequence, OutputListener outputListener, boolean bl, Color color) throws IOException {
            Hyperlink hyperlink = BridgingIOProvider.this.listenerToHyperlink(outputListener, bl);
            OutputColor outputColor = color == null ? null : OutputColor.rgb((int)color.getRGB());
            BridgingIOProvider.this.providerDelegate.print(this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate), charSequence.toString(), hyperlink, outputColor, false);
        }
    }

    private class BridgingIOColorLines
    extends IOColorLines {
        private final IO ioDelegate;

        public BridgingIOColorLines(IO IO) {
            this.ioDelegate = IO;
        }

        @Override
        protected void println(CharSequence charSequence, OutputListener outputListener, boolean bl, Color color) throws IOException {
            Hyperlink hyperlink = BridgingIOProvider.this.listenerToHyperlink(outputListener, bl);
            BridgingIOProvider.this.providerDelegate.print(this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate), charSequence.toString(), hyperlink, null, true);
        }
    }

    private static class BridgingOutputWriter
    extends OutputWriter {
        PrintWriter printWriterToReplace;
        private final S writerDelegate;
        private final IO ioDelegate;
        final /* synthetic */ BridgingIOProvider this$0;

        public BridgingOutputWriter(IO IO, S s) {
            this.this$0 = var1_1;
            super((Writer)s);
            this.printWriterToReplace = null;
            this.writerDelegate = s;
            this.ioDelegate = IO;
        }

        @Override
        public void println(String string, OutputListener outputListener) throws IOException {
            this.println(string, outputListener, false);
        }

        @Override
        public void println(String string, OutputListener outputListener, boolean bl) throws IOException {
            Hyperlink hyperlink = this.this$0.listenerToHyperlink(outputListener, bl);
            this.this$0.providerDelegate.print(this.ioDelegate, this.writerDelegate, string, hyperlink, null, true);
        }

        @Override
        public void reset() throws IOException {
            this.this$0.providerDelegate.resetIO(this.ioDelegate);
        }
    }

    private class BridgingInputOutput
    implements InputOutput,
    Lookup.Provider {
        private final IO ioDelegate;

        public BridgingInputOutput(IO IO) {
            this.ioDelegate = IO;
        }

        @Override
        public OutputWriter getOut() {
            return new BridgingOutputWriter(BridgingIOProvider.this, this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate));
        }

        @Override
        public Reader getIn() {
            return BridgingIOProvider.this.providerDelegate.getIn(this.ioDelegate);
        }

        @Override
        public OutputWriter getErr() {
            return new BridgingOutputWriter(BridgingIOProvider.this, this.ioDelegate, BridgingIOProvider.this.providerDelegate.getErr(this.ioDelegate));
        }

        @Override
        public void closeInputOutput() {
            BridgingIOProvider.this.providerDelegate.closeIO(this.ioDelegate);
        }

        @Override
        public boolean isClosed() {
            return BridgingIOProvider.this.providerDelegate.isIOClosed(this.ioDelegate);
        }

        @Override
        public void setOutputVisible(boolean bl) {
        }

        @Override
        public void setErrVisible(boolean bl) {
        }

        @Override
        public void setInputVisible(boolean bl) {
        }

        @Override
        public void select() {
            BridgingIOProvider.this.providerDelegate.showIO(this.ioDelegate, DEFAULT_SHOW_OPERATIONS);
        }

        @Override
        public boolean isErrSeparated() {
            return false;
        }

        @Override
        public void setErrSeparated(boolean bl) {
        }

        @Override
        public boolean isFocusTaken() {
            return false;
        }

        @Override
        public void setFocusTaken(boolean bl) {
        }

        @Override
        public Reader flushReader() {
            return this.getIn();
        }

        public synchronized Lookup getLookup() {
            if (BridgingIOProvider.this.lookup == null) {
                Lookup lookup = BridgingIOProvider.this.providerDelegate.getIOLookup(this.ioDelegate);
                Lookup lookup2 = Lookups.fixed((Object[])new Object[]{new BridgingIOColorLines(this.ioDelegate), new BridgingIOColorPrint(this.ioDelegate), new BridgingIOPosition(this.ioDelegate), new BridgingIOFolding(this.ioDelegate)});
                if (lookup == Lookup.EMPTY) {
                    BridgingIOProvider.this.lookup = lookup2;
                } else {
                    BridgingIOProvider.this.lookup = (Lookup)new ProxyLookup(new Lookup[]{lookup, lookup2});
                }
            }
            return BridgingIOProvider.this.lookup;
        }
    }
}

