/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IRange;

public class PredicateToolkit {
    private static final Predicate<Object> FALSE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }
    };
    private static final Predicate<Object> TRUE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }
    };

    public static <T> Predicate<T> truePredicate() {
        return TRUE;
    }

    public static <T> Predicate<T> falsePredicate() {
        return FALSE;
    }

    public static boolean isTrueGuaranteed(Predicate<?> p) {
        return p == TRUE;
    }

    public static boolean isFalseGuaranteed(Predicate<?> p) {
        return p == FALSE;
    }

    public static <T> Predicate<T> and(Collection<Predicate<T>> predicates) {
        switch (predicates.size()) {
            case 0: {
                return PredicateToolkit.truePredicate();
            }
            case 1: {
                return predicates.iterator().next();
            }
        }
        final ArrayList<Predicate<T>> nonTrivialPredicates = new ArrayList<Predicate<T>>(predicates.size());
        for (Predicate<T> p : predicates) {
            if (PredicateToolkit.isFalseGuaranteed(p)) {
                return p;
            }
            if (PredicateToolkit.isTrueGuaranteed(p)) continue;
            nonTrivialPredicates.add(p);
        }
        if (nonTrivialPredicates.size() == 0) {
            return PredicateToolkit.truePredicate();
        }
        if (nonTrivialPredicates.size() == 1) {
            return (Predicate)nonTrivialPredicates.get(0);
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                for (Predicate ex : nonTrivialPredicates) {
                    if (ex.test(o)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(Collection<Predicate<T>> predicates) {
        switch (predicates.size()) {
            case 0: {
                return PredicateToolkit.falsePredicate();
            }
            case 1: {
                return predicates.iterator().next();
            }
        }
        final ArrayList<Predicate<T>> nonTrivialPredicates = new ArrayList<Predicate<T>>(predicates.size());
        for (Predicate<T> p : predicates) {
            if (PredicateToolkit.isTrueGuaranteed(p)) {
                return p;
            }
            if (PredicateToolkit.isFalseGuaranteed(p)) continue;
            nonTrivialPredicates.add(p);
        }
        if (nonTrivialPredicates.size() == 0) {
            return PredicateToolkit.falsePredicate();
        }
        if (nonTrivialPredicates.size() == 1) {
            return (Predicate)nonTrivialPredicates.get(0);
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                for (Predicate ex : nonTrivialPredicates) {
                    if (!ex.test(o)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        if (PredicateToolkit.isTrueGuaranteed(predicate)) {
            return PredicateToolkit.falsePredicate();
        }
        if (PredicateToolkit.isFalseGuaranteed(predicate)) {
            return PredicateToolkit.truePredicate();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return !predicate.test(o);
            }
        };
    }

    public static <T, M> Predicate<T> less(IMemberAccessor<? extends M, T> valueAccessor, Comparable<? super M> limit, boolean orEqual) {
        return orEqual ? PredicateToolkit.lessOrEqual(valueAccessor, limit) : PredicateToolkit.less(valueAccessor, limit);
    }

    public static <T, M> Predicate<T> less(final IMemberAccessor<? extends M, T> valueAccessor, final Comparable<? super M> limit) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return value != null && limit.compareTo(value) > 0;
            }
        };
    }

    public static <T, M> Predicate<T> lessOrEqual(final IMemberAccessor<? extends M, T> valueAccessor, final Comparable<? super M> limit) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return value != null && limit.compareTo(value) >= 0;
            }
        };
    }

    public static <T, M> Predicate<T> more(IMemberAccessor<? extends M, T> valueAccessor, Comparable<? super M> limit, boolean orEqual) {
        return orEqual ? PredicateToolkit.moreOrEqual(valueAccessor, limit) : PredicateToolkit.more(valueAccessor, limit);
    }

    public static <T, M> Predicate<T> more(final IMemberAccessor<? extends M, T> valueAccessor, final Comparable<? super M> limit) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return value != null && limit.compareTo(value) < 0;
            }
        };
    }

    public static <T, M> Predicate<T> moreOrEqual(final IMemberAccessor<? extends M, T> valueAccessor, final Comparable<? super M> limit) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return value != null && limit.compareTo(value) <= 0;
            }
        };
    }

    public static <T, M extends Comparable<? super M>> Predicate<T> rangeIntersects(final IMemberAccessor<? extends IRange<M>, T> rangeAccessor, final IRange<M> limit) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                IRange value = (IRange)rangeAccessor.getMember(o);
                if (value != null) {
                    return value.getStart().compareTo(limit.getEnd()) <= 0 && value.getEnd().compareTo(limit.getStart()) >= 0;
                }
                return false;
            }
        };
    }

    public static <T, M extends Comparable<? super M>> Predicate<T> rangeContained(final IMemberAccessor<? extends IRange<M>, T> rangeAccessor, final IRange<M> limit) {
        if (limit.isPoint()) {
            M point = limit.getStart();
            return new Predicate<T>((Comparable)point){
                final /* synthetic */ Comparable val$point;
                {
                    this.val$point = comparable;
                }

                @Override
                public boolean test(T o) {
                    IRange value = (IRange)rangeAccessor.getMember(o);
                    return value != null && value.isPoint() && this.val$point.compareTo(value.getStart()) == 0;
                }
            };
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                IRange value = (IRange)rangeAccessor.getMember(o);
                if (value != null) {
                    return value.getStart().compareTo(limit.getStart()) >= 0 && value.getEnd().compareTo(limit.getEnd()) <= 0;
                }
                return false;
            }
        };
    }

    public static <T, M extends Comparable<? super M>> Predicate<T> centerContained(final IMemberAccessor<? extends IRange<M>, T> rangeAccessor, final IRange<M> limit) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                IRange value = (IRange)rangeAccessor.getMember(o);
                if (value != null) {
                    Object center = value.getCenter();
                    return center.compareTo(limit.getStart()) >= 0 && center.compareTo(limit.getEnd()) < 0;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> equals(final IMemberAccessor<?, T> valueAccessor, final Object item) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return item == null ? value == null : item.equals(value);
            }
        };
    }

    public static <T> Predicate<T> notEquals(final IMemberAccessor<?, T> valueAccessor, final Object item) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return item == null ? value != null : !item.equals(value);
            }
        };
    }

    public static <T> Predicate<T> is(final T item) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return o == item;
            }
        };
    }

    public static <T, M> Predicate<T> memberOf(final IMemberAccessor<? extends M, T> valueAccessor, final Set<? extends M> items) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                Object value = valueAccessor.getMember(o);
                return items.contains(value);
            }
        };
    }

    public static <T> Predicate<T> matches(final IMemberAccessor<? extends String, T> valueAccessor, String regexp) {
        final Pattern pattern = PredicateToolkit.getValidPattern(regexp);
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                String value = (String)valueAccessor.getMember(o);
                return value == null ? false : pattern.matcher(value).matches();
            }
        };
    }

    public static <T> Predicate<T> contains(final IMemberAccessor<? extends String, T> valueAccessor, final String substring) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                String value = (String)valueAccessor.getMember(o);
                return value == null ? false : value.contains(substring);
            }
        };
    }

    public static Pattern getValidPattern(String regexp) {
        try {
            return Pattern.compile(regexp, 32);
        }
        catch (PatternSyntaxException pse) {
            Logger.getLogger("org.openjdk.jmc.common.util").log(Level.FINE, "Got exception when compiling regular expression: " + pse.getMessage(), pse);
            return Pattern.compile("$.");
        }
    }
}

