/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.lzf.BufferRecycler;
import com.ning.compress.lzf.LZFDecoder;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LZFFileInputStream
extends FileInputStream {
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected boolean inputStreamClosed = false;
    protected boolean _cfgFullReads = false;
    private byte[] _inputBuffer = this._recycler.allocInputBuffer(65535);
    private byte[] _decodedBytes = this._recycler.allocDecodeBuffer(65535);
    private int bufferPosition = 0;
    private int bufferLength = 0;
    private final Wrapper _wrapper = new Wrapper();

    public LZFFileInputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public LZFFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    public LZFFileInputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public void setUseFullReads(boolean b) {
        this._cfgFullReads = b;
    }

    public int available() {
        if (this.inputStreamClosed) {
            return -1;
        }
        int left = this.bufferLength - this.bufferPosition;
        return left <= 0 ? 0 : left;
    }

    public void close() throws IOException {
        this.bufferLength = 0;
        this.bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this.inputStreamClosed) {
            this.inputStreamClosed = true;
            super.close();
        }
    }

    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this.bufferPosition++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this.bufferLength - this.bufferPosition, length);
        System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
        this.bufferPosition += chunkLength;
        if (chunkLength == length || !this._cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this.bufferLength - this.bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
            this.bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public long skip(long n) throws IOException {
        if (this.inputStreamClosed) {
            return -1L;
        }
        int left = this.bufferLength - this.bufferPosition;
        if (left <= 0) {
            int b = this.read();
            if (b < 0) {
                return -1L;
            }
            --this.bufferPosition;
            left = this.bufferLength - this.bufferPosition;
        }
        if ((long)left > n) {
            left = (int)n;
        }
        this.bufferPosition += left;
        return left;
    }

    protected boolean readyBuffer() throws IOException {
        if (this.bufferPosition < this.bufferLength) {
            return true;
        }
        if (this.inputStreamClosed) {
            return false;
        }
        this.bufferLength = LZFDecoder.decompressChunk(this._wrapper, this._inputBuffer, this._decodedBytes);
        if (this.bufferLength < 0) {
            return false;
        }
        this.bufferPosition = 0;
        return this.bufferPosition < this.bufferLength;
    }

    protected final int readRaw(byte[] buffer, int offset, int length) throws IOException {
        return super.read(buffer, offset, length);
    }

    private final class Wrapper
    extends InputStream {
        private Wrapper() {
        }

        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return LZFFileInputStream.this.readRaw(buffer, offset, length);
        }
    }
}

