/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.vmconversion.AsciiProgressBar;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import com.amazon.aes.webservices.client.vmconversionschema.Part;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDiskImage
extends BaseCmd {
    public static final String[] OWNER_SAK_DESC_ = new String[]{"AWS Secret Access Key of the owner of BUCKET, used to access S3 for deleting", "the uploaded-disk-image. This parameter value is not sent to EC2. [REQUIRED]."};
    public static final String[] IMPORT_URL_DESC = new String[]{"Specify the URL for an existing import-manifest file. Using this option to", "delete the uploaded disk-image irrespective whether one or more active", "conversion tasks still reference the said manifest. [REQUIRED] unless the", "'task' option has been specified."};
    public static final String[] MANIFEST_SPEC_ATTRIBUES = new String[]{"task", "manifest-url"};
    public static final String[] TASK_DESC = new String[]{"Task-ID of the conversion task that is no longer active. [REQUIRED] unless", "the 'manifest-url' option has been specified."};
    public static final String IGNORE_ACTIVE_TASK = "ignore-active-task";
    public static final String[] IGNORE_ACTIVE_TASK_DESC = new String[]{"Delete the uploaded disk-image despite having an active task. [OPTIONAL]", "Using this option may cause active taskss to fail. USE AT YOUR OWN RISK."};
    private static final String PART_SUFFIX = "part";
    protected URL manifestUrl;
    protected String s3AccessId;
    protected String s3SecretKey;
    protected S3Service s3Service;
    protected String taskId;
    protected boolean ignoreActiveTask;
    protected String bucketName;
    protected Manifest manifest;
    protected S3Object manifestS3Object;

    public DeleteDiskImage(String short_form, String long_form) {
        super(short_form, long_form);
    }

    public DeleteDiskImage(String[] args) {
        super("ec2ddi", "ec2-delete-disk-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"manifest-url");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(IMPORT_URL_DESC));
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"OWNERAKID");
        OptionBuilder.withDescription((String)this.joinDescription("AWS Access Key Id of the owner of BUCKET."));
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECRETKEY");
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(OWNER_SAK_DESC_));
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)"task");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TASK-ID");
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(TASK_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)IGNORE_ACTIVE_TASK);
        OptionBuilder.withDescription((String)DeleteDiskImage.joinDescription(IGNORE_ACTIVE_TASK_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS]";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("task");
        this.printOption("manifest-url");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption(IGNORE_ACTIVE_TASK);
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete a partially or fully uploaded disk-image for conversion-tasks ");
        System.out.println("     from S3. You can either specify the TASK-ID for the conversion task, or");
        System.out.println("     provide the URL to the import-manifest file in S3.");
    }

    public void validateAndSetupS3Access() throws GeneralError {
        this.assertOptionSet("owner-akid");
        this.s3AccessId = this.getOptionValue("owner-akid");
        this.assertOptionSet("owner-sak");
        this.s3SecretKey = this.getOptionValue("owner-sak");
        try {
            this.s3Service = new RestS3Service((ProviderCredentials)new AWSCredentials(this.s3AccessId, this.s3SecretKey));
        }
        catch (S3ServiceException e) {
            throw new GeneralError("Error initializing S3 Client with user credentials");
        }
    }

    protected void validateParameters() throws VerificationException {
        this.validateAndSetupS3Access();
        this.assertOnlyOneOptionSet(MANIFEST_SPEC_ATTRIBUES);
        String manifestStr = null;
        if (this.isOptionSet("manifest-url")) {
            manifestStr = this.getOptionValue("manifest-url");
            try {
                this.manifestUrl = new URL(manifestStr);
            }
            catch (MalformedURLException e) {
                throw new VerificationException("The specified manifest-url " + manifestStr + " is malformed");
            }
        } else {
            this.taskId = this.getOptionValue("task");
            this.ignoreActiveTask = this.isOptionSet(IGNORE_ACTIVE_TASK);
        }
    }

    protected URL validateAndGetUrlFromTask(Jec2 jec2) throws Exception {
        ConversionTaskDescription task = jec2.describeConversionTask(this.taskId);
        ImportVolumeConversionTask importTask = null;
        String tasktype = task.getTaskType();
        if (tasktype.equals("ImportVolume")) {
            importTask = task.getImportVolumeConversionTask();
        } else if (tasktype.equals("ImportInstance")) {
            importTask = (ImportVolumeConversionTask)task.getImportInstanceConversionTask().getVolumes().get(0);
        } else {
            throw new GeneralError("The task ID " + task + " is not a known task type.");
        }
        if (importTask == null) {
            throw new GeneralError("The task ID " + task + " has no details for retriving the manifest URL");
        }
        if (task.getStatus().equalsIgnoreCase("active") && !this.ignoreActiveTask) {
            throw new GeneralError("The task " + this.taskId + " is still active. Use --" + IGNORE_ACTIVE_TASK + " to force the deletion.");
        }
        try {
            return new URL(importTask.getImportManifestUrl());
        }
        catch (MalformedURLException e) {
            throw new GeneralError("The task ID " + task + " has an invalid import-manifest-url");
        }
    }

    protected Manifest getManifestIfExists() throws GeneralError {
        Manifest manifest;
        block4: {
            manifest = null;
            this.manifestS3Object = ManifestFactory.getManifestS3Object((URL)this.manifestUrl);
            this.bucketName = ManifestFactory.getBucketName((S3Object)this.manifestS3Object);
            try {
                if (!this.s3Service.isObjectInBucket(this.bucketName, this.manifestS3Object.getKey())) break block4;
                try {
                    S3Object manifestObj = this.s3Service.getObject(this.bucketName, this.manifestS3Object.getKey());
                    ManifestFactory mf = new ManifestFactory(this.s3Service);
                    manifest = mf.loadExistingManifest(manifestObj);
                }
                catch (Exception e) {
                    throw new GeneralError("Unable to load manifest at " + this.bucketName + "/" + this.manifestS3Object.getKey());
                }
            }
            catch (ServiceException e) {
                String msg = e.getErrorMessage();
                throw new InternalException("Cannot determine if manifest file exists. " + msg);
            }
        }
        return manifest;
    }

    private String getCommonPrefix() throws VerificationException {
        Part part = (Part)this.manifest.getImport().getParts().getPart().get(0);
        String prefix = part.getKey().replaceFirst("part\\d+$", PART_SUFFIX);
        if (!prefix.endsWith(PART_SUFFIX)) {
            throw new VerificationException("Unable to determine common prefix for " + part.getKey());
        }
        return prefix;
    }

    private Map<String, S3Object> findExistingParts(String prefix) throws S3ServiceException {
        S3Object[] objects;
        HashMap<String, S3Object> existingParts = new HashMap<String, S3Object>();
        for (S3Object object : objects = this.s3Service.listObjects(this.bucketName, prefix, null, 100L)) {
            existingParts.put(object.getKey(), object);
        }
        return existingParts;
    }

    public void deleteManifestParts() throws VerificationException, GeneralError {
        Map<String, S3Object> existingParts;
        String prefix = this.getCommonPrefix();
        try {
            existingParts = this.findExistingParts(prefix);
        }
        catch (S3ServiceException e) {
            throw new GeneralError("Unexpected error while processing the manifest. Please retry");
        }
        AsciiProgressBar progressBar = new AsciiProgressBar((long)(existingParts.size() + 1), System.out);
        progressBar.preamble();
        for (Map.Entry<String, S3Object> pairs : existingParts.entrySet()) {
            this.deleteS3Object(pairs.getValue().getKey());
            progressBar.updateRelative(1L);
        }
        this.deleteS3Object(this.manifestS3Object.getKey());
        progressBar.updateRelative(1L);
        progressBar.postamble();
    }

    private void deleteS3Object(String objectKey) throws GeneralError {
        try {
            this.s3Service.deleteObject(this.bucketName, objectKey);
        }
        catch (Exception e) {
            throw new GeneralError("Could not delete " + objectKey + ". Please retry");
        }
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateParameters();
            if (this.manifestUrl == null) {
                this.manifestUrl = this.validateAndGetUrlFromTask(jec2);
            }
            this.manifest = this.getManifestIfExists();
            if (this.manifest == null) {
                System.out.println("The manifest file does not exist. Nothing to delete");
            } else {
                this.deleteManifestParts();
            }
            return true;
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        new DeleteDiskImage(args).invoke();
    }
}

