/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.io.IOException;
import nu.xom.converters.SAXConverter;
import nu.xom.xslt.XOMInputSource;
import nu.xom.xslt.XSLTHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class XOMReader
implements XMLReader {
    private SAXConverter converter;

    XOMReader() {
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string) || "http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException("XOMReader doesn't support features");
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.converter.getLexicalHandler();
        }
        throw new SAXNotRecognizedException("XOMReader doesn't support features");
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!"http://xml.org/sax/properties/lexical-handler".equals(string)) {
            throw new SAXNotRecognizedException("XOMReader doesn't support " + string);
        }
        LexicalHandler lexicalHandler = (LexicalHandler)object;
        this.converter.setLexicalHandler(lexicalHandler);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.converter = new SAXConverter(contentHandler);
        this.converter.setContentHandler(new XSLTHandler(null));
    }

    @Override
    public ContentHandler getContentHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        XOMInputSource xOMInputSource = (XOMInputSource)inputSource;
        this.converter.convert(xOMInputSource.getNodes());
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }
}

