/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.omegat.util.OStrings;

public class MenuItemPager {
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    private Container menu;
    private int count;
    private int itemsPerPage;
    private List<JMenuItem> firstPage;

    public MenuItemPager(JPopupMenu menu) {
        this((Container)menu);
    }

    public MenuItemPager(JMenu menu) {
        this((Container)menu);
    }

    private MenuItemPager(Container menu) {
        this.menu = Objects.requireNonNull(menu);
        this.count = 0;
        this.itemsPerPage = 10;
        this.firstPage = new ArrayList<JMenuItem>(this.itemsPerPage + 1);
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public JMenuItem add(JMenuItem newItem) {
        if (this.count > 0 && this.count % this.itemsPerPage == 0) {
            this.newPage();
        }
        this.addImpl(newItem);
        ++this.count;
        return newItem;
    }

    private void newPage() {
        JMenu newSubmenu = new JMenu(OStrings.getString("MW_MORE_SUBMENU"));
        this.menu = this.addImpl(newSubmenu);
    }

    private JMenuItem addImpl(JMenuItem item) {
        if (this.firstPage.size() < this.itemsPerPage + 1) {
            this.firstPage.add(item);
        }
        this.menu.add(item);
        return item;
    }

    public List<JMenuItem> getFirstPage() {
        return Collections.unmodifiableList(this.firstPage);
    }
}

