/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.sql.DataSourceUtil;
import org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport;

public abstract class UpdateTagSupport
extends BodyTagSupport
implements TryCatchFinally,
SQLExecutionTag {
    private String var;
    private int scope;
    protected Object rawDataSource;
    protected boolean dataSourceSpecified;
    protected String sql;
    private Connection conn;
    private List parameters;
    private boolean isPartOfTransaction;
    static /* synthetic */ Class class$org$apache$taglibs$standard$tag$common$sql$TransactionTagSupport;

    public UpdateTagSupport() {
        this.init();
    }

    private void init() {
        this.rawDataSource = null;
        this.sql = null;
        this.conn = null;
        this.parameters = null;
        this.dataSourceSpecified = false;
        this.isPartOfTransaction = false;
        this.scope = 1;
        this.var = null;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public int doStartTag() throws JspException {
        try {
            this.conn = this.getConnection();
        }
        catch (SQLException sQLException) {
            throw new JspException(this.sql + ": " + sQLException.getMessage(), (Throwable)sQLException);
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        String string = null;
        if (this.sql != null) {
            string = this.sql;
        } else if (this.bodyContent != null) {
            string = this.bodyContent.getString();
        }
        if (string == null || string.trim().length() == 0) {
            throw new JspTagException(Resources.getMessage("SQL_NO_STATEMENT"));
        }
        int n = 0;
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string);
            this.setParameters(preparedStatement, this.parameters);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            throw new JspException(string + ": " + throwable.getMessage(), throwable);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)new Integer(n), this.scope);
        }
        return 6;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        if (this.conn != null && !this.isPartOfTransaction) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.parameters = null;
        this.conn = null;
    }

    public void addSQLParameter(Object object) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(object);
    }

    private Connection getConnection() throws JspException, SQLException {
        Connection connection = null;
        this.isPartOfTransaction = false;
        TransactionTagSupport transactionTagSupport = (TransactionTagSupport)UpdateTagSupport.findAncestorWithClass((Tag)this, (Class)(class$org$apache$taglibs$standard$tag$common$sql$TransactionTagSupport == null ? (class$org$apache$taglibs$standard$tag$common$sql$TransactionTagSupport = UpdateTagSupport.class$("org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport")) : class$org$apache$taglibs$standard$tag$common$sql$TransactionTagSupport));
        if (transactionTagSupport != null) {
            if (this.dataSourceSpecified) {
                throw new JspTagException(Resources.getMessage("ERROR_NESTED_DATASOURCE"));
            }
            connection = transactionTagSupport.getSharedConnection();
            this.isPartOfTransaction = true;
        } else {
            if (this.rawDataSource == null && this.dataSourceSpecified) {
                throw new JspException(Resources.getMessage("SQL_DATASOURCE_NULL"));
            }
            DataSource dataSource = DataSourceUtil.getDataSource(this.rawDataSource, this.pageContext);
            try {
                connection = dataSource.getConnection();
            }
            catch (Exception exception) {
                throw new JspException(Resources.getMessage("DATASOURCE_INVALID", exception.toString()));
            }
        }
        return connection;
    }

    private void setParameters(PreparedStatement preparedStatement, List list) throws SQLException {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setObject(i + 1, list.get(i));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

