/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InstanceStateChangeDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class TerminateInstances
extends BaseCmd {
    public TerminateInstances(String[] args) {
        super("ec2kill", "ec2-terminate-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        return result;
    }

    protected String getOptionString() {
        return "INSTANCE [INSTANCE [...]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Terminate selected running instances.");
        System.out.println("     The INSTANCE parameter is an instance ID to terminate.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INSTANCE");
        String[] instanceIds = this.getNonOptions();
        RequestResultPair rsp = jec2.terminateInstances(instanceIds);
        for (InstanceStateChangeDescription tid : (List)rsp.getResponse()) {
            out.output(System.out, tid);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new TerminateInstances(args).invoke();
    }
}

