/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;

public class IndexLifecycleFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private ClusterService clusterService;

    @Inject
    public IndexLifecycleFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.enabled = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "ilm";
    }

    public String description() {
        return "Index lifecycle management for the Elastic Stack";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isIndexLifecycleAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        MetaData metaData = this.clusterService.state().metaData();
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)metaData.custom("index_lifecycle");
        if (this.enabled() && lifecycleMetadata != null) {
            HashMap policyUsage = new HashMap();
            metaData.indices().forEach(entry -> {
                String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(((IndexMetaData)entry.value).getSettings());
                Integer indicesManaged = (Integer)policyUsage.get(policyName);
                indicesManaged = indicesManaged == null ? Integer.valueOf(1) : Integer.valueOf(indicesManaged + 1);
                policyUsage.put(policyName, indicesManaged);
            });
            List policyStats = lifecycleMetadata.getPolicies().values().stream().map(policy -> {
                Map<String, IndexLifecycleFeatureSetUsage.PhaseStats> phaseStats = policy.getPhases().values().stream().map(phase -> {
                    String[] actionNames = phase.getActions().keySet().toArray(new String[phase.getActions().size()]);
                    return new Tuple((Object)phase.getName(), (Object)new IndexLifecycleFeatureSetUsage.PhaseStats(phase.getMinimumAge(), actionNames));
                }).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
                return new IndexLifecycleFeatureSetUsage.PolicyStats(phaseStats, policyUsage.getOrDefault(policy.getName(), 0).intValue());
            }).collect(Collectors.toList());
            listener.onResponse((Object)new IndexLifecycleFeatureSetUsage(this.available(), this.enabled(), policyStats));
        } else {
            listener.onResponse((Object)new IndexLifecycleFeatureSetUsage(this.available(), this.enabled()));
        }
    }
}

