/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleRunner;

public class MoveToNextStepUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(MoveToNextStepUpdateTask.class);
    private final Index index;
    private final String policy;
    private final Step.StepKey currentStepKey;
    private final Step.StepKey nextStepKey;
    private final LongSupplier nowSupplier;
    private final Consumer<ClusterState> stateChangeConsumer;

    public MoveToNextStepUpdateTask(Index index, String policy, Step.StepKey currentStepKey, Step.StepKey nextStepKey, LongSupplier nowSupplier, Consumer<ClusterState> stateChangeConsumer) {
        this.index = index;
        this.policy = policy;
        this.currentStepKey = currentStepKey;
        this.nextStepKey = nextStepKey;
        this.nowSupplier = nowSupplier;
        this.stateChangeConsumer = stateChangeConsumer;
    }

    Index getIndex() {
        return this.index;
    }

    String getPolicy() {
        return this.policy;
    }

    Step.StepKey getCurrentStepKey() {
        return this.currentStepKey;
    }

    Step.StepKey getNextStepKey() {
        return this.nextStepKey;
    }

    public ClusterState execute(ClusterState currentState) {
        IndexMetaData indexMetaData = currentState.getMetaData().index(this.index);
        if (indexMetaData == null) {
            return currentState;
        }
        Settings indexSettings = indexMetaData.getSettings();
        LifecycleExecutionState indexILMData = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)currentState.getMetaData().index(this.index));
        if (this.policy.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings)) && this.currentStepKey.equals((Object)IndexLifecycleRunner.getCurrentStepKey(indexILMData))) {
            logger.trace("moving [{}] to next step ({})", (Object)this.index.getName(), (Object)this.nextStepKey);
            return IndexLifecycleRunner.moveClusterStateToNextStep(this.index, currentState, this.currentStepKey, this.nextStepKey, this.nowSupplier, false);
        }
        return currentState;
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        if (!oldState.equals(newState)) {
            this.stateChangeConsumer.accept(newState);
        }
    }

    public void onFailure(String source, Exception e) {
        throw new ElasticsearchException("policy [" + this.policy + "] for index [" + this.index.getName() + "] failed trying to move from step [" + this.currentStepKey + "] to step [" + this.nextStepKey + "].", (Throwable)e, new Object[0]);
    }
}

