/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.ArrayList;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.classfile.constant.ConstantString;
import jd.core.model.classfile.constant.ConstantValue;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.Ldc;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotClass118AReconstructor {
    public static void Reconstruct(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list) {
        int i = list.size();
        if (i < 6) {
            return;
        }
        i -= 5;
        ConstantPool constants = classFile.getConstantPool();
        block0: while (i-- > 0) {
            String signature;
            ConstantString cs;
            Instruction instruction = list.get(i);
            if (instruction.opcode != 262) continue;
            IfInstruction ii = (IfInstruction)instruction;
            if (ii.value.opcode != 178) continue;
            GetStatic gs = (GetStatic)ii.value;
            int jumpOffset = ii.GetJumpOffset();
            instruction = list.get(i + 1);
            if (instruction.opcode != 280) continue;
            TernaryOpStore tos = (TernaryOpStore)instruction;
            if (tos.objectref.opcode != 178 || gs.index != ((GetStatic)tos.objectref).index) continue;
            instruction = list.get(i + 2);
            if (instruction.opcode != 167) continue;
            Goto g = (Goto)instruction;
            instruction = list.get(i + 3);
            if (instruction.opcode != 264 || g.offset >= jumpOffset || jumpOffset > instruction.offset) continue;
            DupStore ds = (DupStore)instruction;
            if (ds.objectref.opcode != 184) continue;
            Invokestatic is = (Invokestatic)ds.objectref;
            if (is.args.size() != 1) continue;
            instruction = (Instruction)is.args.get(0);
            if (instruction.opcode != 18) continue;
            ConstantMethodref cmr = constants.getConstantMethodref(is.index);
            ConstantNameAndType cnatMethod = constants.getConstantNameAndType(cmr.name_and_type_index);
            String nameMethod = constants.getConstantUtf8(cnatMethod.name_index);
            if (!nameMethod.equals("class$")) continue;
            Ldc ldc = (Ldc)instruction;
            ConstantValue cv = constants.getConstantValue(ldc.index);
            if (cv.tag != 8) continue;
            instruction = list.get(i + 4);
            if (instruction.opcode != 179) continue;
            PutStatic ps = (PutStatic)instruction;
            if (ps.valueref.opcode != 263 || ds.offset != ps.valueref.offset) continue;
            ConstantFieldref cfr = constants.getConstantFieldref(gs.index);
            ConstantNameAndType cnatField = constants.getConstantNameAndType(cfr.name_and_type_index);
            String signatureField = constants.getConstantUtf8(cnatField.descriptor_index);
            if (!signatureField.equals("Ljava/lang/Class;")) continue;
            String nameField = constants.getConstantUtf8(cnatField.name_index);
            if (nameField.startsWith("class$")) {
                cs = (ConstantString)cv;
                signature = constants.getConstantUtf8(cs.string_index);
                String internalName = signature.replace('.', '/');
                referenceMap.add(internalName);
                int index = constants.addConstantUtf8(internalName);
                index = constants.addConstantClass(index);
                ldc = new Ldc(18, ii.offset, ii.lineNumber, index);
                ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(ds, ldc);
                int j = i + 5;
                while (j < list.size()) {
                    visitor.visit(list.get(j));
                    if (visitor.getParentFound() == null) {
                        ++j;
                        continue;
                    }
                    break;
                }
            } else {
                Instruction newArray;
                if (!nameField.startsWith("array$")) continue;
                cs = (ConstantString)cv;
                signature = constants.getConstantUtf8(cs.string_index);
                String signatureWithoutDimension = SignatureUtil.CutArrayDimensionPrefix(signature);
                IConst iconst0 = new IConst(256, ii.offset, ii.lineNumber, 0);
                if (SignatureUtil.IsObjectSignature(signatureWithoutDimension)) {
                    String tmp = signatureWithoutDimension.replace('.', '/');
                    String internalName = tmp.substring(1, tmp.length() - 1);
                    referenceMap.add(internalName);
                    int index = constants.addConstantUtf8(internalName);
                    index = constants.addConstantClass(index);
                    newArray = new ANewArray(189, ii.offset, ii.lineNumber, index, iconst0);
                } else {
                    newArray = new NewArray(188, ii.offset, ii.lineNumber, SignatureUtil.GetTypeFromSignature(signatureWithoutDimension), iconst0);
                }
                int methodNameIndex = constants.addConstantUtf8("getClass");
                int methodDescriptorIndex = constants.addConstantUtf8("()Ljava/lang/Class;");
                int nameAndTypeIndex = constants.addConstantNameAndType(methodNameIndex, methodDescriptorIndex);
                int cmrIndex = constants.addConstantMethodref(constants.objectClassIndex, nameAndTypeIndex);
                Invokevirtual iv = new Invokevirtual(182, ii.offset, ii.lineNumber, cmrIndex, newArray, new ArrayList<Instruction>(0));
                ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(ds, iv);
                int j = i + 5;
                while (j < list.size()) {
                    visitor.visit(list.get(j));
                    if (visitor.getParentFound() == null) {
                        ++j;
                        continue;
                    }
                    break;
                }
            }
            list.remove(i + 4);
            list.remove(i + 3);
            list.remove(i + 2);
            list.remove(i + 1);
            list.remove(i);
            Field[] fields = classFile.getFields();
            int j = fields.length;
            while (j-- > 0) {
                Field field = fields[j];
                if (field.name_index != cnatField.name_index) continue;
                field.access_flags |= 0x1000;
                break;
            }
            Method[] methods = classFile.getMethods();
            j = methods.length;
            while (j-- > 0) {
                Method method = methods[j];
                if (method.name_index != cnatMethod.name_index) continue;
                method.access_flags |= 0x1000;
                continue block0;
            }
        }
    }
}

