/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Broker;
import kafka.cluster.Cluster;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u00111BR3uG\",'\u000fV3ti*\u00111\u0001B\u0001\fS:$Xm\u001a:bi&|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002A1A\u0005\u0002I\t\u0001B\\;n\u001d>$Wm]\u000b\u0002'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t\u0019\u0011J\u001c;\t\ri\u0001\u0001\u0015!\u0003\u0014\u0003%qW/\u001c(pI\u0016\u001c\b\u0005C\u0003\u001d\u0001\u0011\u0005Q$A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005q\u0002cA\u0010(U9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003G\u0019\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0005\u0019*\u0012a\u00029bG.\fw-Z\u0005\u0003Q%\u00121aU3r\u0015\t1S\u0003\u0005\u0002,]5\tAF\u0003\u0002.\t\u000511/\u001a:wKJL!a\f\u0017\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003!iWm]:bO\u0016\u001cX#A\u001a\u0011\tQJ4cO\u0007\u0002k)\u0011agN\u0001\b[V$\u0018M\u00197f\u0015\tAT#\u0001\u0006d_2dWm\u0019;j_:L!AO\u001b\u0003\u000f!\u000b7\u000f['baB\u0019A(\u0010 \u000e\u0003]J!\u0001K\u001c\u0011\u0007Qy\u0014)\u0003\u0002A+\t)\u0011I\u001d:bsB\u0011ACQ\u0005\u0003\u0007V\u0011AAQ=uK\"1Q\t\u0001Q\u0001\nM\n\u0011\"\\3tg\u0006<Wm\u001d\u0011\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\u0006)Ao\u001c9jGV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\rM#(/\u001b8h\u0011\u0019\u0011\u0006\u0001)A\u0005\u0013\u00061Ao\u001c9jG\u0002Bq\u0001\u0016\u0001C\u0002\u0013\u0005Q+A\u0003rk\u0016,X-F\u0001W!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\u000bG>t7-\u001e:sK:$(BA.N\u0003\u0011)H/\u001b7\n\u0005uC&a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007CA0c\u001b\u0005\u0001'BA1\u0005\u0003!\u0019wN\\:v[\u0016\u0014\u0018BA2a\u0005A1U\r^2iK\u0012$\u0015\r^1DQVt7\u000e\u0003\u0004f\u0001\u0001\u0006IAV\u0001\u0007cV,W/\u001a\u0011\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\u00069a-\u001a;dQ\u0016\u0014X#A5\u0011\u0005}S\u0017BA6a\u0005Y\u0019uN\\:v[\u0016\u0014h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bbB7\u0001\u0001\u0004%\tA\\\u0001\fM\u0016$8\r[3s?\u0012*\u0017\u000f\u0006\u0002peB\u0011A\u0003]\u0005\u0003cV\u0011A!\u00168ji\"91\u000f\\A\u0001\u0002\u0004I\u0017a\u0001=%c!1Q\u000f\u0001Q!\n%\f\u0001BZ3uG\",'\u000f\t\u0005\u0006o\u0002!\t\u0005_\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002_\"\u0012aO\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!\u00026v]&$(\"A@\u0002\u0007=\u0014x-C\u0002\u0002\u0004q\u0014aAQ3g_J,\u0007BBA\u0004\u0001\u0011\u0005\u00030\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t)!a\u0003\u0011\u0007m\fi!C\u0002\u0002\u0010q\u0014Q!\u00114uKJDa!a\u0005\u0001\t\u0003A\u0018a\u0003;fgR4U\r^2iKJDC!!\u0005\u0002\u0018A\u001910!\u0007\n\u0007\u0005mAP\u0001\u0003UKN$\bBBA\u0010\u0001\u0011\u0005\u00010\u0001\tbgN,'\u000f^)vKV,W)\u001c9us\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012!\u00024fi\u000eDGcA8\u0002(!9\u0011\u0011FA\u0011\u0001\u0004\u0019\u0012\u0001C3ya\u0016\u001cG/\u001a3)\u000f\u0001\ti#a\r\u00028A\u0019A#a\f\n\u0007\u0005ERC\u0001\u0006eKB\u0014XmY1uK\u0012\f#!!\u000e\u0002\rRC\u0017n\u001d\u0011uKN$\b\u0005[1tA\t,WM\u001c\u0011eKB\u0014XmY1uK\u0012\u0004\u0013M\u001c3!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000eI1!MV$XO]3!e\u0016dW-Y:f]\u0005\u0012\u0011\u0011H\u0001\ta9\n\u0014G\f\u0019/a\u0001")
public class FetcherTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final HashMap<Object, Seq<byte[]>> messages = new HashMap();
    private final String topic;
    private final LinkedBlockingQueue<FetchedDataChunk> queue = new LinkedBlockingQueue();
    private ConsumerFetcherManager fetcher = null;

    public int numNodes() {
        return this.numNodes;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    public HashMap<Object, Seq<byte[]>> messages() {
        return this.messages;
    }

    public String topic() {
        return this.topic;
    }

    public LinkedBlockingQueue<FetchedDataChunk> queue() {
        return this.queue;
    }

    public ConsumerFetcherManager fetcher() {
        return this.fetcher;
    }

    public void fetcher_$eq(ConsumerFetcherManager x$1) {
        this.fetcher = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})))}))));
        Cluster cluster = new Cluster((Iterable)this.servers().map((Function1 & Serializable & scala.Serializable)s -> new Broker(s.config().brokerId(), "localhost", this.boundPort((KafkaServer)s), this.listenerName(), this.securityProtocol()), Buffer$.MODULE$.canBuildFrom()));
        this.fetcher_$eq(new ConsumerFetcherManager("consumer1", new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties("", "", "", TestUtils$.MODULE$.createConsumerProperties$default$4())), this.zkUtils()));
        this.fetcher().stopConnections();
        Seq topicInfos = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)x$1 -> new PartitionTopicInfo(this.topic(), 0, this.queue(), new AtomicLong(0L), new AtomicLong(0L), new AtomicInteger(0), ""), Seq$.MODULE$.canBuildFrom());
        this.fetcher().startConnections((Iterable)topicInfos, cluster);
    }

    @Override
    @After
    public void tearDown() {
        this.fetcher().stopConnections();
        super.tearDown();
    }

    @Test
    public void testFetcher() {
        int perNode = 2;
        int count = TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), perNode, TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5()).size();
        this.fetch(count);
        this.assertQueueEmpty();
        count = TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), perNode, TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5()).size();
        this.fetch(count);
        this.assertQueueEmpty();
    }

    public void assertQueueEmpty() {
        Assert.assertEquals((long)0L, (long)this.queue().size());
    }

    public void fetch(int expected) {
        FetchedDataChunk chunk;
        for (int count = 0; count < expected; count += chunk.messages().size()) {
            chunk = this.queue().poll(2L, TimeUnit.SECONDS);
            Assert.assertNotNull((String)("Timed out waiting for data chunk " + (count + 1)), (Object)chunk);
        }
    }

    public FetcherTest() {
        this.numNodes = 1;
        this.topic = "topic";
    }
}

