/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class ConsoleFormatter
extends Formatter {
    private final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String lineSeparator = System.getProperty("line.separator");

    private String ts(Date date) {
        return this.formatter.format(date);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append("[#|");
        sb.append(this.ts(new Date(record.getMillis())));
        sb.append(" | ");
        sb.append(this.formatMessage(record));
        Throwable thrown = record.getThrown();
        if (null != thrown && record.getLevel().intValue() < Level.CONFIG.intValue()) {
            sb.append(lineSeparator);
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            thrown.printStackTrace(new PrintStream(ba, true));
            sb.append(ba.toString());
        }
        sb.append(" |#]");
        sb.append(lineSeparator);
        return sb.toString();
    }
}

