/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.configuration;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.index.Filter;
import org.opensolaris.opengrok.index.IgnoredNames;

public final class Configuration {
    private String ctags;
    private boolean historyCache;
    private int historyCacheTime;
    private boolean historyCacheInDB;
    private List<Project> projects;
    private String sourceRoot;
    private String dataRoot;
    private List<RepositoryInfo> repositories;
    private String urlPrefix;
    private boolean generateHtml;
    private Project defaultProject;
    private double ramBufferSize;
    private boolean verbose;
    private boolean printProgress;
    private boolean allowLeadingWildcard;
    private IgnoredNames ignoredNames;
    private Filter includedNames;
    private String userPage;
    private String userPageSuffix;
    private String bugPage;
    private String bugPattern;
    private String reviewPage;
    private String reviewPattern;
    private String webappLAF;
    private RemoteSCM remoteScmSupported;
    private boolean optimizeDatabase;
    private boolean useLuceneLocking;
    private boolean compressXref;
    private boolean indexVersionedFilesOnly;
    private boolean tagsEnabled;
    private int hitsPerPage;
    private int cachePages;
    private String databaseDriver;
    private String databaseUrl;
    private String CTagsExtraOptionsFile;
    private int scanningDepth;
    private Set<String> allowedSymlinks;
    private boolean obfuscatingEMailAddresses;
    private boolean chattyStatusPage;
    private final Map<String, String> cmds;
    private int tabSize;
    private int command_timeout;
    private static final Logger logger = Logger.getLogger(Configuration.class.getName());
    private boolean noFetchHistoryWhenNoCache;
    public static final double defaultRamBufferSize = 16.0;
    public static final int defaultScanningDepth = 3;
    public static final String EFTAR_DTAGS_FILE = "index/dtags.eftar";
    private transient File dtagsEftar = null;
    private boolean quickContextScan;
    private transient Date lastModified;
    public static final String FOOTER_INCLUDE_FILE = "footer_include";
    private transient String footer = null;
    public static final String HEADER_INCLUDE_FILE = "header_include";
    private transient String header = null;

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getScanningDepth() {
        return this.scanningDepth;
    }

    public void setScanningDepth(int scanningDepth) {
        this.scanningDepth = scanningDepth;
    }

    public int getCommandTimeout() {
        return this.command_timeout;
    }

    public void setCommandTimeout(int timeout) {
        this.command_timeout = timeout;
    }

    public Configuration() {
        this.setHistoryCache(true);
        this.setHistoryCacheTime(30);
        this.setHistoryCacheInDB(false);
        this.setProjects(new ArrayList<Project>());
        this.setRepositories(new ArrayList<RepositoryInfo>());
        this.setUrlPrefix("/source/s?");
        this.setCtags(System.getProperty("org.opensolaris.opengrok.analysis.Ctags", "ctags"));
        this.setRamBufferSize(16.0);
        this.setVerbose(false);
        this.setPrintProgress(false);
        this.setGenerateHtml(true);
        this.setQuickContextScan(true);
        this.setIgnoredNames(new IgnoredNames());
        this.setIncludedNames(new Filter());
        this.setUserPage("http://www.myserver.org/viewProfile.jspa?username=");
        this.setBugPage("http://bugs.myserver.org/bugdatabase/view_bug.do?bug_id=");
        this.setBugPattern("\\b([12456789][0-9]{6})\\b");
        this.setReviewPage("http://arc.myserver.org/caselog/PSARC/");
        this.setReviewPattern("\\b(\\d{4}/\\d{3})\\b");
        this.setWebappLAF("default");
        this.setRemoteScmSupported(RemoteSCM.OFF);
        this.setOptimizeDatabase(true);
        this.setUsingLuceneLocking(false);
        this.setCompressXref(true);
        this.setIndexVersionedFilesOnly(false);
        this.setTagsEnabled(false);
        this.setHitsPerPage(25);
        this.setCachePages(5);
        this.setScanningDepth(3);
        this.setAllowedSymlinks(new HashSet<String>());
        this.cmds = new HashMap<String, String>();
        this.setSourceRoot(null);
        this.setDataRoot(null);
        this.setCommandTimeout(600);
        this.setFetchHistoryWhenNotInCache(true);
    }

    public String getRepoCmd(String clazzName) {
        return this.cmds.get(clazzName);
    }

    public String setRepoCmd(String clazzName, String cmd) {
        if (clazzName == null) {
            return null;
        }
        if (cmd == null || cmd.length() == 0) {
            return this.cmds.remove(clazzName);
        }
        return this.cmds.put(clazzName, cmd);
    }

    public Map<String, String> getCmds() {
        return Collections.unmodifiableMap(this.cmds);
    }

    public void setCmds(Map<String, String> cmds) {
        this.cmds.clear();
        this.cmds.putAll(cmds);
    }

    public String getCtags() {
        return this.ctags;
    }

    public void setCtags(String ctags) {
        this.ctags = ctags;
    }

    public int getCachePages() {
        return this.cachePages;
    }

    public void setCachePages(int cachePages) {
        this.cachePages = cachePages;
    }

    public int getHitsPerPage() {
        return this.hitsPerPage;
    }

    public void setHitsPerPage(int hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
    }

    public boolean isHistoryCache() {
        return this.historyCache;
    }

    public void setHistoryCache(boolean historyCache) {
        this.historyCache = historyCache;
    }

    public int getHistoryCacheTime() {
        return this.historyCacheTime;
    }

    public void setHistoryCacheTime(int historyCacheTime) {
        this.historyCacheTime = historyCacheTime;
    }

    public boolean isFetchHistoryWhenNotInCache() {
        return this.noFetchHistoryWhenNoCache;
    }

    public void setFetchHistoryWhenNotInCache(boolean nofetch) {
        this.noFetchHistoryWhenNoCache = nofetch;
    }

    public boolean isHistoryCacheInDB() {
        return this.historyCacheInDB;
    }

    public void setHistoryCacheInDB(boolean historyCacheInDB) {
        this.historyCacheInDB = historyCacheInDB;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public String getDataRoot() {
        return this.dataRoot;
    }

    public void setDataRoot(String dataRoot) {
        this.dataRoot = dataRoot;
    }

    public List<RepositoryInfo> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<RepositoryInfo> repositories) {
        this.repositories = repositories;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public void setGenerateHtml(boolean generateHtml) {
        this.generateHtml = generateHtml;
    }

    public boolean isGenerateHtml() {
        return this.generateHtml;
    }

    public void setDefaultProject(Project defaultProject) {
        this.defaultProject = defaultProject;
    }

    public Project getDefaultProject() {
        return this.defaultProject;
    }

    public double getRamBufferSize() {
        return this.ramBufferSize;
    }

    public void setRamBufferSize(double ramBufferSize) {
        this.ramBufferSize = ramBufferSize;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isPrintProgress() {
        return this.printProgress;
    }

    public void setPrintProgress(boolean printProgress) {
        this.printProgress = printProgress;
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public boolean isAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public boolean isQuickContextScan() {
        return this.quickContextScan;
    }

    public void setQuickContextScan(boolean quickContextScan) {
        this.quickContextScan = quickContextScan;
    }

    public void setIgnoredNames(IgnoredNames ignoredNames) {
        this.ignoredNames = ignoredNames;
    }

    public IgnoredNames getIgnoredNames() {
        return this.ignoredNames;
    }

    public void setIncludedNames(Filter includedNames) {
        this.includedNames = includedNames;
    }

    public Filter getIncludedNames() {
        return this.includedNames;
    }

    public void setUserPage(String userPage) {
        this.userPage = userPage;
    }

    public String getUserPage() {
        return this.userPage;
    }

    public void setUserPageSuffix(String userPageSuffix) {
        this.userPageSuffix = userPageSuffix;
    }

    public String getUserPageSuffix() {
        return this.userPageSuffix;
    }

    public void setBugPage(String bugPage) {
        this.bugPage = bugPage;
    }

    public String getBugPage() {
        return this.bugPage;
    }

    public void setBugPattern(String bugPattern) {
        this.bugPattern = bugPattern;
    }

    public String getBugPattern() {
        return this.bugPattern;
    }

    public String getReviewPage() {
        return this.reviewPage;
    }

    public void setReviewPage(String reviewPage) {
        this.reviewPage = reviewPage;
    }

    public String getReviewPattern() {
        return this.reviewPattern;
    }

    public void setReviewPattern(String reviewPattern) {
        this.reviewPattern = reviewPattern;
    }

    public String getWebappLAF() {
        return this.webappLAF;
    }

    public void setWebappLAF(String webappLAF) {
        this.webappLAF = webappLAF;
    }

    public RemoteSCM getRemoteScmSupported() {
        return this.remoteScmSupported;
    }

    public void setRemoteScmSupported(RemoteSCM remoteScmSupported) {
        this.remoteScmSupported = remoteScmSupported;
    }

    public boolean isOptimizeDatabase() {
        return this.optimizeDatabase;
    }

    public void setOptimizeDatabase(boolean optimizeDatabase) {
        this.optimizeDatabase = optimizeDatabase;
    }

    public boolean isUsingLuceneLocking() {
        return this.useLuceneLocking;
    }

    public void setUsingLuceneLocking(boolean useLuceneLocking) {
        this.useLuceneLocking = useLuceneLocking;
    }

    public void setCompressXref(boolean compressXref) {
        this.compressXref = compressXref;
    }

    public boolean isCompressXref() {
        return this.compressXref;
    }

    public boolean isIndexVersionedFilesOnly() {
        return this.indexVersionedFilesOnly;
    }

    public void setIndexVersionedFilesOnly(boolean indexVersionedFilesOnly) {
        this.indexVersionedFilesOnly = indexVersionedFilesOnly;
    }

    public boolean isTagsEnabled() {
        return this.tagsEnabled;
    }

    public void setTagsEnabled(boolean tagsEnabled) {
        this.tagsEnabled = tagsEnabled;
    }

    public Date getDateForLastIndexRun() {
        if (this.lastModified == null) {
            File timestamp = new File(this.getDataRoot(), "timestamp");
            this.lastModified = new Date(timestamp.lastModified());
        }
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(File file) {
        if (file == null || !file.canRead()) {
            return "";
        }
        FileReader fin = null;
        BufferedReader input = null;
        try {
            String line;
            fin = new FileReader(file);
            input = new BufferedReader(fin);
            StringBuilder contents = new StringBuilder();
            String EOL = System.getProperty("line.separator");
            while ((line = input.readLine()) != null) {
                contents.append(line).append(EOL);
            }
            String string = contents.toString();
            return string;
        }
        catch (FileNotFoundException line) {
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "failed to read header include file: {0}", e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            } else if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    public String getFooterIncludeFileContent() {
        if (this.footer == null) {
            this.footer = Configuration.getFileContent(new File(this.getDataRoot(), FOOTER_INCLUDE_FILE));
        }
        return this.footer;
    }

    public String getHeaderIncludeFileContent() {
        if (this.header == null) {
            this.header = Configuration.getFileContent(new File(this.getDataRoot(), HEADER_INCLUDE_FILE));
        }
        return this.header;
    }

    public File getDtagsEftar() {
        File tmp;
        if (this.dtagsEftar == null && (tmp = new File(this.getDataRoot() + "/" + EFTAR_DTAGS_FILE)).canRead()) {
            this.dtagsEftar = tmp;
        }
        return this.dtagsEftar;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getCTagsExtraOptionsFile() {
        return this.CTagsExtraOptionsFile;
    }

    public void setCTagsExtraOptionsFile(String filename) {
        this.CTagsExtraOptionsFile = filename;
    }

    public Set<String> getAllowedSymlinks() {
        return this.allowedSymlinks;
    }

    public void setAllowedSymlinks(Set<String> allowedSymlinks) {
        this.allowedSymlinks = allowedSymlinks;
    }

    public boolean isObfuscatingEMailAddresses() {
        return this.obfuscatingEMailAddresses;
    }

    public void setObfuscatingEMailAddresses(boolean obfuscate) {
        this.obfuscatingEMailAddresses = obfuscate;
    }

    public boolean isChattyStatusPage() {
        return this.chattyStatusPage;
    }

    public void setChattyStatusPage(boolean chattyStatusPage) {
        this.chattyStatusPage = chattyStatusPage;
    }

    public void write(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.encodeObject(out);
        }
    }

    public String getXMLRepresentationAsString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.encodeObject(bos);
        return bos.toString();
    }

    private void encodeObject(OutputStream out) {
        try (XMLEncoder e = new XMLEncoder(new BufferedOutputStream(out));){
            e.writeObject(this);
        }
    }

    public static Configuration read(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            Configuration configuration = Configuration.decodeObject(in);
            return configuration;
        }
    }

    public static Configuration makeXMLStringAsConfiguration(String xmlconfig) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlconfig.getBytes());
        Configuration ret = Configuration.decodeObject(in);
        return ret;
    }

    private static Configuration decodeObject(InputStream in) throws IOException {
        Object ret;
        try (XMLDecoder d = new XMLDecoder(new BufferedInputStream(in));){
            ret = d.readObject();
        }
        if (!(ret instanceof Configuration)) {
            throw new IOException("Not a valid config file");
        }
        return (Configuration)ret;
    }

    public static enum RemoteSCM {
        ON,
        OFF,
        DIRBASED,
        UIONLY;

    }
}

