/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class AgentConnection
implements NotificationListener {
    private MBeanServerConnection server = null;
    private final ObjectName objName;
    private static final String objStrName = "OGA:name=AgentIndexRunner,source=timer";
    private static final Logger logger = Logger.getLogger("org.opensolaris.opengrok");
    private String agenturl = "";
    private JMXConnector jmxconn = null;
    private boolean connected = false;
    private ActionListener actionListener = null;
    private boolean listenerRegistered = false;
    private static final long RECONNECT_SLEEPTIME = 5000L;
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private StringBuilder filesInfo = new StringBuilder();
    private static final int FILESINFOMAX = 50000;
    private long starttime = 0L;
    private long endtime = 0L;

    public AgentConnection(String url) throws MalformedURLException, IOException, MalformedObjectNameException {
        this.agenturl = url;
        this.objName = new ObjectName(objStrName);
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (!this.isConnected()) {
            try {
                this.reconnect(1);
            }
            catch (IOException ex) {
                Logger.getLogger(AgentConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.server;
    }

    public String getAgentURL() {
        return this.agenturl;
    }

    public void setActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    public String getFilesInfo() {
        return this.filesInfo.toString();
    }

    public void clearFilesInfo() {
        this.filesInfo = new StringBuilder();
    }

    public long getStartTime() {
        return this.starttime;
    }

    public long getEndTime() {
        return this.endtime;
    }

    void setUrl(String property) {
        this.agenturl = property;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        StringBuilder sb = new StringBuilder();
        sb.append("Notification type: '");
        sb.append(notification.getType());
        sb.append("', seq nr: '");
        sb.append(notification.getSequenceNumber());
        sb.append("', message: '");
        sb.append(notification.getMessage());
        sb.append("', user data: '");
        sb.append(notification.getUserData());
        sb.append("'");
        String notif = "Notification: '" + notification + "'";
        String source = "Notification: source: '" + notification.getSource() + "'";
        if (notification.getType().equals("ogaaction")) {
            if (handback instanceof String) {
                logger.fine(sb.toString());
                logger.finest(notif);
                logger.finest(source);
            } else if (handback instanceof ObjectName) {
                this.handleObjectName(sb, notification, handback);
            }
        } else if (notification.getType().equals("ogainfostring")) {
            if (handback instanceof String) {
                logger.finest(sb.toString());
                logger.finest(notif);
                logger.finest(source);
            } else if (handback instanceof ObjectName) {
                ObjectName pingBean = (ObjectName)handback;
                logger.finest("Received notification from '" + pingBean + "' " + sb.toString());
            }
        } else if (notification.getType().equals("ogainfolong")) {
            if (handback instanceof String) {
                logger.finest(sb.toString());
                logger.finest(notif);
                logger.finest(source);
            } else if (handback instanceof ObjectName) {
                ObjectName pingBean = (ObjectName)handback;
                logger.info("Received notification from '" + pingBean + "' " + sb.toString());
                if ("StartIndexing".equals(notification.getMessage())) {
                    this.starttime = (Long)notification.getUserData();
                } else if ("FinishedIndexing".equals(notification.getMessage())) {
                    this.endtime = (Long)notification.getUserData();
                } else {
                    logger.warning("Unknown message " + notification.getMessage());
                }
            }
        } else {
            logger.info(sb.toString());
            logger.finest(notif);
            logger.finest(source);
        }
    }

    private void handleObjectName(StringBuilder sb, Notification notification, Object handback) {
        ObjectName pingBean = (ObjectName)handback;
        logger.fine("Received notification from '" + pingBean + "' " + sb.toString());
        if (this.filesInfo.length() < 50000) {
            this.filesInfo.append(notification.getUserData().toString());
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "OpenGrok fileevent"));
            }
        }
    }

    public void registerListener() throws IOException, InstanceNotFoundException {
        logger.fine("Registering listener: " + this.getClass().getName() + " for ObjectName: " + this.objName);
        this.server.addNotificationListener(this.objName, this, null, (Object)this.objName);
        logger.fine("Listener Registered");
        this.listenerRegistered = true;
    }

    public void reconnect(int retrytimes) throws MalformedURLException, IOException {
        logger.fine("Doing reconnect on '" + this.agenturl + "'");
        boolean notconnected = true;
        int triednumtimes = 0;
        while (notconnected) {
            ++triednumtimes;
            if (this.jmxconn != null) {
                try {
                    this.jmxconn.close();
                }
                catch (Exception ex) {
                    logger.warning("Exception during close " + ex);
                }
            }
            try {
                this.connect();
                notconnected = false;
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, null, ex);
                throw ex;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                notconnected = true;
                if (triednumtimes <= retrytimes) {
                    logger.info("retry connect did try " + triednumtimes + ", retrying " + retrytimes + " times, waiting " + 5000L + " before next try.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception sleepex) {
                        logger.finest("Thread.sleep exception " + sleepex);
                    }
                    continue;
                }
                throw ex;
            }
        }
    }

    protected void connect() throws MalformedURLException, IOException {
        JMXServiceURL url = new JMXServiceURL(this.agenturl);
        logger.info("jmx url " + url);
        HashMap env = new HashMap();
        this.jmxconn = JMXConnectorFactory.connect(url, env);
        logger.finer("jmx connect ok");
        this.server = this.jmxconn.getMBeanServerConnection();
        logger.info("JMX connection ok");
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void unregister() {
        if (this.server != null && this.objName != null && this.listenerRegistered) {
            try {
                logger.fine("Unregistering listener: " + this.getClass().getName() + " for ObjectName: " + this.objName);
                this.server.removeNotificationListener(this.objName, this, null, (Object)this.objName);
                this.listenerRegistered = false;
            }
            catch (Exception remnlex) {
                logger.severe("Exception unregister notif listener: '" + this.getClass().getName() + "' for ObjectName: " + this.objName + "'");
            }
        }
        try {
            if (this.jmxconn != null) {
                logger.fine("Closing connection");
                this.jmxconn.close();
                this.jmxconn = null;
                this.server = null;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception disconnecting " + e.getMessage(), e);
        }
    }
}

