/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.jrcs.rcs.InvalidVersionNumberException;
import org.apache.commons.jrcs.util.ToString;

public class Version
extends ToString
implements Cloneable,
Comparable {
    private int[] numbers = new int[0];

    public Version(int n) {
        this.numbers = new int[]{n};
    }

    public Version(int n, int n2) {
        this.numbers = new int[]{n, n2};
    }

    public Version(Integer[] integerArray) {
        this.numbers = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            this.numbers[i] = integerArray[i];
        }
    }

    public Version(int[] nArray) {
        this.numbers = (int[])nArray.clone();
    }

    public Version(String string) throws InvalidVersionNumberException {
        if (string.endsWith(".")) {
            string = string + "0";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        this.numbers = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.numbers[i] = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidVersionNumberException(string);
            }
        }
    }

    public Version(Version version) {
        this.numbers = (int[])version.numbers.clone();
        if (!Arrays.equals(this.numbers, version.numbers)) {
            throw new IllegalStateException(this.numbers.toString());
        }
    }

    public Version() {
    }

    public Object clone() {
        return new Version(this);
    }

    public int[] getNumbers() {
        return (int[])this.numbers.clone();
    }

    public int compareVersions(Version version) {
        int n;
        int[] nArray = this.numbers;
        int[] nArray2 = version.numbers;
        for (n = 0; n < nArray.length; ++n) {
            if (n >= nArray2.length || nArray[n] > nArray2[n]) {
                return 1;
            }
            if (nArray[n] >= nArray2[n]) continue;
            return -1;
        }
        if (nArray2.length > n) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof Version)) {
            throw new IllegalArgumentException(object.toString());
        }
        Version version = (Version)object;
        if (this.size() != version.size()) {
            return this.size() - version.size();
        }
        return -this.compareVersions(version);
    }

    public boolean isGreaterThan(Version version) {
        return this.compareVersions(version) > 0;
    }

    public boolean isGreaterOrEqualThan(Version version) {
        return this.compareVersions(version) >= 0;
    }

    public boolean isLessThan(Version version) {
        return this.compareVersions(version) < 0;
    }

    public boolean isLessOrEqualThan(Version version) {
        return this.compareVersions(version) <= 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        return this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int at(int n) {
        return this.numbers[n];
    }

    public int last() {
        return this.at(this.size() - 1);
    }

    public Version getBase(int n) {
        n = n > this.numbers.length ? this.numbers.length : n;
        int[] nArray = new int[n];
        System.arraycopy(this.numbers, 0, nArray, 0, n);
        return new Version(nArray);
    }

    public Version getBranchPoint() {
        return this.getBase(this.size() - 1);
    }

    public Version next() {
        Version version = new Version(this);
        version.numbers[this.numbers.length - 1] = this.last() + 1;
        return version;
    }

    protected void __addBranch(Integer n) {
        this.__addBranch((int)n);
    }

    protected void __addBranch(int n) {
        int[] nArray = new int[this.numbers.length + 1];
        System.arraycopy(this.numbers, 0, nArray, 0, this.numbers.length);
        nArray[this.numbers.length] = n;
        this.numbers = nArray;
    }

    public Version newBranch(int n) {
        int[] nArray = new int[this.numbers.length + 1];
        System.arraycopy(this.numbers, 0, nArray, 0, this.numbers.length);
        nArray[this.numbers.length] = n;
        Version version = new Version();
        version.numbers = nArray;
        return version;
    }

    public int size() {
        return this.numbers.length;
    }

    public boolean isTrunk() {
        return this.size() >= 1 && this.size() <= 2;
    }

    public boolean isBranch() {
        return this.size() > 2;
    }

    public boolean isRevision() {
        return this.even();
    }

    public boolean isGhost() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.numbers[i] > 0) continue;
            return true;
        }
        return false;
    }

    public boolean even(int n) {
        return n % 2 == 0;
    }

    public boolean even() {
        return this.even(this.size());
    }

    public boolean odd(int n) {
        return !this.even(n);
    }

    public boolean odd() {
        return !this.even();
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.size() > 0) {
            stringBuffer.append(Integer.toString(this.numbers[0]));
            for (int i = 1; i < this.numbers.length; ++i) {
                stringBuffer.append(".");
                stringBuffer.append(Integer.toString(this.numbers[i]));
            }
        }
    }
}

