/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRemoteContext {
    private final String myRemoteInterpreterPath;
    @NotNull
    private final String myInterpreterId;
    private final NodeJSRemoteInterpreterManager myManager;
    private final RemoteSdkAdditionalData myRemoteSdkAdditionalData;
    private final PathMappingSettings myMappings;
    private final String myRemoteWorkingDirectory;

    private NodeRemoteContext(@NotNull Project project, @NotNull String interpreterId, @Nullable String localWorkingDirectory, NodeJSRemoteInterpreterManager manager) throws ExecutionException {
        if (project == null) {
            NodeRemoteContext.$$$reportNull$$$0(0);
        }
        if (interpreterId == null) {
            NodeRemoteContext.$$$reportNull$$$0(1);
        }
        this.myInterpreterId = interpreterId;
        this.myManager = manager;
        this.myRemoteSdkAdditionalData = this.myManager.getRemoteSdkAdditionalData(project, interpreterId);
        this.myMappings = this.myManager.setupMappings(project, this.myRemoteSdkAdditionalData);
        this.myRemoteInterpreterPath = this.myRemoteSdkAdditionalData.getInterpreterPath();
        if (localWorkingDirectory != null) {
            String localWorking;
            String path = StringUtil.notNullize((String)localWorkingDirectory);
            String string = localWorking = !FileUtil.isAbsolute((String)path) ? new File(project.getBasePath(), path).getAbsolutePath() : path;
            if (!this.myMappings.canReplaceLocal(localWorking)) {
                throw new ExecutionException("Can not map working directory to remote folder");
            }
            this.myRemoteWorkingDirectory = this.myMappings.convertToRemote(localWorking);
        } else {
            this.myRemoteWorkingDirectory = this.myRemoteSdkAdditionalData.getHelpersPath();
        }
    }

    @Nullable
    public static NodeRemoteContext createContext(@NotNull Project project, @NotNull String interpreterId, @Nullable String localWorkingDirectory, @NotNull NoPluginReaction reaction) throws ExecutionException {
        if (project == null) {
            NodeRemoteContext.$$$reportNull$$$0(2);
        }
        if (interpreterId == null) {
            NodeRemoteContext.$$$reportNull$$$0(3);
        }
        if (reaction == null) {
            NodeRemoteContext.$$$reportNull$$$0(4);
        }
        if (!NodeRemoteContext.isRemote(interpreterId)) {
            return null;
        }
        NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
        if (manager == null) {
            if (NoPluginReaction.message.equals((Object)reaction)) {
                NodeUIUtil.balloonInfo((Project)project, (String)NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage(), null, (MessageType)MessageType.ERROR);
            }
            if (NoPluginReaction.exception.equals((Object)reaction)) {
                throw new ExecutionException(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
            }
            return null;
        }
        return new NodeRemoteContext(project, interpreterId, localWorkingDirectory, manager);
    }

    private static boolean isRemote(@NotNull String path) {
        if (path == null) {
            NodeRemoteContext.$$$reportNull$$$0(5);
        }
        return (path = path.replace('\\', '/')).startsWith("vagrant://") || path.startsWith("sftp://") || path.startsWith("docker://") || path.startsWith("ssh://");
    }

    public NodeJSRemoteInterpreterManager getManager() {
        return this.myManager;
    }

    public RemoteSdkAdditionalData getRemoteSdkAdditionalData() {
        return this.myRemoteSdkAdditionalData;
    }

    public String getRemoteWorkingDirectory() {
        return this.myRemoteWorkingDirectory;
    }

    public String getRemoteInterpreterPath() {
        return this.myRemoteInterpreterPath;
    }

    @NotNull
    public String getInterpreterId() {
        String string = this.myInterpreterId;
        if (string == null) {
            NodeRemoteContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            NodeRemoteContext.$$$reportNull$$$0(7);
        }
        if (!this.myMappings.canReplaceLocal(localPath)) {
            throw new ExecutionException("Can not find mapping for " + localPath);
        }
        return this.myMappings.convertToRemote(localPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reaction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/execution/NodeRemoteContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/execution/NodeRemoteContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRemote";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NoPluginReaction {
        exception,
        message,
        ignore;

    }
}

