/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNode;
import com.jetbrains.nodejs.run.profile.cpu.view.FilteredByPercent;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import java.util.ArrayList;
import java.util.List;

public class V8DiffFlatViewTableModel
extends ChainTreeTableModel
implements FilteredByPercent {
    private Integer myFilterLevel;
    private final int myChangedNumTicks;
    private final int myBaseNumTicks;

    public V8DiffFlatViewTableModel(ColumnInfo[] columns, int baseNumTicks, int changedNumTicks) {
        super(columns);
        this.myChangedNumTicks = changedNumTicks;
        this.myBaseNumTicks = baseNumTicks;
    }

    @Override
    public boolean isFiltered() {
        return this.myFilterLevel != null;
    }

    @Override
    public int getTensPercentLevelInclusive() {
        return this.myFilterLevel == null ? 0 : this.myFilterLevel;
    }

    @Override
    public void clearFilter() {
        this.myFilterLevel = null;
    }

    @Override
    public void filterByLevel(int tensPercentLevelInclusive) {
        this.myFilterLevel = tensPercentLevelInclusive;
    }

    @Override
    protected List<ChainTreeTableModel.Node<?>> filter(List<ChainTreeTableModel.Node<?>> children) {
        if (this.myFilterLevel == null) {
            return children;
        }
        ArrayList result = new ArrayList();
        for (ChainTreeTableModel.Node<?> child : children) {
            Object object = child.getT();
            if (object instanceof DiffNode) {
                int tens;
                DiffNode node = (DiffNode)object;
                if (node.getAfter() != null && node.getBefore() == null) {
                    tens = V8Utils.tensPercent(node.getAfter().getTotal(), this.myChangedNumTicks);
                    if (tens < this.myFilterLevel) continue;
                    result.add(child);
                    continue;
                }
                if (node.getBefore() != null && node.getAfter() == null) {
                    tens = V8Utils.tensPercent(node.getBefore().getTotal(), this.myBaseNumTicks);
                    if (tens < this.myFilterLevel) continue;
                    result.add(child);
                    continue;
                }
                int base = V8Utils.tensPercent(node.getAfter().getTotal(), this.myChangedNumTicks);
                int changed = V8Utils.tensPercent(node.getBefore().getTotal(), this.myBaseNumTicks);
                if (changed - base < this.myFilterLevel && base - changed < this.myFilterLevel) continue;
                result.add(child);
                continue;
            }
            result.add(child);
        }
        return result;
    }
}

