/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.completion.autoImport.PhpAutoImportConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNameIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.util.PhpContractUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCodeInsightUtil {
    public static final Object[][] STD_LIB_FUN_WITH_REF_ARGS = new Object[][]{{"apc_dec", 2}, {"apc_fetch", 1}, {"apc_inc", 2}, {"apcu_dec", 2}, {"apcu_fetch", 1}, {"apcu_inc", 2}, {"array_multisort", 0}, {"array_pop", 0}, {"array_push", 0}, {"array_shift", 0}, {"array_splice", 0}, {"array_unshift", 0}, {"array_walk", 0}, {"array_walk_recursive", 0}, {"arsort", 0}, {"asort", 0}, {"call_user_method", 1}, {"call_user_method_array", 1}, {"collator_asort", 1}, {"collator_sort", 1}, {"collator_sort_with_sort_keys", 1}, {"curl_multi_exec", 1}, {"curl_multi_info_read", 1}, {"datefmt_localtime", 2}, {"datefmt_parse", 2}, {"dns_get_mx", 1}, {"dns_get_mx", 2}, {"dns_get_record", 2}, {"dns_get_record", 3}, {"dns_get_record", 4}, {"each", 0}, {"enchant_dict_quick_check", 2}, {"end", 0}, {"ereg", 2}, {"eregi", 2}, {"exec", 1}, {"exec", 2}, {"exif_thumbnail", 1}, {"exif_thumbnail", 2}, {"exif_thumbnail", 3}, {"flock", 2}, {"fscanf", 2}, {"fsockopen", 2}, {"fsockopen", 3}, {"ftp_alloc", 2}, {"getimagesize", 1}, {"getimagesizefromstring", 1}, {"getmxrr", 1}, {"getmxrr", 2}, {"getopt", 2}, {"gmp_clrbit", 0}, {"gmp_setbit", 0}, {"grapheme_extract", 4}, {"headers_sent", 0}, {"headers_sent", 1}, {"http_build_url", 3}, {"http_get", 2}, {"http_head", 2}, {"http_negotiate_charset", 1}, {"http_negotiate_content_type", 1}, {"http_negotiate_language", 1}, {"http_post_data", 3}, {"http_post_fields", 4}, {"http_put_data", 3}, {"http_put_file", 3}, {"http_put_stream", 3}, {"http_request", 4}, {"idn_to_ascii", 3}, {"idn_to_utf8", 3}, {"intltz_get_canonical_id", 1}, {"intltz_get_offset", 3}, {"intltz_get_offset", 4}, {"is_callable", 2}, {"krsort", 0}, {"ksort", 0}, {"ldap_control_paged_result_response", 2}, {"ldap_control_paged_result_response", 3}, {"ldap_get_option", 2}, {"ldap_parse_reference", 2}, {"ldap_parse_result", 2}, {"ldap_parse_result", 3}, {"ldap_parse_result", 4}, {"ldap_parse_result", 5}, {"mb_convert_variables", 2}, {"mb_parse_str", 1}, {"mbereg", 2}, {"mberegi", 2}, {"mqseries_back", 1}, {"mqseries_back", 2}, {"mqseries_begin", 2}, {"mqseries_begin", 3}, {"mqseries_close", 3}, {"mqseries_close", 4}, {"mqseries_cmit", 1}, {"mqseries_cmit", 2}, {"mqseries_conn", 1}, {"mqseries_conn", 2}, {"mqseries_conn", 3}, {"mqseries_connx", 1}, {"mqseries_connx", 2}, {"mqseries_connx", 3}, {"mqseries_connx", 4}, {"mqseries_disc", 1}, {"mqseries_disc", 2}, {"mqseries_get", 2}, {"mqseries_get", 3}, {"mqseries_get", 4}, {"mqseries_get", 5}, {"mqseries_get", 6}, {"mqseries_get", 7}, {"mqseries_get", 8}, {"mqseries_inq", 5}, {"mqseries_inq", 7}, {"mqseries_inq", 8}, {"mqseries_inq", 9}, {"mqseries_open", 1}, {"mqseries_open", 3}, {"mqseries_open", 4}, {"mqseries_open", 5}, {"mqseries_put", 2}, {"mqseries_put", 3}, {"mqseries_put", 5}, {"mqseries_put", 6}, {"mqseries_put1", 1}, {"mqseries_put1", 2}, {"mqseries_put1", 3}, {"mqseries_put1", 5}, {"mqseries_put1", 6}, {"mqseries_set", 8}, {"mqseries_set", 9}, {"msg_receive", 2}, {"msg_receive", 4}, {"msg_receive", 7}, {"msg_send", 5}, {"mssql_bind", 2}, {"mysqli_bind_result", 2}, {"mysqli_poll", 0}, {"mysqli_poll", 1}, {"mysqli_poll", 2}, {"mysqli_stmt_bind_param", 2}, {"mysqli_stmt_bind_param", 3}, {"mysqli_stmt_bind_result", 1}, {"mysqli_stmt_bind_result", 2}, {"natcasesort", 0}, {"natsort", 0}, {"ncurses_color_content", 1}, {"ncurses_color_content", 2}, {"ncurses_color_content", 3}, {"ncurses_getmaxyx", 1}, {"ncurses_getmaxyx", 2}, {"ncurses_getmouse", 0}, {"ncurses_getyx", 1}, {"ncurses_getyx", 2}, {"ncurses_instr", 0}, {"ncurses_mouse_trafo", 0}, {"ncurses_mouse_trafo", 1}, {"ncurses_mousemask", 1}, {"ncurses_pair_content", 1}, {"ncurses_pair_content", 2}, {"ncurses_wmouse_trafo", 1}, {"ncurses_wmouse_trafo", 2}, {"next", 0}, {"numfmt_parse", 3}, {"numfmt_parse_currency", 2}, {"numfmt_parse_currency", 3}, {"oci_bind_array_by_name", 2}, {"oci_bind_by_name", 2}, {"oci_define_by_name", 2}, {"oci_fetch_all", 1}, {"ocibindbyname", 2}, {"ocidefinebyname", 2}, {"ocifetchinto", 1}, {"ocifetchstatement", 1}, {"odbc_fetch_into", 1}, {"openssl_csr_export", 1}, {"openssl_csr_new", 1}, {"openssl_encrypt", 5}, {"openssl_open", 1}, {"openssl_pkcs12_export", 1}, {"openssl_pkcs12_read", 1}, {"openssl_pkcs7_read", 1}, {"openssl_pkey_export", 1}, {"openssl_private_decrypt", 1}, {"openssl_private_encrypt", 1}, {"openssl_public_decrypt", 1}, {"openssl_public_encrypt", 1}, {"openssl_random_pseudo_bytes", 1}, {"openssl_seal", 1}, {"openssl_seal", 2}, {"openssl_sign", 1}, {"openssl_spki_export", 0}, {"openssl_spki_export_challenge", 0}, {"openssl_spki_new", 0}, {"openssl_spki_new", 1}, {"openssl_spki_verify", 0}, {"openssl_x509_export", 1}, {"parse_str", 1}, {"passthru", 1}, {"pcntl_sigprocmask", 2}, {"pcntl_sigtimedwait", 1}, {"pcntl_sigwaitinfo", 1}, {"pcntl_wait", 0}, {"pcntl_waitpid", 1}, {"pfsockopen", 2}, {"pfsockopen", 3}, {"pos", 0}, {"preg_filter", 4}, {"preg_match", 2}, {"preg_match_all", 2}, {"preg_replace", 4}, {"preg_replace_callback", 4}, {"preg_replace_callback_array", 3}, {"prev", 0}, {"proc_open", 2}, {"reset", 0}, {"rsort", 0}, {"settype", 0}, {"shuffle", 0}, {"similar_text", 2}, {"socket_create_pair", 3}, {"socket_getpeername", 1}, {"socket_getpeername", 2}, {"socket_getsockname", 1}, {"socket_getsockname", 2}, {"socket_recv", 1}, {"socket_recvfrom", 1}, {"socket_recvfrom", 4}, {"socket_recvfrom", 5}, {"socket_select", 0}, {"socket_select", 1}, {"socket_select", 2}, {"sodium_add", 0}, {"sodium_crypto_generichash_update", 0}, {"sodium_increment", 0}, {"sodium_memzero", 0}, {"sort", 0}, {"sqlite_exec", 2}, {"sqlite_factory", 2}, {"sqlite_open", 2}, {"sqlite_popen", 2}, {"sqlite_query", 3}, {"sqlite_unbuffered_query", 3}, {"sscanf", 2}, {"ssh2_poll", 0}, {"str_ireplace", 3}, {"str_replace", 3}, {"stream_select", 0}, {"stream_select", 1}, {"stream_select", 2}, {"stream_socket_accept", 2}, {"stream_socket_client", 1}, {"stream_socket_client", 2}, {"stream_socket_recvfrom", 3}, {"stream_socket_server", 1}, {"stream_socket_server", 2}, {"system", 1}, {"uasort", 0}, {"uksort", 0}, {"usort", 0}, {"wincache_ucache_dec", 2}, {"wincache_ucache_get", 1}, {"wincache_ucache_inc", 2}, {"xml_parse_into_struct", 2}, {"xml_parse_into_struct", 3}, {"xml_set_object", 1}, {"xmlrpc_decode_request", 1}, {"xmlrpc_set_type", 0}, {"yaml_parse", 2}, {"yaml_parse_file", 2}, {"yaml_parse_url", 2}};
    private static final Condition<PsiElement> USE_OPERATOR_SCOPES_CONDITION = element -> element instanceof PhpFile || element instanceof PhpNamespace;
    public static final Condition<PsiElement> LOOP_STATEMENTS = element -> element instanceof PhpSwitch || element instanceof For || element instanceof While || element instanceof DoWhile || element instanceof ForeachStatement;
    public static final TokenSet tsASSOCIATIVE_OPS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opCONCAT});

    private PhpCodeInsightUtil() {
    }

    @Nullable
    public static Integer toInt(@NotNull PsiElement element) {
        ASTNode elementNode;
        IElementType elementType;
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(0);
        }
        if (PhpElementTypes.NUMBER.equals(elementType = (elementNode = element.getNode()).getElementType())) {
            ASTNode childNode = elementNode.getFirstChildNode();
            if (childNode == null) {
                return null;
            }
            IElementType childNodeType = childNode.getElementType();
            if (PhpTokenTypes.tsINTEGERS.contains(childNodeType)) {
                try {
                    return Integer.parseInt(childNode.getText());
                }
                catch (NumberFormatException exception) {
                    return null;
                }
            }
            if (PhpTokenTypes.FLOAT_LITERAL.equals(childNodeType)) {
                try {
                    return (int)Float.parseFloat(childNode.getText());
                }
                catch (NumberFormatException exception) {
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static String toString(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(1);
        }
        if (stringLiteralExpression.getChildren().length == 0) {
            return StringUtil.unquoteString((String)stringLiteralExpression.getText());
        }
        return null;
    }

    @Nullable
    public static String toString(@NotNull PsiElement element) {
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(2);
        }
        return PhpCodeInsightUtil.toString(element, true);
    }

    @Nullable
    public static String toString(@NotNull PsiElement element, boolean allowCasting) {
        ASTNode elementNode;
        IElementType elementType;
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(3);
        }
        if ((elementType = (elementNode = element.getNode()).getElementType()) == PhpElementTypes.STRING) {
            if (element instanceof StringLiteralExpression) {
                return PhpCodeInsightUtil.toString((StringLiteralExpression)element);
            }
        } else if (allowCasting && elementType == PhpElementTypes.NUMBER) {
            return element.getText();
        }
        return null;
    }

    @Nullable
    public static String getKey(@NotNull ArrayIndex arrayIndex) {
        PhpPsiElement value;
        if (arrayIndex == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(4);
        }
        if ((value = arrayIndex.getValue()) != null) {
            return value instanceof ConstantReference ? ((ConstantReference)value).getName() : PhpCodeInsightUtil.toString((PsiElement)value);
        }
        return null;
    }

    public static boolean isEmptyBody(@NotNull Function function) {
        GroupStatement child;
        if (function == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(5);
        }
        if ((child = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)function, GroupStatement.class)) != null) {
            PsiElement[] children;
            for (PsiElement psiElement : children = child.getChildren()) {
                if (!(psiElement instanceof PhpPsiElement) || psiElement instanceof PhpDocPsiElement) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNull(@Nullable PsiElement value) {
        String name;
        return value instanceof ConstantReference && (name = ((ConstantReference)value).getName()) != null && PhpLangUtil.equalsIgnoreCase("null", name);
    }

    public static boolean isResultUsed(@NotNull PsiElement element) {
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(6);
        }
        PsiElement parent = element.getParent();
        IElementType parentNodeType = parent.getNode().getElementType();
        if (parent instanceof PhpUse) {
            return false;
        }
        if (parent instanceof Statement && parentNodeType == PhpElementTypes.STATEMENT) {
            return false;
        }
        if (parent instanceof For) {
            return ArrayUtil.contains((Object)element, (Object[])((For)parent).getConditionalExpressions());
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentNodeType)) {
            return false;
        }
        if (parent instanceof UnaryExpression && PhpCodeInsightUtil.isSilenceExpression((UnaryExpression)parent)) {
            return PhpCodeInsightUtil.isResultUsed(parent);
        }
        if (parent instanceof TernaryExpression && element != ((TernaryExpression)parent).getCondition()) {
            return PhpCodeInsightUtil.isResultUsed(parent);
        }
        return true;
    }

    public static boolean isIncrementOrDecrementExpression(@NotNull UnaryExpression expression) {
        if (expression == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(7);
        }
        return PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_WRITE_EXPRESSION, PhpElementTypes.POSTFIX_EXPRESSION);
    }

    public static boolean isSilenceExpression(@NotNull UnaryExpression expression) {
        if (expression == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(8);
        }
        return PhpPsiUtil.isOfType(expression.getOperation(), PhpTokenTypes.opSILENCE);
    }

    public static boolean isForeachKeyOrValueAssignedByReference(@NotNull PhpReference key) {
        PsiElement prevSibling;
        if (key == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(9);
        }
        return (prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)key, true)) != null && PhpTokenTypes.opBIT_AND == prevSibling.getNode().getElementType();
    }

    public static boolean hasMagicMethod(@NotNull PhpType type, @NotNull PhpIndex index, @Nullable String magicName) {
        if (type == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(10);
        }
        if (index == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(11);
        }
        if (magicName == null) {
            return false;
        }
        for (String fqn : type.getTypes()) {
            Collection classes = index.getAnyByFQN(fqn);
            for (PhpClass aClass : classes) {
                PhpClass containingClass;
                Method method = aClass.findMethodByName((CharSequence)magicName);
                if (method == null || (containingClass = method.getContainingClass()) == null || PhpLangUtil.isObject(containingClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isScopeForUseOperator(@NotNull PhpPsiElement element) {
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(12);
        }
        return USE_OPERATOR_SCOPES_CONDITION.value((Object)element);
    }

    @Nullable
    public static PhpPsiElement findScopeForUseOperator(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(13);
        }
        return (PhpPsiElement)PhpPsiUtil.getParentByCondition(psiElement, false, USE_OPERATOR_SCOPES_CONDITION);
    }

    public static boolean hasQualifier(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(14);
        }
        return PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF) != null || PhpPsiUtil.isOfType(reference.getFirstChild(), PhpTokenTypes.kwNAMESPACE);
    }

    public static boolean hasQualifier(@NotNull String name) {
        if (name == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(15);
        }
        return name.contains("\\");
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, boolean useCurrentNamespace, boolean allowClassAliases) {
        String namespaceFqn;
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(16);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(17);
        }
        PhpContractUtil.assertFqn(fqn);
        if (PhpType.isPrimitiveType((String)fqn)) {
            String string = PhpLangUtil.toPresentableFQN(fqn);
            if (string == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (PhpCodeInsightUtil.isSameNamespace(scopeForUseOperator, fqn)) {
            String shortName = PhpLangUtil.toShortName(fqn);
            if (PhpCodeInsightUtil.isAliasUsed(scopeForUseOperator, shortName)) {
                String string = fqn;
                if (string == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(19);
                }
                return string;
            }
            String string = shortName;
            if (string == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(20);
            }
            return string;
        }
        String qualifiedName = fqn;
        if (useCurrentNamespace && scopeForUseOperator instanceof PhpNamespace && PhpLangUtil.isFqn(namespaceFqn = ((PhpNamespace)scopeForUseOperator).getFQN()) && !PhpLangUtil.isGlobalNamespaceFQN(namespaceFqn)) {
            String prefix = namespaceFqn + "\\";
            qualifiedName = StringUtil.trimStart((String)fqn, (String)prefix);
        }
        List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
        for (PhpUseList anImport : imports) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = anImport.getDeclarations()) {
                String name = PhpCodeInsightUtil.createQualifiedName(fqn, declaration.getFQN(), declaration.getAliasName(), allowClassAliases);
                if (name == null || PhpCodeInsightUtil.hasQualifier(name) && name.length() >= qualifiedName.length()) continue;
                qualifiedName = name;
            }
        }
        String string = qualifiedName;
        if (string == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static boolean isAliasUsed(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String name) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(22);
        }
        if (name == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(23);
        }
        List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
        for (PhpUseList anImport : imports) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = anImport.getDeclarations()) {
                if (!PhpLangUtil.equalsClassNames(declaration.getName(), name)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(24);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(25);
        }
        String string = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, true, true);
        if (string == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, @Nullable PhpReference nameHolder, boolean useCurrentNamespace) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(27);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(28);
        }
        String string = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, nameHolder, useCurrentNamespace, true);
        if (string == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, @Nullable PhpReference nameHolder, boolean useCurrentNamespace, boolean allowClassAliases) {
        PsiElement parent;
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(30);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(31);
        }
        if (nameHolder != null && (parent = nameHolder.getParent()) instanceof PhpUse && !((PhpUse)parent).isTraitImport()) {
            String string = StringUtil.trimStart((String)fqn, (String)"\\");
            if (string == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, useCurrentNamespace, allowClassAliases);
        if (string == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public static String createQualifiedName(@NotNull String fqn, @NotNull String importedFqn, @Nullable String alias, boolean allowClassAliases) {
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(34);
        }
        if (importedFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(35);
        }
        PhpContractUtil.assertFqn(fqn);
        PhpContractUtil.assertFqn(importedFqn);
        PhpContractUtil.assertNoQualifier(alias);
        if (PhpLangUtil.equalsClassNames(StringUtil.trimEnd((String)fqn, (String)"[]"), importedFqn)) {
            if (!allowClassAliases && alias != null) {
                return null;
            }
            return alias != null ? (PhpType.isPluralType((String)fqn) ? alias + "[]" : alias) : PhpLangUtil.toShortName(fqn);
        }
        String parentNamespaceFQN = PhpLangUtil.getParentNamespaceFQN(fqn);
        if (PhpCodeInsightUtil.isAliassed(importedFqn, parentNamespaceFQN)) {
            if (alias != null) {
                return alias + StringUtil.trimStart((String)fqn, (String)importedFqn);
            }
            String qualifiedName = StringUtil.trimStart((String)fqn, (String)PhpLangUtil.getParentNamespaceFQN(importedFqn));
            return StringUtil.trimStart((String)qualifiedName, (String)"\\");
        }
        return null;
    }

    private static boolean isAliassed(@NotNull String importedFqn, @NotNull String parentNamespaceFQN) {
        if (importedFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(36);
        }
        if (parentNamespaceFQN == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(37);
        }
        if (!StringUtil.startsWith((CharSequence)parentNamespaceFQN, (CharSequence)importedFqn)) {
            return false;
        }
        return parentNamespaceFQN.length() == importedFqn.length() || parentNamespaceFQN.charAt(importedFqn.length()) == "\\".charAt(0);
    }

    @NotNull
    public static List<PhpUseList> collectImports(@NotNull PhpPsiElement scopeForUseOperator) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(38);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)scopeForUseOperator, () -> {
            if (scopeForUseOperator == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(122);
            }
            List out = Collections.emptyList();
            GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)scopeForUseOperator, GroupStatement.class);
            if (groupStatement != null) {
                List scopeChildren;
                List children = PhpPsiUtil.getChildren((PsiElement)groupStatement, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
                if (!children.isEmpty()) {
                    out = children;
                }
                if (scopeForUseOperator.getChildren().length > 1 && !(scopeChildren = PhpPsiUtil.getChildren((PsiElement)scopeForUseOperator, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)).isEmpty()) {
                    out = scopeChildren;
                }
            }
            return CachedValueProvider.Result.create(out, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static List<PhpNamespace> collectNamespaces(@NotNull PsiFile phpFile) {
        List<PhpNamespace> children;
        GroupStatement groupStatement;
        if (phpFile == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(40);
        }
        if ((groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)phpFile, GroupStatement.class)) != null && !(children = PhpPsiUtil.getChildren((PsiElement)groupStatement, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)).isEmpty()) {
            List<PhpNamespace> list = children;
            if (list == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(41);
            }
            return list;
        }
        List<PhpNamespace> list = Collections.emptyList();
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(42);
        }
        return list;
    }

    public static boolean isSameNamespace(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(43);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(44);
        }
        PhpContractUtil.assertFqn(fqn);
        String parentNamespace = PhpLangUtil.getParentQualifiedName(fqn);
        if (scopeForUseOperator instanceof PhpFile) {
            return StringUtil.isEmpty((String)parentNamespace);
        }
        if (scopeForUseOperator instanceof PhpNamespace) {
            return PhpLangUtil.equalsClassNames(PhpLangUtil.toFQN(parentNamespace), ((PhpNamespace)scopeForUseOperator).getFQN());
        }
        return false;
    }

    public static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull PhpNamedElement element) {
        ImportElementType type;
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(45);
        }
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(46);
        }
        return (type = ImportElementType.fromElement((PsiElement)element)) != null && PhpCodeInsightUtil.hasNameConflicts(scope, element.getFQN(), type);
    }

    public static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull String elementFqn, @NotNull ImportElementType elementType) {
        PsiFile file;
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(47);
        }
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(48);
        }
        if (elementType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(49);
        }
        if ((file = scope.getContainingFile()) instanceof PhpFile) {
            String elementName = PhpLangUtil.toShortName(elementFqn);
            String elementNamespace = PhpLangUtil.getParentNamespaceFQN(elementFqn);
            String scopeNamespace = PhpLangUtil.concat(scope instanceof PhpNamespace ? ((PhpNamespace)scope).getFQN() : "", "\\");
            if (PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, (PhpFile)file, elementName, scopeNamespace)) {
                return true;
            }
            if ((elementType == ImportElementType.FUNCTION || elementType == ImportElementType.CONSTANT) && !PhpLangUtil.isGlobalNamespaceFQN(elementNamespace) && PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, (PhpFile)file, elementName, "\\")) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull String elementFqn, @NotNull ImportElementType elementType, @NotNull PhpFile file, @NotNull String elementName, @NotNull String scopeNamespace) {
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(50);
        }
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(51);
        }
        if (elementType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(52);
        }
        if (file == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(53);
        }
        if (elementName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(54);
        }
        if (scopeNamespace == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(55);
        }
        for (PhpNamedElement def : file.getTopLevelDefs().values()) {
            if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, def)) continue;
            return true;
        }
        switch (elementType) {
            case CLASS: {
                for (PhpClass phpClass : PhpIndex.getInstance((Project)scope.getProject()).getClassesByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)phpClass)) continue;
                    return true;
                }
                for (PhpClass phpClass : PhpIndex.getInstance((Project)scope.getProject()).getInterfacesByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)phpClass)) continue;
                    return true;
                }
                for (PhpClass phpClass : PhpIndex.getInstance((Project)scope.getProject()).getTraitsByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)phpClass)) continue;
                    return true;
                }
                break;
            }
            case NAMESPACE: {
                break;
            }
            case FUNCTION: {
                for (Function function : PhpIndex.getInstance((Project)scope.getProject()).getFunctionsByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)function)) continue;
                    return true;
                }
                break;
            }
            case CONSTANT: {
                for (Constant constant : PhpIndex.getInstance((Project)scope.getProject()).getConstantsByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)constant)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull String elementFqn, @NotNull ImportElementType elementType, @NotNull String elementName, @NotNull String scopeNamespace, @NotNull PhpNamedElement def) {
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(56);
        }
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(57);
        }
        if (elementType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(58);
        }
        if (elementName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(59);
        }
        if (scopeNamespace == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(60);
        }
        if (def == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(61);
        }
        if (PhpLangUtil.equalsNamespaceNames(scopeNamespace, def.getNamespaceName())) {
            String defName = def.getName();
            String defFqn = def.getFQN();
            if (def instanceof PhpUse ? PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)def) == scope && (PhpUseImpl.isOfConst((PhpUse)def) ? elementType == ImportElementType.CONSTANT && PhpLangUtil.equalsConstantNames(elementName, defName) && !PhpCodeInsightUtil.equalConstantFqns(elementFqn, defFqn) : (PhpUseImpl.isOfFunction((PhpUse)def) ? elementType == ImportElementType.FUNCTION && PhpLangUtil.equalsIgnoreCase(elementName, defName) && !PhpLangUtil.equalsIgnoreCase(elementFqn, defFqn) : PhpLangUtil.equalsIgnoreCase(elementName, defName) && !PhpLangUtil.equalsIgnoreCase(elementFqn, defFqn))) : (def instanceof PhpClass ? elementType == ImportElementType.CLASS && PhpLangUtil.equalsClassNames(elementName, defName) : (def instanceof PhpNamespace ? elementType == ImportElementType.NAMESPACE && PhpLangUtil.equalsNamespaceNames(elementName, defName) : (def instanceof Function ? elementType == ImportElementType.FUNCTION && PhpLangUtil.equalsFunctionNames(elementName, defName) : def instanceof Constant && elementType == ImportElementType.CONSTANT && PhpLangUtil.equalsConstantNames(elementName, defName))))) {
                return true;
            }
        }
        return false;
    }

    private static boolean equalConstantFqns(@NotNull String elementFqn, @NotNull String defFqn) {
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(62);
        }
        if (defFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(63);
        }
        return PhpLangUtil.equalsConstantNames(PhpLangUtil.toShortName(elementFqn), PhpLangUtil.toShortName(defFqn)) && PhpLangUtil.equalsNamespaceNames(PhpLangUtil.getParentNamespaceFQN(elementFqn), PhpLangUtil.getParentNamespaceFQN(defFqn));
    }

    @Contract(value="null -> false")
    public static boolean isAutoImportEnabled(@Nullable PhpPsiElement scopeForUseOperator) {
        PhpAutoImportConfiguration.State configuration = PhpAutoImportConfiguration.getInstance().getState();
        return scopeForUseOperator instanceof PhpNamespace && configuration.isAutoImportInNamespaceScope() || scopeForUseOperator instanceof PhpFile && configuration.isAutoImportInFileScope();
    }

    public static boolean canImport(@NotNull PhpPsiElement scopeForUseOperator, final @NotNull String fqn) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(64);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(65);
        }
        PhpContractUtil.assertFqn(fqn);
        final String className = PhpLangUtil.toShortName(fqn);
        final Ref isNameAvailable = new Ref((Object)true);
        scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpUse(PhpUse use) {
                if (PhpLangUtil.equalsClassNames(className, use.getName()) && !fqn.equals(use.getFQN())) {
                    isNameAvailable.set((Object)false);
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                if (PhpLangUtil.equalsClassNames(className, clazz.getName())) {
                    isNameAvailable.set((Object)false);
                }
            }

            public void visitElement(PsiElement element) {
                if (((Boolean)isNameAvailable.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }
        });
        return (Boolean)isNameAvailable.get();
    }

    @Nullable
    public static String alreadyImported(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(66);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(67);
        }
        if (PhpCodeInsightUtil.isSameNamespace(scopeHolder, fqn)) {
            return PhpLangUtil.toShortName(fqn);
        }
        PhpUse declaration = (PhpUse)ContainerUtil.getFirstItem(PhpCodeInsightUtil.findDeclarations(scopeHolder, fqn));
        if (declaration != null) {
            String aliasName = declaration.getAliasName();
            return aliasName == null ? declaration.getName() : aliasName;
        }
        return null;
    }

    @NotNull
    public static Collection<PhpUse> findDeclarations(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(68);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(69);
        }
        List<PhpUseList> lists = PhpCodeInsightUtil.collectImports(scopeHolder);
        List result = ContainerUtil.newSmartList();
        for (PhpUseList list : lists) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = list.getDeclarations()) {
                PhpReference reference = declaration.getTargetReference();
                if (reference == null || !PhpLangUtil.equalsClassNames(reference.getFQN(), fqn)) continue;
                result.add(declaration);
            }
        }
        List list = result;
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(70);
        }
        return list;
    }

    public static boolean isFullyQualified(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(71);
        }
        return reference.getText().startsWith("\\");
    }

    public static boolean isNotInImport(@NotNull PhpReference reference) {
        PsiElement parent;
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(72);
        }
        if ((parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)reference)) instanceof PhpUse) {
            return ((PhpUse)parent).isTraitImport();
        }
        return true;
    }

    public static boolean isImportSupported(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(73);
        }
        return PhpCodeInsightUtil.isNotInImport(reference);
    }

    @NotNull
    public static PhpAccessInstruction.Access getAccess(@NotNull PhpPsiElement anchor) {
        PsiElement variableParent;
        if (anchor == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(74);
        }
        if ((variableParent = anchor.getParent()) instanceof MultiassignmentExpression) {
            if (((MultiassignmentExpression)variableParent).getValue() != anchor) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(75);
                }
                return access;
            }
            PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
            if (access == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(76);
            }
            return access;
        }
        if (variableParent instanceof SelfAssignmentExpression) {
            if (anchor == ((SelfAssignmentExpression)variableParent).getVariable()) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(77);
                }
                return access;
            }
            PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
            if (access == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(78);
            }
            return access;
        }
        if (variableParent instanceof AssignmentExpression) {
            boolean assignByReference = PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)variableParent);
            if (((AssignmentExpression)variableParent).getVariable() == anchor) {
                PhpAccessInstruction.Access access = assignByReference ? PhpAccessInstruction.Access.WRITE_REF_ACCESS : PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(79);
                }
                return access;
            }
            PhpAccessInstruction.Access access = assignByReference ? PhpAccessInstruction.Access.READ_REF_ACCESS : PhpAccessInstruction.Access.READ_ACCESS;
            if (access == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(80);
            }
            return access;
        }
        if (variableParent instanceof ForeachStatement) {
            PsiElement prevSibling;
            ForeachStatement foreach = (ForeachStatement)variableParent;
            if ((foreach.getKey() == anchor || foreach.getValue() == anchor) && (prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)anchor, true)) != null) {
                if (PhpTokenTypes.opBIT_AND == prevSibling.getNode().getElementType()) {
                    PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_REF_ACCESS;
                    if (access == null) {
                        PhpCodeInsightUtil.$$$reportNull$$$0(81);
                    }
                    return access;
                }
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(82);
                }
                return access;
            }
        } else if (variableParent instanceof UnaryExpression) {
            if (PhpPsiUtil.isOfType(variableParent, PhpElementTypes.INFIX_WRITE_EXPRESSION, PhpElementTypes.POSTFIX_EXPRESSION)) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(83);
                }
                return access;
            }
        } else {
            if (variableParent instanceof ParameterList && anchor instanceof Variable) {
                PhpAccessInstruction.ReadOrReadRefAccess readOrReadRefAccess = new PhpAccessInstruction.ReadOrReadRefAccess((Variable)anchor);
                if (readOrReadRefAccess == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(84);
                }
                return readOrReadRefAccess;
            }
            if (variableParent instanceof PhpUnset) {
                PhpAccessInstruction.Access access = anchor instanceof Variable ? PhpAccessInstruction.Access.UNSET_ACCESS : PhpAccessInstruction.Access.READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(85);
                }
                return access;
            }
            if (variableParent instanceof PhpEmpty || variableParent instanceof PhpIsset) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.LIGHT_READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(86);
                }
                return access;
            }
            if (variableParent instanceof Global) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_REF_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(87);
                }
                return access;
            }
            if (variableParent instanceof Catch) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(88);
                }
                return access;
            }
            if (variableParent instanceof PhpUseList) {
                if (PhpWorkaroundUtil.isReadReference((PsiElement)anchor)) {
                    PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_REF_ACCESS;
                    if (access == null) {
                        PhpCodeInsightUtil.$$$reportNull$$$0(89);
                    }
                    return access;
                }
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(90);
                }
                return access;
            }
            if (PhpPsiUtil.isOfType(variableParent, PhpElementTypes.STATIC_STATEMENT)) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(91);
                }
                return access;
            }
        }
        PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
        if (access == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(92);
        }
        return access;
    }

    public static boolean isSameElementFieldReference(@Nullable PsiElement anchor, @NotNull CharSequence variableName, @NotNull CharSequence fieldName) {
        PhpExpression classReference;
        if (variableName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(93);
        }
        if (fieldName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(94);
        }
        return anchor instanceof FieldReference && (classReference = ((FieldReference)anchor).getClassReference()) instanceof Variable && PhpLangUtil.equalsVariableNames(variableName, ((Variable)classReference).getNameCS()) && PhpLangUtil.equalsFieldNames(fieldName, ((FieldReference)anchor).getNameCS());
    }

    public static Collection<PsiReference> collectReferencesToAlias(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(95);
        }
        if (phpUse.isTraitImport()) {
            return Collections.emptyList();
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpUse);
        if (scopeForUseOperator == null) {
            return Collections.emptyList();
        }
        if (phpUse.getAliasName() != null) {
            return PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, (PhpNamedElement)phpUse, phpUse.getName(), false, !PhpUseImpl.isOfConst(phpUse));
        }
        ArrayList references = ContainerUtil.newArrayList();
        for (PhpNamedElement phpNamedElement : PhpCodeInsightUtil.resolveTargetReferenceAvoidingDuplicates(phpUse)) {
            references.addAll(PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, phpNamedElement, phpUse.getName(), false, !(phpNamedElement instanceof Constant)));
        }
        return references;
    }

    public static boolean isUnused(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(96);
        }
        if (phpUse.isTraitImport()) {
            return false;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpUse);
        if (scopeForUseOperator == null) {
            return false;
        }
        if (phpUse.getAliasName() != null) {
            return PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, (PhpNamedElement)phpUse, phpUse.getName(), true, !PhpUseImpl.isOfConst(phpUse)).isEmpty();
        }
        Collection<? extends PhpNamedElement> elements = PhpCodeInsightUtil.resolveTargetReferenceAvoidingDuplicates(phpUse);
        if (elements.isEmpty()) {
            return false;
        }
        for (PhpNamedElement phpNamedElement : elements) {
            if (PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, phpNamedElement, phpUse.getName(), true, !(phpNamedElement instanceof Constant)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnnecessary(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(97);
        }
        if (phpUse.isTraitImport()) {
            return false;
        }
        if (phpUse.getAliasName() != null) {
            return false;
        }
        for (PhpNamedElement phpNamedElement : PhpCodeInsightUtil.resolveTargetReferenceAvoidingDuplicates(phpUse)) {
            if (phpNamedElement instanceof PhpNamespace || !PhpLangUtil.equalsClassNames(phpNamedElement.getNamespaceName(), phpUse.getNamespaceName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<? extends PhpNamedElement> resolveTargetReferenceAvoidingDuplicates(@NotNull PhpUse phpUse) {
        PhpReference targetReference;
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(98);
        }
        if ((targetReference = phpUse.getTargetReference()) != null) {
            Collection<PhpNamedElement> collection = targetReference.resolveGlobal(false).stream().collect(Collectors.toMap(Object::getClass, e -> e, (e1, e2) -> e1)).values();
            if (collection == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(99);
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(100);
        }
        return list;
    }

    @NotNull
    private static Collection<PsiReference> searchReferencesToAlias(@NotNull PhpPsiElement scopeForUseOperator, @NotNull PhpNamedElement aliasedNamedElement, final @NotNull String aliasedName, final boolean findFirstOnly, final boolean ignoreCase) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(101);
        }
        if (aliasedNamedElement == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(102);
        }
        if (aliasedName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(103);
        }
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)scopeForUseOperator);
        CommonProcessors.CollectProcessor<PsiReference> collector = new CommonProcessors.CollectProcessor<PsiReference>(){

            public boolean process(PsiReference reference) {
                return super.process((Object)reference) && (!findFirstOnly || this.getResults().isEmpty());
            }

            protected boolean accept(PsiReference reference) {
                return PhpCodeInsightUtil.isReferenceToAlias(reference, aliasedName, ignoreCase);
            }
        };
        ReferencesSearch.search((ReferencesSearch.SearchParameters)new PhpAliasSearchParameters((PsiElement)aliasedNamedElement, (SearchScope)searchScope)).forEach((Processor)collector);
        Collection collection = collector.getResults();
        if (collection == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(104);
        }
        return collection;
    }

    private static boolean isReferenceToAlias(@NotNull PsiReference reference, @NotNull String aliasedName, boolean ignoreCase) {
        PsiElement psiElement;
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(105);
        }
        if (aliasedName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(106);
        }
        if (PhpPsiUtil.getParentByCondition(psiElement = reference.getElement(), true, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) != null && PhpPsiUtil.getParentByCondition(psiElement, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF) == null) {
            return false;
        }
        String referenceText = StringUtil.trimStart((String)psiElement.getText(), (String)"@");
        return ignoreCase ? StringUtil.startsWithIgnoreCase((String)referenceText, (String)aliasedName) : StringUtil.startsWith((CharSequence)referenceText, (CharSequence)aliasedName);
    }

    @NotNull
    public static String toQualifiedPresentation(@NotNull PhpType phpType, @Nullable PhpPsiElement scopeForUseOperator) {
        if (phpType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(107);
        }
        if (scopeForUseOperator == null) {
            if ("" == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(108);
            }
            return "";
        }
        Set types = phpType.getTypesSorted();
        StringBuilder typeBuilder = new StringBuilder();
        boolean flag = false;
        for (String type : types) {
            if (type.startsWith("?")) continue;
            if (!flag) {
                flag = true;
            } else {
                typeBuilder.append("|");
            }
            String normalizedType = PhpType.toString((String)type);
            if (PhpLangUtil.isFqn(normalizedType)) {
                typeBuilder.append(PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, normalizedType, true, true));
                continue;
            }
            typeBuilder.append(normalizedType);
        }
        String string = typeBuilder.toString();
        if (string == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    @Nullable
    public static String getImmediateFQN(@NotNull PhpReference phpReference) {
        if (phpReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(110);
        }
        return StringUtil.nullize((String)(phpReference.getImmediateNamespaceName() + phpReference.getName()));
    }

    @NotNull
    public static Map<String, String> getAliasesInScope(@NotNull PhpPsiElement scopeHolder) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(111);
        }
        Map<String, String> map = PhpCodeInsightUtil.getAliasesInScope(scopeHolder, PhpGroupUseElement.PhpUseKeyword.values());
        if (map == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(112);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> getAliasesInScope(@NotNull PhpPsiElement scopeHolder, PhpGroupUseElement.PhpUseKeyword ... keywords) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(113);
        }
        THashMap aliases = new THashMap();
        List<PhpUseList> lists = PhpCodeInsightUtil.collectImports(scopeHolder);
        for (PhpUseList list : lists) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = list.getDeclarations()) {
                String keyword = PhpGroupUseElement.getKeyword(declaration, list);
                if (!Arrays.stream(keywords).anyMatch(s -> StringUtil.equals((CharSequence)s.getValue(), (CharSequence)keyword))) continue;
                String original2 = declaration.getFQN();
                String name = declaration.getName();
                aliases.put(name, original2);
            }
        }
        scopeHolder.acceptChildren((PsiElementVisitor)new PhpElementVisitor((Map)aliases){
            final /* synthetic */ Map val$aliases;
            {
                this.val$aliases = map;
            }

            public void visitPhpClass(PhpClass clazz) {
                this.val$aliases.put(clazz.getName(), clazz.getFQN());
            }

            public void visitPhpGroupStatement(GroupStatement groupStatement) {
                groupStatement.acceptChildren((PsiElementVisitor)this);
            }
        });
        THashMap tHashMap = aliases;
        if (tHashMap == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(114);
        }
        return tHashMap;
    }

    public static boolean isStrictTypes(@NotNull PhpFile file) {
        PsiElement directive;
        PsiElement phpOpeningTag;
        if (file == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(115);
        }
        if ((phpOpeningTag = file.getFirstChild().getFirstChild()) == null) {
            return false;
        }
        PsiElement declare = PhpPsiUtil.getNextSibling(phpOpeningTag, Conditions.not((Condition)Statement.INSTANCEOF));
        if (declare instanceof Declare && (directive = DeclareImpl.getStrictTypesDirective((Declare)declare)) != null) {
            PhpExpression expression = (PhpExpression)PhpPsiUtil.getChildByCondition(directive, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
            return expression != null && "1".equals(expression.getText());
        }
        return false;
    }

    public static boolean isUnpackedArgument(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(116);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parameter, true), PhpTokenTypes.opVARIADIC);
    }

    public static boolean isPassByRefParameter(@NotNull PsiElement parameter, boolean global) {
        block8: {
            ClassReference reference;
            int p;
            PsiElement parent;
            block9: {
                Object[] sig;
                int c;
                PsiElement parameterList;
                if (parameter == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(117);
                }
                if (!((parameterList = parameter.getParent()) instanceof ParameterList)) {
                    return false;
                }
                parent = parameterList.getParent();
                if (!(parent instanceof FunctionReference)) break block9;
                int p2 = PhpCodeInsightUtil.getParameterIndex(parameter);
                FunctionReference functionReference = (FunctionReference)parent;
                String name = functionReference.getName();
                if (name == null || name.length() == 0) {
                    return false;
                }
                Object[][] objectArray = STD_LIB_FUN_WITH_REF_ARGS;
                int n = objectArray.length;
                for (int i = 0; i < n && (c = ((String)(sig = objectArray[i])[0]).compareTo(name)) <= 0; ++i) {
                    if (c != 0 || !sig[1].equals(p2)) continue;
                    return true;
                }
                if (p2 < 0 || !global) break block8;
                List candidates = FileBasedIndex.getInstance().getValues(PhpFunctionNameIndex.KEY, (Object)name, PhpIndex.getInstance((Project)parameter.getProject()).getSearchScope());
                candidates.addAll(FileBasedIndex.getInstance().getValues(PhpMethodNameIndex.KEY, (Object)name, PhpIndex.getInstance((Project)parameter.getProject()).getSearchScope()));
                for (Boolean hasRefParams : candidates) {
                    ResolveResult[] results;
                    if (!hasRefParams.booleanValue()) continue;
                    for (ResolveResult result : results = functionReference.multiResolve(false)) {
                        PsiElement function = result.getElement();
                        if (!(function instanceof Function) || !PhpCodeInsightUtil.isPassByRef((Function)function, p2)) continue;
                        return true;
                    }
                    break block8;
                }
                break block8;
            }
            if (parent instanceof NewExpression && (p = PhpCodeInsightUtil.getParameterIndex(parameter)) >= 0 && global && (reference = ((NewExpression)parent).getClassReference()) != null) {
                ResolveResult[] results;
                for (ResolveResult result : results = reference.multiResolve(false)) {
                    Method method;
                    PsiElement resolved = result.getElement();
                    Object object = resolved instanceof Method ? (Method)resolved : (method = resolved instanceof PhpClass ? ((PhpClass)resolved).getConstructor() : null);
                    if (method == null || !PhpCodeInsightUtil.isPassByRef((Function)method, p)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPassByRef(@NotNull Function function, int p) {
        Parameter[] parameters;
        if (function == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(118);
        }
        return (parameters = function.getParameters()).length > p && parameters[p].isPassByRef() || parameters.length > 0 && parameters[parameters.length - 1].isVariadic() && parameters[parameters.length - 1].isPassByRef();
    }

    public static int getParameterIndex(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(119);
        }
        if (!(parameter.getParent() instanceof ParameterList)) {
            return -1;
        }
        PhpPsiElement child = ((ParameterList)parameter.getParent()).getFirstPsiChild();
        int i = 0;
        while (child != null) {
            if (parameter.equals(child)) {
                return i;
            }
            child = child.getNextPsiSibling();
            ++i;
        }
        return -1;
    }

    @NotNull
    public static PhpType getLocalType(@NotNull PhpReference phpReference) {
        if (phpReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(120);
        }
        PhpType type = new PhpType();
        Collection targets = phpReference.resolveLocal();
        if (targets.size() == 0) {
            String signature = phpReference.getSignature();
            for (String sig : StringUtil.split((String)signature, (String)"|")) {
                type.add(sig);
            }
        } else {
            for (PhpNamedElement target : targets) {
                type.add((PsiElement)target);
            }
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(121);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 41: 
            case 42: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 104: 
            case 108: 
            case 109: 
            case 112: 
            case 114: 
            case 121: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 41: 
            case 42: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 104: 
            case 108: 
            case 109: 
            case 112: 
            case 114: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndex";
                break;
            }
            case 5: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 14: 
            case 71: 
            case 72: 
            case 73: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 38: 
            case 43: 
            case 64: 
            case 101: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 17: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 44: 
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 41: 
            case 42: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 104: 
            case 108: 
            case 109: 
            case 112: 
            case 114: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpCodeInsightUtil";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFqn";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNamespaceFQN";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 45: 
            case 47: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 48: 
            case 51: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFqn";
                break;
            }
            case 49: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 53: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNamespace";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defFqn";
                break;
            }
            case 66: 
            case 68: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUse";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasedNamedElement";
                break;
            }
            case 103: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasedName";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 110: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpReference";
                break;
            }
            case 116: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpCodeInsightUtil";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImports";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamespaces";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclarations";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTargetReferenceAvoidingDuplicates";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "searchReferencesToAlias";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "toQualifiedPresentation";
                break;
            }
            case 112: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasesInScope";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyBody";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResultUsed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIncrementOrDecrementExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSilenceExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isForeachKeyOrValueAssignedByReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasMagicMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isScopeForUseOperator";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findScopeForUseOperator";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifier";
                break;
            }
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedName";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 41: 
            case 42: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 104: 
            case 108: 
            case 109: 
            case 112: 
            case 114: 
            case 121: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAliasUsed";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAliassed";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collectImports";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "collectNamespaces";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isSameNamespace";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasNameConflicts";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "equalConstantFqns";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "alreadyImported";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarations";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isFullyQualified";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isNotInImport";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isImportSupported";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getAccess";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isSameElementFieldReference";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "collectReferencesToAlias";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isUnused";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isUnnecessary";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "resolveTargetReferenceAvoidingDuplicates";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "searchReferencesToAlias";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToAlias";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "toQualifiedPresentation";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateFQN";
                break;
            }
            case 111: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getAliasesInScope";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypes";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isUnpackedArgument";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isPassByRefParameter";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isPassByRef";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getLocalType";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectImports$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 41: 
            case 42: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 104: 
            case 108: 
            case 109: 
            case 112: 
            case 114: 
            case 121: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpAliasSearchParameters
    extends ReferencesSearch.SearchParameters {
        public PhpAliasSearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope) {
            if (elementToSearch == null) {
                PhpAliasSearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                PhpAliasSearchParameters.$$$reportNull$$$0(1);
            }
            super(elementToSearch, scope, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elementToSearch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/PhpCodeInsightUtil$PhpAliasSearchParameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ImportElementType {
        CLASS,
        NAMESPACE,
        FUNCTION,
        CONSTANT;


        @Nullable
        public static ImportElementType fromElement(@NotNull PsiElement element) {
            if (element == null) {
                ImportElementType.$$$reportNull$$$0(0);
            }
            if (element instanceof PhpClass || element instanceof ClassReference) {
                return CLASS;
            }
            if (element instanceof PhpNamespace || element instanceof PhpNamespaceReference) {
                return NAMESPACE;
            }
            if (element instanceof Function || element instanceof FunctionReference) {
                return FUNCTION;
            }
            if (element instanceof Constant || element instanceof ConstantReference) {
                return CONSTANT;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/codeInsight/PhpCodeInsightUtil$ImportElementType", "fromElement"));
        }
    }
}

