/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SofterReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.LineReader;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.completion.ClassUsageContext;
import com.jetbrains.php.completion.CompletionResultSetWrapper;
import com.jetbrains.php.completion.PhpArrayIndexCompletionProvider;
import com.jetbrains.php.completion.PhpCompletionSorting;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpFqnPrefixMatcher;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpSmartFunctionParametersLookupElement;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.completion.UsageContext;
import com.jetbrains.php.completion.insert.PhpCastTypeInsertHandler;
import com.jetbrains.php.completion.insert.PhpClassConstructorInsertHandler;
import com.jetbrains.php.completion.insert.PhpClassInStringLiteralInsertHandler;
import com.jetbrains.php.completion.insert.PhpClassStaticInsertHandler;
import com.jetbrains.php.completion.insert.PhpFunctionInsertHandler;
import com.jetbrains.php.completion.insert.PhpNamespaceInsertHandler;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.completion.insert.PhpSymbolInsertHandler;
import com.jetbrains.php.completion.insert.PhpVariableInsertHandler;
import com.jetbrains.php.completion.phpunit.PhpUnitCoversClassInsertHandler;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugRuntimeEnvironment;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDataProviderTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDependsTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocExpectedExceptionTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLangTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpTypeCodeFragment;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpGotoImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.util.PhpStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCompletionContributor
extends CompletionContributor {
    public static final String PHP_OPENING_TAG_LOOKUP_STRING = "php";
    private static final PatternCondition<PsiElement> CONSTRUCTOR_PATTERN = new PatternCondition<PsiElement>("constructor"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return element instanceof Method && ((Method)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionContributor$1", "accepts"));
        }
    };
    private static final PhpClassRefCompletionProvider PHP_CLASS_REF_COMPLETION_PROVIDER = new PhpClassRefCompletionProvider();
    private static final PhpFuncRefCompletionProvider PHP_FUNC_REF_COMPLETION_PROVIDER = new PhpFuncRefCompletionProvider();
    @NonNls
    public static final SortedSet<String> PHP_PREDEFINED_FUNCTIONS = new TreeSet<String>();
    private static final Condition<PsiElement> CHILD_OF_FOREACH = element -> element.getParent() instanceof ForeachStatement;
    private static final String[] castTypesStrings;
    private static final String[] typeDeclarationsStrings;
    private static final String[] phpDocTypesStrings;
    private static final String[] functags;
    private static final String[] classtags;
    private static final String[] vartags;
    private static final String[] everywheretags;
    private static final String[] phpunittags;

    private static void readFileToSet(@NotNull String filename, @NotNull Set<String> set) {
        if (filename == null) {
            PhpCompletionContributor.$$$reportNull$$$0(0);
        }
        if (set == null) {
            PhpCompletionContributor.$$$reportNull$$$0(1);
        }
        InputStream predefined = null;
        try {
            predefined = PhpCompletionContributor.class.getResourceAsStream(filename);
            if (predefined != null) {
                LineReader lineReader = new LineReader(predefined);
                List list = lineReader.readLines();
                for (byte[] bytes : list) {
                    set.add(new String(bytes, CharsetToolkit.UTF8_CHARSET));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (predefined != null) {
                try {
                    predefined.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void addCastTypes(@NotNull CompletionResultSet result) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(2);
        }
        PhpCastTypeInsertHandler insertHandler = PhpCastTypeInsertHandler.getInstance();
        for (String type : castTypesStrings) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)type).withPresentableText("(" + type + ")").withInsertHandler((InsertHandler)insertHandler));
        }
    }

    private static void addTypeDeclarations(@NotNull CompletionResultSet result, boolean isTypeCodeFragment) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(3);
        }
        for (String declaration : typeDeclarationsStrings) {
            PhpCompletionContributor.addTypeDeclaration(result, isTypeCodeFragment, declaration);
        }
    }

    private static void addTypeDeclaration(@NotNull CompletionResultSet result, boolean isTypeCodeFragment, @NotNull String declaration) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(4);
        }
        if (declaration == null) {
            PhpCompletionContributor.$$$reportNull$$$0(5);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)declaration).withBoldness(true);
        if (isTypeCodeFragment) {
            result.addElement((LookupElement)builder);
        } else {
            result.addElement((LookupElement)builder.withInsertHandler((InsertHandler)PhpSymbolInsertHandler.SPACE));
        }
    }

    private static void addPhpDocTypes(@NotNull CompletionResultSet result) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(6);
        }
        for (String type : phpDocTypesStrings) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)type).withBoldness(true));
        }
    }

    public PhpCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(ClassReference.class)).withSuperParent(2, Catch.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(ClassReference.class)).withSuperParent(2, Catch.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, PhpThrow.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, PhpThrow.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocExpectedExceptionTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocExpectedExceptionTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocThrowsTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocThrowsTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(Variable.class)).withSuperParent(2, Catch.class), new PhpCatchVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpOpeningTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ArrayIndex.class), new PhpArrayIndexCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpNamespaceCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpDocRef.class), new PhpNamespaceCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(MemberReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(MemberReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpQualifiedFunctionAndConstantCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpQualifiedFunctionAndConstantCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(1, PhpDocPsiElement.class), new PhpDocCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpDocTokenTypes.DOC_IDENTIFIER).withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpDocElementTypes.phpDocTagValue)), new PhpDocCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocDataProviderTag.class), new PhpDataProviderTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocCoversTag.class), new PhpCoversTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpDocTag.class).with(PhpCompletionUtil.getDocTagNamedPattern("@coversDefaultClass"))), new PhpCoversTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocLangTag.class), new PhpLangTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(FunctionReference.class), PHP_FUNC_REF_COMPLETION_PROVIDER);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpNamespace.class), new PhpNamespaceCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpGoto.class), new PhpGotoLabelCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Parameter.class), new TypeHintSuggestionsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(Parameter.class)).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement().with(CONSTRUCTOR_PATTERN)), new PhpFieldNamesForConstructorParametersCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ForeachStatement.class), new PhpForeachKeyAndValueCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, ForeachStatement.class), new PhpForeachKeyAndValueCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class)))).withSuperParent(2, ParenthesizedExpression.class), new PhpCastCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ParameterList.class), new PhpSmartFunctionParametersCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).withSuperParent(2, ParameterList.class)).withSuperParent(3, FunctionReference.class), new PhpIniDirectivesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).withSuperParent(2, ParameterList.class)).withSuperParent(3, FunctionReference.class), new PhpVariableForCompactCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpTokenTypes.IDENTIFIER).withParent(PhpClass.class), new PhpClassNameByFileNameCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpStringLiteralClassesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpGlobalCompletionProviderFacade());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpGlobalCompletionProviderFacade());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(FieldReference.class), new PhpDynamicPropertyCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(FieldReference.class), new PhpDynamicPropertyCompletionProvider());
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement prevElement;
        PsiFile file;
        PsiElement currElement;
        PhpExpression expression;
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(7);
        }
        if ((expression = (PhpExpression)ObjectUtils.tryCast((Object)TargetElementUtil.findReference((Editor)context.getEditor(), (int)context.getSelectionEndOffset()), PhpExpression.class)) != null && expression.getParent() instanceof StringLiteralExpression && PhpPsiUtil.isOfType(expression.getLastChild(), PhpTokenTypes.chRBRACE)) {
            context.setReplacementOffset(context.getSelectionEndOffset());
        } else if (expression instanceof MemberReference && (currElement = (file = context.getFile()).findElementAt(context.getSelectionEndOffset())) instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)currElement.getText()) > 0 && PhpPsiUtil.isOfType(prevElement = file.findElementAt(context.getSelectionEndOffset() - 1), PhpTokenTypes.ARROW)) {
            context.setReplacementOffset(context.getSelectionEndOffset());
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(8);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(9);
        }
        super.fillCompletionVariants(parameters, PhpCompletionSorting.addPhpSorting(parameters, result));
    }

    static PsiElement findPrevElement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(10);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(11);
        }
        return parameters.getOriginalFile().findElementAt(parameters.getOffset() - 1 - result.getPrefixMatcher().getPrefix().length());
    }

    @Nullable
    static ClassReference getTraitReference(@NotNull PhpTraitUseRule traitUseRule) {
        PsiElement classReference;
        MethodReference methodReference;
        if (traitUseRule == null) {
            PhpCompletionContributor.$$$reportNull$$$0(12);
        }
        if ((methodReference = traitUseRule.getOriginalReference()) != null && (classReference = methodReference.getFirstChild()) instanceof ClassReference) {
            return (ClassReference)classReference;
        }
        return null;
    }

    public static void handleOverflow(CompletionResultSet set) {
        set.restartCompletionOnAnyPrefixChange();
        set.addLookupAdvertisement("Not all variants are shown, please type more letters to see the rest");
    }

    private static boolean shouldAddClass(@NotNull PhpClass aClass, @NotNull ClassUsageContext context, @Nullable PhpClass current) {
        if (aClass == null) {
            PhpCompletionContributor.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(14);
        }
        if (aClass.isInterface() || aClass.isTrait()) {
            return false;
        }
        String currentFqn = current != null ? current.getFQN() : null;
        String itemFqn = aClass.getFQN();
        return (current == null || !context.isInExtends() || !PhpLangUtil.equalsClassNames(currentFqn, itemFqn)) && !itemFqn.startsWith("\\___PHPSTORM_HELPERS");
    }

    public static boolean isSuitableForPhpDocMethodType(PsiElement position) {
        return position instanceof PhpDocMethod && !PhpPsiUtil.isOfType((PsiElement)((PhpDocMethod)position).getPrevPsiSibling(), (IElementType)PhpDocElementTypes.phpDocMethodType);
    }

    private static Collection<PhpUse> getUses(PsiElement position) {
        PhpUseList useList = PhpUseImpl.getUseList(position);
        if (useList != null && !useList.isTraitImport()) {
            return Collections.emptyList();
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(position);
        if (scope == null) {
            return Collections.emptyList();
        }
        List uses = ContainerUtil.newSmartList();
        for (PhpUseList list : PhpCodeInsightUtil.collectImports(scope)) {
            for (PhpUse use : list.getDeclarations()) {
                String name = use.getName();
                if (StringUtil.isEmpty((String)name)) continue;
                uses.add(use);
            }
        }
        return uses;
    }

    public static boolean afterPhpDocRefAndStaticModifier(PsiElement position, PsiElement parent) {
        return parent instanceof PhpDocRef && PhpPsiUtil.isOfType(position.getPrevSibling(), PhpDocTokenTypes.DOC_STATIC);
    }

    public static List<LookupElement> collectMembersOfClassByDocRef(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiElement position, PsiElement parent, boolean addFields) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(15);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(16);
        }
        List members = ContainerUtil.newSmartList();
        for (PhpDocLinkResolver.Result element : PhpDocLinkResolver.resolve(parent.getText(), position)) {
            PhpClass phpClass = element.getPhpClass();
            if (phpClass == null) continue;
            boolean includeMagic = parameters.getInvocationCount() > 1;
            members.addAll(PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, null));
            if (!addFields) continue;
            members.addAll(PhpVariantsUtil.getLookupItems(phpClass.getFields(), includeMagic, null));
        }
        return members;
    }

    public static void addClassesAndFunctions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(18);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(19);
        }
        PHP_CLASS_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
        PHP_FUNC_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
    }

    @NotNull
    private static CompletionResultSet patchResultIfNeeded(@NotNull CompletionResultSet result) {
        String prefix;
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(20);
        }
        if ((prefix = result.getPrefixMatcher().getPrefix()).startsWith("${")) {
            result = result.withPrefixMatcher(prefix.substring(2));
        } else if (prefix.startsWith("{$")) {
            result = result.withPrefixMatcher(prefix.substring(2));
        } else if (prefix.startsWith("$")) {
            result = result.withPrefixMatcher(prefix.substring(1));
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            PhpCompletionContributor.$$$reportNull$$$0(21);
        }
        return completionResultSet;
    }

    static boolean isGlobal(PsiElement position) {
        PsiElement sibling;
        Variable variable = (Variable)PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)Variable.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (variable != null && variable.getParent() instanceof Global && PhpPsiUtil.findNextSiblingOfAnyType(variable.getFirstChild(), PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE) == null) {
            return true;
        }
        Statement statement = (Statement)PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        return statement != null && (sibling = statement.getPrevSibling()) instanceof Global && !PhpPsiUtil.isOfType(sibling.getLastChild(), PhpTokenTypes.opSEMICOLON);
    }

    private static boolean isList(PsiElement position) {
        MultiassignmentExpression list = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        return list != null && !PsiTreeUtil.isAncestor((PsiElement)list.getValue(), (PsiElement)position, (boolean)true);
    }

    private static Collection<String> suggestNames(@NotNull PsiElement element, @Nullable PsiElement context) {
        NameSuggestionProvider provider;
        SuggestedNameInfo suggestedNameInfo;
        if (element == null) {
            PhpCompletionContributor.$$$reportNull$$$0(22);
        }
        HashSet result = ContainerUtil.newHashSet();
        Iterator iterator = NameSuggestionProvider.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && ((suggestedNameInfo = (provider = (NameSuggestionProvider)iterator.next()).getSuggestedNames(element, context, (Set)result)) == null || !(provider instanceof PreferrableNameSuggestionProvider) || ((PreferrableNameSuggestionProvider)provider).shouldCheckOthers())) {
        }
        return result;
    }

    static boolean isNamespace(PsiElement prev) {
        return prev instanceof PhpNamespaceReference || PhpPsiUtil.isOfType(prev, PhpTokenTypes.NAMESPACE_RESOLUTION) && PhpPsiUtil.isOfType(prev.getPrevSibling(), PhpTokenTypes.kwNAMESPACE);
    }

    @Nullable
    private static String getNamespace(PsiElement prev, PsiElement parent) {
        if (prev instanceof PhpNamespaceReference) {
            return ((PhpNamespaceReference)prev).getFullName();
        }
        if (parent instanceof PhpReference) {
            return ((PhpReference)parent).getNamespaceName();
        }
        return null;
    }

    private static void addFunctionVariants(@NotNull Project project, @Nullable String namespaceName, @NotNull CompletionResultSetWrapper result, boolean filterVoid, boolean filterSpecialReferences) {
        if (project == null) {
            PhpCompletionContributor.$$$reportNull$$$0(23);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(24);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        int limit = PhpCompletionUtil.getLimit();
        PrefixMatcher matcher = result.getPrefixMatcher();
        for (String functionName : CompletionUtil.sortMatching((PrefixMatcher)matcher, (Collection)phpIndex.getAllFunctionNames(matcher))) {
            List functions;
            if (namespaceName != null) {
                functions = phpIndex.getFunctionsByFQN(namespaceName + functionName).stream().map(function -> PhpVariantsUtil.getLookupItem((PhpNamedElement)function, null)).filter(element -> !filterVoid || !PhpType.VOID.equals((Object)element.getPhpType())).collect(Collectors.toList());
                result.addAllElements(functions);
                limit -= functions.size();
            } else if (!filterSpecialReferences || !PhpReferenceInsertHandler.SPECIAL_REFERENCES.contains(functionName)) {
                functions = phpIndex.getFunctionsByName(functionName).stream().map(function -> PhpVariantsUtil.getLookupItem((PhpNamedElement)function, null)).filter(element -> !filterVoid || !PhpType.VOID.equals((Object)element.getPhpType())).collect(Collectors.toList());
                result.addAllElements(functions);
                limit -= functions.size();
            }
            if (limit > 0) continue;
            PhpCompletionContributor.handleOverflow(result.getResult());
            break;
        }
    }

    private static void addConstantVariants(@NotNull Project project, @Nullable String namespaceName, @NotNull CompletionResultSetWrapper result, boolean filterSpecialReferences) {
        if (project == null) {
            PhpCompletionContributor.$$$reportNull$$$0(25);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(26);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        int limit = PhpCompletionUtil.getLimit();
        PrefixMatcher matcher = result.getPrefixMatcher();
        for (String constantName : CompletionUtil.sortMatching((PrefixMatcher)matcher, (Collection)phpIndex.getAllConstantNames(matcher))) {
            if (namespaceName != null) {
                for (LookupElement element : PhpVariantsUtil.getLookupItems(phpIndex.getConstantsByFQN(namespaceName + constantName), true, null)) {
                    result.addElement(element);
                    if (--limit > 0) continue;
                    PhpCompletionContributor.handleOverflow(result.getResult());
                    return;
                }
                continue;
            }
            if (filterSpecialReferences && PhpReferenceInsertHandler.SPECIAL_REFERENCES.contains(constantName)) continue;
            for (LookupElement element : PhpVariantsUtil.getLookupItems(phpIndex.getConstantsByName(constantName), true, null)) {
                result.addElement(element);
                if (--limit > 0) continue;
                PhpCompletionContributor.handleOverflow(result.getResult());
                return;
            }
        }
    }

    @Nullable
    private static String getNamespaceNameForGroupUse(@NotNull PsiElement position) {
        PhpNamespaceReference namespaceReference;
        PhpUseList useList;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(27);
        }
        if ((useList = PhpUseImpl.getUseList(position)) != null && (namespaceReference = useList.getNamespaceReference()) != null) {
            return PhpLangUtil.toFQN(namespaceReference.getFullName());
        }
        return null;
    }

    static boolean isForeachKeyOrValue(@NotNull PsiElement position) {
        Object parent;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(28);
        }
        if ((parent = PhpPsiUtil.getParentByCondition(position, true, CHILD_OF_FOREACH, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF)) != null && PhpCompletionContributor.isInsideParentheses(parent)) {
            PsiElement array = ((ForeachStatement)parent.getParent()).getArray();
            return null == PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)((Condition)element -> element == array), (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF);
        }
        return false;
    }

    static boolean isInsideParentheses(PsiElement parent) {
        PsiElement sibling = PhpPsiUtil.findPrevSiblingOfAnyType(parent, PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN);
        return PhpPsiUtil.isOfType(sibling, PhpTokenTypes.chLPAREN);
    }

    static boolean isIssetOrUnset(PsiElement position) {
        if (PhpPsiUtil.isOfType(position, PhpTokenTypes.IDENTIFIER)) {
            position = position.getParent();
        }
        if (position instanceof ConstantReference) {
            position = position.getParent();
        }
        return position instanceof PhpIsset || position instanceof PhpUnset;
    }

    static boolean isClosureUse(@NotNull PsiElement position) {
        PhpUseList useList;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(29);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)(useList = PhpUseImpl.getUseList(position)), true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static void visitScopeHolderBranches(PsiElement position, final @NotNull Processor<PsiElement> processor) {
        Object parent;
        PhpScopeHolder scopeHolder;
        if (processor == null) {
            PhpCompletionContributor.$$$reportNull$$$0(30);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder(position)) != null && (parent = PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)e -> {
            PsiElement elementParent = e.getParent();
            return elementParent != null && elementParent.getParent() == scopeHolder;
        }))) != null) {
            PhpRadialSiblingIterator iterator = new PhpRadialSiblingIterator((PsiElement)parent);
            final int[] count = new int[1];
            while (iterator.hasNext() && count[0] < 500) {
                ((PsiElement)iterator.next()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        count[0] = count[0] + 1;
                        if (processor.process((Object)element)) {
                            if (count[0] >= 500) {
                                this.stopWalking();
                            } else {
                                super.visitElement(element);
                            }
                        }
                    }
                });
            }
        }
    }

    @NotNull
    static String getCompletionActionShortcut() {
        String string = PhpCompletionContributor.getActionShortcut((String)"CodeCompletion");
        if (string == null) {
            PhpCompletionContributor.$$$reportNull$$$0(31);
        }
        return string;
    }

    static {
        PhpCompletionContributor.readFileToSet("functions.txt", PHP_PREDEFINED_FUNCTIONS);
        castTypesStrings = new String[]{"int", "integer", "bool", "boolean", "float", "double", "real", "string", "array", "object", "unset", "binary"};
        typeDeclarationsStrings = new String[]{"self", "parent", "array", "callable", "bool", "float", "int", "string", "object"};
        phpDocTypesStrings = new String[]{"int", "integer", "bool", "boolean", "float", "double", "string", "array", "object", "callable", "true", "false", "null", "mixed", "resource", "void", "self", "static", "parent", "$this"};
        functags = new String[]{"@deprecated", "@inheritdoc", "@param", "@return", "@throws", "@codeCoverageIgnore"};
        classtags = new String[]{"@deprecated", "@inheritdoc", "@method", "@property", "@property-read", "@property-write", "@mixin", "@codeCoverageIgnore"};
        vartags = new String[]{"@deprecated", "@global", "@var"};
        everywheretags = new String[]{"@api", "@internal", "@author", "@copyright", "@example", "@license", "@package", "@see", "@uses", "@since", "@version", "@todo"};
        phpunittags = new String[]{"@after", "@afterClass", "@backupGlobals", "@backupStaticAttributes", "@before", "@beforeClass", "@codeCoverageIgnore", "@covers", "@coversDefaultClass", "@coversNothing", "@dataProvider", "@depends", "@expectedException", "@expectedExceptionCode", "@expectedExceptionMessage", "@expectedExceptionMessageRegExp", "@group", "@large", "@medium", "@outputBuffering", "@preserveGlobalState", "@requires", "@runTestsInSeparateProcesses", "@runInSeparateProcess", "@small", "@test", "@testdox", "@ticket"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traitUseRule";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "patchResultIfNeeded";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionActionShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFileToSet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCastTypes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDeclarations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPhpDocTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPrevElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTraitReference";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectMembersOfClassByDocRef";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addClassesAndFunctions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchResultIfNeeded";
                break;
            }
            case 21: 
            case 31: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "suggestNames";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionVariants";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addConstantVariants";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceNameForGroupUse";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isForeachKeyOrValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isClosureUse";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitScopeHolderBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpStringLiteralClassesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpStringLiteralClassesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(2);
            }
            if (parameters.isExtendedCompletion()) {
                PsiElement position = parameters.getPosition().getOriginalElement();
                PsiElement parent = position.getParent();
                if (PhpPsiUtil.isOfType(parent, PhpElementTypes.HEREDOC)) {
                    return;
                }
                String prefix = result.getPrefixMatcher().getPrefix();
                if (position.getText().startsWith("\\") && !prefix.startsWith("\\")) {
                    result = result.withPrefixMatcher("\\" + prefix);
                }
                PrefixMatcher prefixMatcher = result.getPrefixMatcher();
                boolean singleLiteral = PhpPsiUtil.isOfType(parent, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE);
                String prefixWithoutEscaping = PhpStringUtil.unescapeText(prefixMatcher.getPrefix(), singleLiteral, new String[0]);
                String namespace = PhpLangUtil.toFQN(PhpLangUtil.getParentQualifiedName(prefixWithoutEscaping));
                if (!namespace.endsWith("\\")) {
                    namespace = namespace + "\\";
                }
                PhpIndex phpIndex = PhpIndex.getInstance((Project)position.getProject());
                PhpStringLiteralClassesCompletionProvider.addMatchedSubNamespaces(prefixMatcher, namespace, result, phpIndex);
                PhpStringLiteralClassesCompletionProvider.addMatchedPhpClasses(prefixMatcher, namespace, result, phpIndex, PhpLangUtil.toShortName(prefixWithoutEscaping));
            }
        }

        private static void addMatchedSubNamespaces(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(3);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(4);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(5);
            }
            if (phpIndex == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(6);
            }
            Collection<String> phpNamespaces = PhpCompletionUtil.getAllChildNamespaceNames(phpIndex, namespace);
            for (String i : phpNamespaces) {
                String fqn = PhpLangUtil.toFQN(i);
                if (fqn.startsWith("\\___PHPSTORM_HELPERS")) continue;
                for (PhpNamespace phpNamespace : phpIndex.getNamespacesByName(fqn)) {
                    PhpLookupElement element = new PhpLookupElement((PhpNamedElement)phpNamespace);
                    element.handler = PhpClassInStringLiteralInsertHandler.getInstance();
                    element.lookupString = PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(phpNamespace.getFQN(), prefixMatcher.getPrefix());
                    result.addElement((LookupElement)element);
                }
            }
        }

        private static void addMatchedPhpClasses(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, @NotNull String classPrefix) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(7);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(8);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(9);
            }
            if (phpIndex == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(10);
            }
            if (classPrefix == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(11);
            }
            boolean globalNamespace = PhpLangUtil.isGlobalNamespaceFQN(namespace);
            PrefixMatcher matcher = prefixMatcher.cloneWithPrefix(classPrefix);
            Predicate<PhpClass> predicate = aClass -> {
                if (namespace == null) {
                    PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(18);
                }
                if (!globalNamespace && !PhpCompletionUtil.hasNamespace(namespace, false, aClass)) {
                    return false;
                }
                return !aClass.getFQN().startsWith("\\___PHPSTORM_HELPERS");
            };
            Consumer<PhpClass> adder = aClass -> {
                if (namespace == null) {
                    PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(15);
                }
                if (prefixMatcher == null) {
                    PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(16);
                }
                if (result == null) {
                    PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(17);
                }
                PhpLookupElement element = new PhpLookupElement((PhpNamedElement)aClass);
                element.handler = PhpClassInStringLiteralInsertHandler.getInstance();
                if (!globalNamespace) {
                    element.lookupString = PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(namespace, prefixMatcher.getPrefix()) + aClass.getName();
                }
                result.addElement((LookupElement)element);
            };
            PhpCompletionUtil.addClasses(phpIndex, matcher, predicate, adder);
            PhpCompletionUtil.addInterfaces(phpIndex, predicate, adder, null);
            PhpCompletionUtil.addTraits(phpIndex, predicate, adder);
        }

        @NotNull
        private static String adjustNamespaceToPrefix(@NotNull String namespace, @NotNull String prefix) {
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(12);
            }
            if (prefix == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(13);
            }
            namespace = prefix.startsWith("\\") ? namespace : PhpLangUtil.toPresentableFQN(namespace);
            namespace = namespace + "\\";
            if (prefix.contains("\\\\")) {
                namespace = StringUtil.replace((String)namespace, (String)"\\", (String)"\\\\");
            }
            String string = namespace;
            if (string == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(14);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: 
                case 9: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 7: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpIndex";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPrefix";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpStringLiteralClassesCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpStringLiteralClassesCompletionProvider";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustNamespaceToPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatchedSubNamespaces";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatchedPhpClasses";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustNamespaceToPrefix";
                    break;
                }
                case 14: {
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addMatchedPhpClasses$1";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addMatchedPhpClasses$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpClassNameByFileNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassNameByFileNameCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiFile file;
            String name;
            PsiElement position;
            PsiElement sibling;
            if (parameters == null) {
                PhpClassNameByFileNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpClassNameByFileNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpClassNameByFileNameCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(sibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(position = parameters.getPosition().getOriginalElement(), true), PhpTokenTypes.kwCLASS, PhpTokenTypes.kwINTERFACE, PhpTokenTypes.kwTRAIT) && PhpNameUtil.isValidClassName(name = PhpNameUtil.getNameWithoutExtension((file = position.getContainingFile()).getName()))) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)name));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpClassNameByFileNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpVariableForCompactCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpVariableForCompactCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            FunctionReference function;
            if (parameters == null) {
                PhpVariableForCompactCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpVariableForCompactCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpVariableForCompactCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((function = (FunctionReference)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), true, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && "compact".equals(function.getName())) {
                boolean allGlobals;
                boolean bl = allGlobals = parameters.getInvocationCount() > 1;
                if (!allGlobals) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.global.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                }
                for (LookupElement element : VariableImpl.getVariableVariants(position, allGlobals)) {
                    if (element instanceof PhpLookupElement) {
                        ((PhpLookupElement)element).handler = null;
                    }
                    result.addElement(element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpVariableForCompactCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpIniDirectivesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final Collection<String> FUNCTIONS = ContainerUtil.newSmartList((Object[])new String[]{"ini_get", "ini_set", "get_cfg_var", "ini_restore", "ini_alter"});
        private SofterReference<List<LookupElement>> ref;

        private PhpIniDirectivesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String function;
            PsiElement[] referenceParameters;
            PsiElement position;
            ParameterList parameterList;
            if (parameters == null) {
                PhpIniDirectivesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpIniDirectivesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpIniDirectivesCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), true, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && (referenceParameters = parameterList.getParameters()).length > 0 && referenceParameters[0] == position.getParent() && FUNCTIONS.contains(function = ((FunctionReference)parameterList.getParent()).getName())) {
                List directives;
                List list = directives = this.ref != null ? (List)this.ref.get() : null;
                if (directives == null) {
                    TreeSet set = ContainerUtil.newTreeSet();
                    PhpCompletionContributor.readFileToSet("php.ini.txt", set);
                    directives = set.stream().map(LookupElementBuilder::create).collect(Collectors.toList());
                    this.ref = new SofterReference(directives);
                }
                result.addAllElements((Iterable)directives);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpIniDirectivesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDynamicPropertyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final PhpType STD_CLASS_TYPE = PhpType.builder().add("\\stdClass").build();

        private PhpDynamicPropertyCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpDynamicPropertyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDynamicPropertyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDynamicPropertyCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement().getParent();
            assert (position instanceof FieldReference);
            if (PhpCompletionContributor.isNamespace(parameters.getPosition().getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
            PhpExpression hostVariable = ((FieldReference)position).getClassReference();
            Project project = position.getProject();
            if (hostVariable instanceof Variable) {
                if (parameters.getInvocationCount() > 1 || STD_CLASS_TYPE.isConvertibleFrom(hostVariable.getType(), PhpIndex.getInstance((Project)project))) {
                    String hostVariableName = hostVariable.getName();
                    if (StringUtil.isNotEmpty((String)hostVariableName)) {
                        HashSet visited = ContainerUtil.newHashSet();
                        PhpCompletionContributor.visitScopeHolderBranches(parameters.getPosition().getOriginalElement(), (Processor<PsiElement>)element -> {
                            if (element instanceof FieldReference) {
                                String fieldName;
                                if (element == position) {
                                    return false;
                                }
                                PhpExpression variable = ((FieldReference)element).getClassReference();
                                if (variable instanceof Variable && hostVariableName.equals(variable.getName()) && StringUtil.isNotEmpty((String)(fieldName = ((FieldReference)element).getName())) && visited.add(fieldName)) {
                                    PhpType type = ((FieldReference)element).getType().global(project);
                                    wrappedResult.addElement((LookupElement)LookupElementBuilder.create((Object)element, (String)fieldName).withTypeText(type.toStringRelativized("\\")).withIcon(PhpIcons.FIELD));
                                    return false;
                                }
                            }
                            return true;
                        });
                    }
                } else if (parameters.getInvocationCount() <= 1) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDynamicPropertyCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpRadialSiblingIterator
    implements Iterator<PsiElement> {
        private PsiElement left;
        private PsiElement right;
        private boolean isLeftNext;

        private PhpRadialSiblingIterator(@NotNull PsiElement parent) {
            if (parent == null) {
                PhpRadialSiblingIterator.$$$reportNull$$$0(0);
            }
            this.left = parent.getPrevSibling();
            this.right = parent;
        }

        @Override
        public boolean hasNext() {
            return this.left != null || this.right != null;
        }

        @Override
        public PsiElement next() {
            if (this.left != null && (this.isLeftNext || this.right == null)) {
                this.isLeftNext = false;
                PsiElement element = this.left;
                this.left = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(this.left, true);
                return element;
            }
            if (this.right != null) {
                this.isLeftNext = true;
                PsiElement element = this.right;
                this.right = PhpPsiUtil.getNextSiblingIgnoreWhitespace(this.right, true);
                return element;
            }
            throw new IllegalStateException("hasNext() has not been called");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/php/completion/PhpCompletionContributor$PhpRadialSiblingIterator", "<init>"));
        }
    }

    private static class PhpUndeclaredVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpUndeclaredVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpUndeclaredVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpUndeclaredVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpUndeclaredVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpUseImpl.getUseList(position = parameters.getPosition().getOriginalElement()) != null || PhpCompletionContributor.isNamespace(position.getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position)) {
                return;
            }
            Function function = (Function)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)Function.INSTANCEOF);
            Set parameterNames = function != null ? Arrays.stream(function.getParameters()).map(Parameter::getName).collect(Collectors.toSet()) : Collections.emptySet();
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, PhpCompletionContributor.patchResultIfNeeded(result));
            PhpCompletionContributor.visitScopeHolderBranches(position, (Processor<PsiElement>)element -> {
                if (element instanceof Variable && !parameterNames.contains(((Variable)element).getName())) {
                    wrappedResult.addElement(PhpVariantsUtil.getLookupItem((PhpNamedElement)((Variable)element), null));
                    return false;
                }
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpUndeclaredVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpSmartFunctionParametersCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpSmartFunctionParametersCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Parameter parameter;
            Function function;
            PsiElement[] referenceParameters;
            PsiElement position;
            if (parameters == null) {
                PhpSmartFunctionParametersCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpSmartFunctionParametersCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpSmartFunctionParametersCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!((position = parameters.getPosition().getOriginalElement()).getParent() instanceof ConstantReference)) {
                return;
            }
            if (TemplateManager.getInstance((Project)position.getProject()).getActiveTemplate(parameters.getEditor()) != null) {
                return;
            }
            ParameterList parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (parameterList != null && ((referenceParameters = parameterList.getParameters()).length == 0 || referenceParameters.length == 1 && referenceParameters[0] == position.getParent()) && (function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)(parameter = PhpWorkaroundUtil.getFunctionParameter(position)), true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
                result.addElement((LookupElement)new PhpSmartFunctionParametersLookupElement(function));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpSmartFunctionParametersCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCastCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCastCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpCastCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCastCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCastCompletionProvider.$$$reportNull$$$0(2);
            }
            PhpCompletionContributor.addCastTypes(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCastCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpForeachKeyAndValueCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpForeachKeyAndValueCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpForeachKeyAndValueCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpForeachKeyAndValueCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpForeachKeyAndValueCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.isForeachKeyOrValue(position = parameters.getPosition().getOriginalElement())) {
                if (result.getPrefixMatcher().getPrefix().startsWith("$")) {
                    PsiElement parent = position.getParent();
                    Collection names = PhpCompletionContributor.suggestNames(parent, position);
                    for (String name : names) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("$" + name)));
                    }
                } else {
                    Collection functions = PhpIndex.getInstance((Project)position.getProject()).getFunctionsByName("list");
                    result.addAllElements(PhpVariantsUtil.getLookupItems(functions, false, null));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpForeachKeyAndValueCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpQualifiedFunctionAndConstantCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpQualifiedFunctionAndConstantCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String namespaceName;
            if (parameters == null) {
                PhpQualifiedFunctionAndConstantCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpQualifiedFunctionAndConstantCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpQualifiedFunctionAndConstantCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PsiElement grandParent = parent.getParent();
            if (PhpCompletionContributor.isNamespace(position.getPrevSibling()) && parent instanceof PhpReference && PhpLangUtil.isFqn(namespaceName = ((PhpReference)parent).getNamespaceName()) && !PhpLangUtil.isGlobalNamespaceFQN(namespaceName)) {
                CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
                if (!(grandParent instanceof PhpUse) || PhpUseImpl.isOfConst((PhpUse)grandParent)) {
                    PhpCompletionContributor.addConstantVariants(position.getProject(), namespaceName, wrappedResult, false);
                }
                if (!(grandParent instanceof PhpUse) || PhpUseImpl.isOfFunction((PhpUse)grandParent)) {
                    PhpCompletionContributor.addFunctionVariants(position.getProject(), namespaceName, wrappedResult, false, false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpQualifiedFunctionAndConstantCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpFuncRefCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpFuncRefCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpFuncRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpFuncRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpFuncRefCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!((parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof FunctionReference && !(parent instanceof MemberReference) || parent instanceof PhpDocRef)) {
                return;
            }
            PsiElement prev = position.getPrevSibling();
            if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.ARROW)) {
                return;
            }
            String namespaceName = PhpCompletionContributor.getNamespaceNameForGroupUse(position);
            if (namespaceName == null && PhpCompletionContributor.isNamespace(prev)) {
                String fqn = PhpCompletionContributor.getNamespace(prev, parent);
                namespaceName = fqn != null ? PhpLangUtil.toFQN(fqn) : null;
            }
            PhpCompletionContributor.addFunctionVariants(position.getProject(), namespaceName, PhpCompletionSorting.wrapResult(parameters, context, result), false, parent.getParent() instanceof PhpUse);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpFuncRefCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpFieldNamesForConstructorParametersCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpFieldNamesForConstructorParametersCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
            if (parameters == null) {
                PhpFieldNamesForConstructorParametersCompletionProvider.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                PhpFieldNamesForConstructorParametersCompletionProvider.$$$reportNull$$$0(1);
            }
            if (resultSet == null) {
                PhpFieldNamesForConstructorParametersCompletionProvider.$$$reportNull$$$0(2);
            }
            ParameterList parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(parameters.getPosition(), (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
            PhpClass phpClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)parameterList, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (parameterList != null && phpClass != null) {
                Set usedParameterNames = StreamEx.of((Object[])parameterList.getParameters()).select(Parameter.class).map(Parameter::getName).toSet();
                ((StreamEx)((StreamEx)StreamEx.of((Object[])phpClass.getOwnFields()).filter(field -> !field.isConstant())).map(field -> field.getName()).filter(fieldName -> !usedParameterNames.contains(fieldName))).map(fieldName -> LookupElementBuilder.create((String)("$" + fieldName)).withIcon(PhpIcons.FIELD)).forEach(arg_0 -> ((CompletionResultSet)resultSet).addElement(arg_0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultSet";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpFieldNamesForConstructorParametersCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TypeHintSuggestionsProvider
    extends CompletionProvider<CompletionParameters> {
        public static final char NAMESPACE_SEPARATOR = '\\';
        public static final char VARIABLE_PREFIX = '$';

        private TypeHintSuggestionsProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
            PsiElement position;
            Parameter parameter;
            if (parameters == null) {
                TypeHintSuggestionsProvider.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                TypeHintSuggestionsProvider.$$$reportNull$$$0(1);
            }
            if (resultSet == null) {
                TypeHintSuggestionsProvider.$$$reportNull$$$0(2);
            }
            if ((parameter = (Parameter)PhpPsiUtil.getParentByCondition(position = parameters.getPosition(), (Condition<? super PsiElement>)Parameter.INSTANCEOF)) != null) {
                Collection names = PhpCompletionContributor.suggestNames((PsiElement)parameter, position);
                String positionText = position.getText();
                for (String name : names) {
                    String lookupName;
                    if (StringUtil.containsChar((String)name, (char)'\\') || positionText.equals(lookupName = '$' + name)) continue;
                    resultSet.addElement((LookupElement)LookupElementBuilder.create((String)lookupName));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultSet";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$TypeHintSuggestionsProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpLangTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpLangTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpLangTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpLangTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpLangTagCompletionProvider.$$$reportNull$$$0(2);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"text"));
            Collection languages = Language.getRegisteredLanguages();
            for (Language language : languages) {
                String id;
                if (language instanceof TemplateLanguage || language instanceof DependentLanguage || !StringUtil.isNotEmpty((String)(id = language.getID()))) continue;
                result.addElement((LookupElement)LookupElementBuilder.create((String)id));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpLangTagCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDataProviderTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDataProviderTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement parent;
            PsiElement position;
            if (parameters == null) {
                PhpDataProviderTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDataProviderTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDataProviderTagCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position = parameters.getPosition().getOriginalElement(), parent = position.getParent())) {
                result.addAllElements(PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, false));
                return;
            }
            PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (containingClass != null) {
                for (Method m : containingClass.getOwnMethods()) {
                    if (PhpUnitUtil.isTestMethod(m)) continue;
                    result.addElement((LookupElement)new PhpLookupElement((PhpNamedElement)m));
                }
                if (parameters.getInvocationCount() <= 1) {
                    result.stopHere();
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                    return;
                }
            }
            PhpCompletionContributor.addClassesAndFunctions(parameters, context, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDataProviderTagCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCoversTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCoversTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition();
            Project project = position.getProject();
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            if (!PhpPsiUtil.isOfType(position.getPrevSibling(), PhpDocTokenTypes.DOC_STATIC)) {
                PhpCoversTagCompletionProvider.addNonTestClasses(parameters, result, position, phpIndex);
                return;
            }
            PsiElement parent = position.getParent();
            if (PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position, parent)) {
                for (LookupElement element : PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, false)) {
                    ((PhpLookupElement)element).handler = null;
                    result.addElement(element);
                }
                if (parameters.getInvocationCount() > 1) {
                    for (PhpModifier.Access access : PhpModifier.Access.values()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("<" + access.toString() + ">")).withIcon(PhpIcons.METHOD));
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("<!" + access.toString() + ">")).withIcon(PhpIcons.METHOD));
                    }
                }
            } else {
                PhpCoversTagCompletionProvider.addCoveredFunctionVariants(parameters, context, result, phpIndex, project, PhpUnitUtil.getDefaultCoveredClassName((PhpClass)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)));
            }
        }

        private static void addCoveredFunctionVariants(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, @NotNull Project project, @Nullable String coveredClassName) {
            if (parameters == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(4);
            }
            if (phpIndex == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(5);
            }
            if (project == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(6);
            }
            if (coveredClassName != null) {
                boolean includeMagic = parameters.getInvocationCount() > 1;
                for (PhpClass phpClass : phpIndex.getClassesByFQN(PhpLangUtil.toFQN(coveredClassName))) {
                    for (LookupElement element : PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, null)) {
                        ((PhpLookupElement)element).handler = null;
                        result.addElement(element);
                    }
                }
            } else {
                PhpCompletionContributor.addFunctionVariants(project, null, PhpCompletionSorting.wrapResult(parameters, context, result), false, true);
            }
        }

        private static void addNonTestClasses(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull PhpIndex phpIndex) {
            if (parameters == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(7);
            }
            if (result == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(8);
            }
            if (position == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(9);
            }
            if (phpIndex == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(10);
            }
            String namespace = PhpCompletionContributor.getNamespace(position.getPrevSibling(), position);
            Predicate<PhpClass> predicate = clazz -> (namespace == null || PhpLangUtil.equalsNamespaceNames(clazz.getNamespaceName(), namespace)) && !PhpUnitUtil.isTestClass(clazz, false);
            Consumer<PhpClass> adder = clazz -> {
                if (result == null) {
                    PhpCoversTagCompletionProvider.$$$reportNull$$$0(11);
                }
                PhpLookupElement item = PhpVariantsUtil.getLookupItem((PhpNamedElement)clazz, null);
                item.handler = PhpUnitCoversClassInsertHandler.INSTANCE;
                result.addElement((LookupElement)item);
            };
            PhpCompletionUtil.addClasses(phpIndex, result.getPrefixMatcher(), predicate, adder);
            if (parameters.getInvocationCount() <= 1) {
                result.stopHere();
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpIndex";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCoversTagCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCoveredFunctionVariants";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNonTestClasses";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$addNonTestClasses$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class PhpVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected PhpVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            result = PhpCompletionContributor.patchResultIfNeeded(result);
            PsiElement position = parameters.getPosition();
            boolean global = PhpCompletionContributor.isGlobal(position);
            boolean allGlobals = parameters.getInvocationCount() > 1 || global;
            PhpUseList useList = PhpUseImpl.getUseList(position);
            if (useList != null) {
                allGlobals = false;
                position = useList.getParent().getParent();
            } else if (!allGlobals) {
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.global.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
            if (PhpCompletionContributor.isNamespace(position.getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position)) {
                return;
            }
            boolean smart = parameters.getCompletionType() == CompletionType.SMART;
            boolean allSuperGlobals = !smart && !global && useList == null && (allGlobals || !PhpCompletionContributor.isList(position) && !PhpCompletionContributor.isIssetOrUnset(position));
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
            PhpVariantsUtil.getVariableVariants(position, allGlobals, allSuperGlobals, result.getPrefixMatcher()).stream().filter(e -> useList == null || !"this".equals(e.getLookupString())).forEach(wrappedResult::addElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpGotoLabelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpGotoLabelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, final @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpGotoLabelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpGotoLabelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpGotoLabelCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement scope = PhpGotoImpl.getVisibilityScope(parameters.getPosition());
            scope.accept((PsiElementVisitor)new PhpGotoImpl.PhpGotoBaseVisitor(scope){

                public void visitPhpGotoLabel(PhpGotoLabel label) {
                    result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)label));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpGotoLabelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpNamespaceCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpNamespaceCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String namespaceName;
            if (parameters == null) {
                PhpNamespaceCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpNamespaceCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpNamespaceCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PhpIndex index = PhpIndex.getInstance((Project)position.getProject());
            PsiElement parent = position.getParent();
            if (parent instanceof MemberReference) {
                return;
            }
            if (parent instanceof PhpGoto) {
                return;
            }
            if (parent instanceof ClassReference && ((ClassReference)parent).getUsageContext().isInClassUse()) {
                return;
            }
            if (PhpCompletionContributor.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            if (PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)PhpTraitUseRule.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null) {
                return;
            }
            if (parent instanceof PhpReference) {
                namespaceName = ((PhpReference)parent).getNamespaceName();
            } else if (parent instanceof PhpNamespace) {
                namespaceName = ((PhpNamespace)parent).getParentNamespaceName();
            } else if (parent instanceof PhpDocRef) {
                namespaceName = PhpCompletionContributor.getNamespace(position.getPrevSibling(), null);
                if (namespaceName == null) {
                    return;
                }
            } else {
                return;
            }
            PhpCompletionUtil.addSubNamespaces(namespaceName, result, index, PhpNamespaceInsertHandler.getInstance());
            if (!(parent instanceof PhpNamespace) && !PhpCompletionContributor.isNamespace(position.getPrevSibling()) && PhpUseImpl.getUseList(position) == null && PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) == null) {
                LookupElementBuilder lookupElement = LookupElementBuilder.create((String)"namespace").withTailText("(" + namespaceName + ")", true).withIcon(PhpIcons.NAMESPACE).withBoldness(true).withInsertHandler((InsertHandler)PhpNamespaceInsertHandler.getInstance());
                result.addElement((LookupElement)lookupElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpNamespaceCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCatchVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCatchVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement variable;
            if (parameters == null) {
                PhpCatchVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCatchVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCatchVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((variable = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof Variable) {
                PhpCompletionContributor.suggestNames(variable, position).stream().map(s -> "$" + s).map(LookupElementBuilder::create).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
                if (parameters.getInvocationCount() <= 1) {
                    result.stopHere();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCatchVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpExceptionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExceptionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            boolean smart;
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpExceptionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExceptionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExceptionCompletionProvider.$$$reportNull$$$0(2);
            }
            ClassUsageContext usageContext = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof ClassReference ? ((ClassReference)parent).getUsageContext() : new ClassUsageContext(false);
            PhpIndex index = PhpIndex.getInstance((Project)parameters.getPosition().getProject());
            Collection subclasses = new ArrayList(index.getAllSubclasses("\\Throwable"));
            subclasses.addAll(index.getAnyByFQN("\\Throwable"));
            if (parent instanceof PhpReference && PhpCompletionContributor.isNamespace(position.getPrevSibling())) {
                subclasses = index.filterByNamespace(subclasses, ((PhpReference)parent).getNamespaceName());
            }
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
            for (PhpClass aClass : subclasses) {
                PhpLookupElement item = PhpVariantsUtil.getLookupItemForClass(aClass, usageContext);
                if (item == null) continue;
                wrappedResult.addElement(item);
            }
            boolean bl = smart = parameters.getCompletionType() == CompletionType.SMART;
            if (parameters.getInvocationCount() <= 1 || smart) {
                result.stopHere();
                if (!smart) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.all.classes", PhpCompletionContributor.getCompletionActionShortcut()));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExceptionCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDocCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDocCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PhpDocComment docComment = (PhpDocComment)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
            PhpDocTag docTag = (PhpDocTag)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
            if (docComment == null) {
                return;
            }
            PhpPsiElement next = docComment.getNextPsiSibling();
            if (next instanceof GroupStatement) {
                next = next.getFirstPsiChild();
            }
            if (parent instanceof PhpDocComment || parent instanceof PhpDocTag) {
                boolean at = parent instanceof PhpDocTag;
                if (next instanceof PhpClass) {
                    for (String s : classtags) {
                        result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, s));
                    }
                    if (PhpUnitUtil.isTestClass((PhpClass)next, false)) {
                        for (String s : phpunittags) {
                            result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, s));
                        }
                    }
                } else if (next instanceof Function) {
                    for (String s : functags) {
                        result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, s));
                    }
                    if (next instanceof Method && PhpUnitUtil.isTestMethod((Method)next)) {
                        for (String s : phpunittags) {
                            result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, s));
                        }
                    }
                } else if (PhpInjectionUtil.getLargestStringLiteral((PsiElement)next) != null) {
                    result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, "@lang"));
                } else {
                    for (String s : vartags) {
                        result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, s));
                    }
                }
                for (String s : everywheretags) {
                    result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, s));
                }
            } else if (parent instanceof PhpDocVariable || PhpDocCompletionProvider.isSuitableForPhpDocVariable(position)) {
                result = PhpCompletionContributor.patchResultIfNeeded(result);
                if (next instanceof Function) {
                    for (Parameter p : ((Function)next).getParameters()) {
                        result.addElement((LookupElement)PhpVariantsUtil.getLookupItem((PhpNamedElement)p, null));
                    }
                } else if (next != null) {
                    final List elements = ContainerUtil.newSmartList();
                    next.accept((PsiElementVisitor)new PhpElementVisitor(){
                        int visited;

                        public void visitElement(PsiElement element) {
                            PsiElement variableParent;
                            ++this.visited;
                            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.VARIABLE) && (variableParent = element.getParent()) instanceof PhpNamedElement) {
                                PhpLookupElement lookupElement = PhpVariantsUtil.getLookupItem((PhpNamedElement)variableParent, null);
                                lookupElement.handler = PhpVariableInsertHandler.getInstance();
                                elements.add(lookupElement);
                            }
                        }

                        public void visitPhpElement(PhpPsiElement element) {
                            if (this.visited < 100 && elements.size() < 10 && !(element instanceof GroupStatement)) {
                                element.acceptChildren((PsiElementVisitor)this);
                            }
                        }
                    });
                    result.addAllElements((Iterable)elements);
                }
            } else if (!PhpDocCompletionProvider.isPhpUnitTag(docTag) && PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position, parent)) {
                result.addAllElements(PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, true));
            } else if (docTag != null && !PhpDocCompletionProvider.isPhpUnitTag(docTag)) {
                PhpCompletionContributor.addClassesAndFunctions(parameters, context, result);
                if ("@see".equals(docTag.getName())) {
                    CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
                    PhpCompletionContributor.addConstantVariants(position.getProject(), PhpCompletionContributor.getNamespace(position.getPrevSibling(), parent), wrappedResult, false);
                }
            }
        }

        private static boolean isPhpUnitTag(@Nullable PhpDocTag docTag) {
            if (docTag == null) {
                return false;
            }
            return docTag instanceof PhpDocExpectedExceptionTag || docTag instanceof PhpDocDataProviderTag || docTag instanceof PhpDocDependsTag || docTag instanceof PhpDocCoversTag || StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass");
        }

        private static boolean isSuitableForPhpDocVariable(PsiElement position) {
            PsiElement grandParent;
            PhpPsiElement prevPsiSibling;
            PsiElement parent;
            return position.getPrevSibling() == null && PhpPsiUtil.isOfType(parent = position.getParent(), (IElementType)PhpDocElementTypes.phpDocTagValue) && (prevPsiSibling = ((PhpPsiElement)parent).getPrevPsiSibling()) instanceof PhpDocType && (grandParent = parent.getParent()) instanceof PhpDocParamTag && ((PhpDocParamTag)grandParent).getFirstPsiChild() == prevPsiSibling;
        }

        private static LookupElementBuilder createDocTagLookup(boolean at, String s) {
            String lookupString = at ? s.substring(1) : s;
            LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).withBoldness(true);
            if ("@inheritdoc".equals(s)) {
                return builder;
            }
            return builder.withInsertHandler((InsertHandler)new PhpSymbolInsertHandler(' ', true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDocCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpClassRefCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassRefCompletionProvider() {
        }

        private static void addTraitUseRuleTraits(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull PhpTraitUseRule traitUseRule) {
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (traitUseRule == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(2);
            }
            boolean methodReference = position instanceof MethodReference && !(position.getFirstChild() instanceof ClassReference);
            boolean classReference = PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(position, true), PhpTokenTypes.kwINSTEADOF);
            if (methodReference || classReference) {
                ClassReference traitReference;
                String traitToSkip = null;
                if (classReference && (traitReference = PhpCompletionContributor.getTraitReference(traitUseRule)) != null) {
                    traitToSkip = traitReference.getName();
                }
                PhpIndex phpIndex = PhpIndex.getInstance((Project)position.getProject());
                ClassUsageContext usageContext = methodReference ? ClassUsageContext.STATIC : new ClassUsageContext(false);
                usageContext.setInClassUse(true);
                PhpUseList useList = PhpUseImpl.getUseList((PsiElement)traitUseRule);
                if (useList != null) {
                    for (PhpUse use : useList.getDeclarations()) {
                        String traitName;
                        if (classReference && use.getName().equals(traitToSkip)) continue;
                        PhpReference reference = use.getTargetReference();
                        String string = traitName = reference != null ? reference.getFQN() : null;
                        if (traitName == null) continue;
                        if (!use.getName().equals(PhpLangUtil.toShortName(traitName))) {
                            PhpLookupElement element = new PhpLookupElement((PhpNamedElement)use);
                            element.handler = PhpVariantsUtil.getInsertHandlerForClassContext(usageContext);
                            result.addElement((LookupElement)element);
                            continue;
                        }
                        for (PhpClass phpClass : phpIndex.getTraitsByFQN(traitName)) {
                            PhpLookupElement lookupItem = PhpVariantsUtil.getLookupItemForClass(phpClass, usageContext);
                            if (lookupItem == null) continue;
                            result.addElement((LookupElement)lookupItem);
                        }
                    }
                }
            }
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
            PhpClass superClass;
            boolean restrict;
            ClassUsageContext context;
            boolean smart;
            PsiElement position;
            if (parameters == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(3);
            }
            if (processingContext == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(4);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(5);
            }
            PsiElement parent = (position = parameters.getPosition().getOriginalElement().getParent()) != null ? position.getParent() : null;
            boolean bl = smart = parameters.getCompletionType() == CompletionType.SMART;
            if (parent instanceof PhpTraitUseRule) {
                PhpClassRefCompletionProvider.addTraitUseRuleTraits(result, position, (PhpTraitUseRule)parent);
                if (parameters.getInvocationCount() <= 1 || smart) {
                    if (!smart) {
                        result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                    }
                    return;
                }
            }
            if (!(position instanceof ClassReference || position instanceof ConstantReference || position instanceof PhpDocType || position instanceof PhpDocRef || PhpCompletionContributor.isSuitableForPhpDocMethodType(position))) {
                return;
            }
            if (PhpCompletionContributor.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            if (parent instanceof PhpUse && (PhpUseImpl.isOfFunction((PhpUse)parent) || PhpUseImpl.isOfConst((PhpUse)parent))) {
                return;
            }
            ClassUsageContext classUsageContext = context = position instanceof ClassReference ? ((ClassReference)position).getUsageContext() : new ClassUsageContext(position instanceof ConstantReference);
            if (parameters.getInvocationCount() > 1 && !smart) {
                context = new ClassUsageContext(false);
            }
            boolean nsp = PhpCompletionContributor.isNamespace(parameters.getPosition().getPrevSibling()) || PhpCompletionContributor.getNamespaceNameForGroupUse(position) != null;
            boolean bl2 = restrict = smart || parameters.getInvocationCount() <= 1 && (nsp || result.getPrefixMatcher().getPrefix().length() == 0);
            if (restrict && !smart) {
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.global.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, processingContext, result);
            if (!nsp) {
                boolean isCodeTypeFragment = parent.getContainingFile() instanceof PhpTypeCodeFragment;
                if (parent instanceof Parameter || parent.getParent() instanceof Function || isCodeTypeFragment) {
                    PhpCompletionContributor.addTypeDeclarations(result, isCodeTypeFragment);
                    if (parent.getParent() instanceof Function || isCodeTypeFragment) {
                        PhpCompletionContributor.addTypeDeclaration(result, isCodeTypeFragment, "void");
                    }
                }
                if (position instanceof PhpDocType || position instanceof ClassReference && (PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocMethodType) || PhpCompletionContributor.isSuitableForPhpDocMethodType(position))) {
                    PhpCompletionContributor.addPhpDocTypes(result);
                }
                for (PhpUse use : PhpCompletionContributor.getUses(position)) {
                    PhpClass aClass;
                    if (use == null || PhpUseImpl.isOfFunction(use) || PhpUseImpl.isOfConst(use) || (aClass = PhpClassRefCompletionProvider.getClass(use)) != null && !PhpClassRefCompletionProvider.shouldAddElement(position, context, aClass)) continue;
                    wrappedResult.addElement(PhpClassRefCompletionProvider.createLookupElement(context, use));
                }
            }
            PhpClassRefCompletionProvider.addClassesContextAware(nsp, position, parameters, context, wrappedResult, restrict);
            Project project = position.getProject();
            PhpClass currentClass = (PhpClass)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
            PhpClass phpClass = superClass = currentClass != null ? currentClass.getSuperClass() : null;
            if (!(nsp || !context.isInNew() && (!context.isGeneric() && !context.isStatic() || parent instanceof PhpUse || parent instanceof Parameter || parent instanceof Function || position instanceof PhpDocType || position instanceof PhpDocRef || PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocMethodType) || PhpCompletionContributor.isSuitableForPhpDocMethodType(position)))) {
                wrappedResult.addElement(PhpClassRefCompletionProvider.getBindingKeyword("parent", context, project, superClass));
                wrappedResult.addElement(PhpClassRefCompletionProvider.getBindingKeyword("self", context, project, currentClass));
                wrappedResult.addElement(PhpClassRefCompletionProvider.getBindingKeyword("static", context, project, currentClass));
            }
        }

        private static void addClassesContextAware(boolean nsp, @NotNull PsiElement position, @NotNull CompletionParameters parameters, @NotNull ClassUsageContext context, @NotNull CompletionResultSetWrapper result, boolean restrict) {
            Predicate<PhpClass> predicate;
            PhpIndex phpIndex;
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(6);
            }
            if (parameters == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(7);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(8);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(9);
            }
            PrefixMatcher matcher = result.getPrefixMatcher();
            Object prefixMatcher = nsp || !PhpVariantsUtil.fqcnCompletionEnabled() ? matcher : new PhpFqnPrefixMatcher(matcher);
            if (PhpClassRefCompletionProvider.addVariants(context, prefixMatcher, phpIndex = PhpIndex.getInstance((Project)position.getProject()), predicate = phpClass -> {
                if (context == null) {
                    PhpClassRefCompletionProvider.$$$reportNull$$$0(28);
                }
                if (position == null) {
                    PhpClassRefCompletionProvider.$$$reportNull$$$0(29);
                }
                if (parameters == null) {
                    PhpClassRefCompletionProvider.$$$reportNull$$$0(30);
                }
                return PhpVariantsUtil.lookupItemForClassAvailable(phpClass, context) && PhpClassRefCompletionProvider.shouldAddElement(position, context, phpClass) && PhpClassRefCompletionProvider.filterByNamespace(phpClass, restrict, position, parameters, nsp);
            }, phpClass -> {
                if (context == null) {
                    PhpClassRefCompletionProvider.$$$reportNull$$$0(26);
                }
                if (result == null) {
                    PhpClassRefCompletionProvider.$$$reportNull$$$0(27);
                }
                PhpClassRefCompletionProvider.addLookupElement(phpClass, context, result);
            })) {
                PhpCompletionContributor.handleOverflow(result.getResult());
            }
        }

        private static boolean addVariants(@NotNull ClassUsageContext context, PrefixMatcher prefixMatcher, PhpIndex phpIndex, Predicate<PhpClass> predicate, Consumer<PhpClass> adder) {
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(10);
            }
            if (context.isInInstanceof() || context.isInExtends()) {
                boolean result = !PhpCompletionUtil.addClasses(phpIndex, prefixMatcher, predicate, adder);
                return result || !PhpCompletionUtil.addInterfaces(phpIndex, predicate, adder, prefixMatcher);
            }
            if (context.isInImplements()) {
                return !PhpCompletionUtil.addInterfaces(phpIndex, predicate, adder, prefixMatcher);
            }
            if (context.isInNew()) {
                return !PhpCompletionUtil.addClasses(phpIndex, prefixMatcher, predicate, adder);
            }
            if (context.isInClassUse()) {
                return !PhpCompletionUtil.addTraits(phpIndex, predicate, adder);
            }
            boolean result = !PhpCompletionUtil.addClasses(phpIndex, prefixMatcher, predicate, adder);
            result = result || !PhpCompletionUtil.addInterfaces(phpIndex, predicate, adder, prefixMatcher);
            return result || !PhpCompletionUtil.addTraits(phpIndex, predicate, adder);
        }

        private static boolean filterByNamespace(PhpClass element, boolean restrict, PsiElement position, CompletionParameters parameters, boolean nsp) {
            if (restrict) {
                PsiElement prev = position instanceof PhpDocRef ? parameters.getPosition().getOriginalElement().getPrevSibling() : null;
                String namespaceName = nsp ? PhpCompletionContributor.getNamespace(prev, position) : null;
                return PhpCompletionUtil.hasNamespace(namespaceName, false, element);
            }
            return true;
        }

        private static boolean shouldAddElement(@NotNull PsiElement position, @NotNull ClassUsageContext context, @Nullable PhpClass aClass) {
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(11);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(12);
            }
            if (aClass == null) {
                return false;
            }
            PhpClass current = (PhpClass)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (context.isInInstanceof()) {
                return PhpCompletionContributor.shouldAddClass(aClass, context, current) || PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position);
            }
            if (context.isInExtends()) {
                if (current != null && current.isInterface()) {
                    return PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position);
                }
                return !aClass.isFinal() && PhpCompletionContributor.shouldAddClass(aClass, context, current);
            }
            if (context.isInImplements()) {
                return PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position);
            }
            if (context.isInNew()) {
                return PhpCompletionContributor.shouldAddClass(aClass, context, current);
            }
            if (context.isInClassUse()) {
                return aClass.isTrait();
            }
            return PhpCompletionContributor.shouldAddClass(aClass, context, current) || PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position) || aClass.isTrait();
        }

        @NotNull
        private static PhpLookupElement createLookupElement(@NotNull ClassUsageContext context, @NotNull PhpUse use) {
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(13);
            }
            if (use == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(14);
            }
            PhpLookupElement lookupElement = new PhpLookupElement((PhpNamedElement)use);
            lookupElement.handler = PhpUseImpl.resolvesToClass(use) ? PhpVariantsUtil.getInsertHandlerForClassContext(context) : PhpNamespaceInsertHandler.getInstance();
            PhpLookupElement phpLookupElement = lookupElement;
            if (phpLookupElement == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(15);
            }
            return phpLookupElement;
        }

        @Nullable
        private static PhpClass getClass(@Nullable PhpUse phpUse) {
            if (phpUse != null) {
                PhpReference reference = phpUse.getTargetReference();
                return reference != null ? (PhpClass)reference.resolveGlobal(false).stream().filter(PhpClass.class::isInstance).findAny().orElse(null) : null;
            }
            return null;
        }

        private static boolean shouldAddInterface(@NotNull PhpClass anInterface, @NotNull ClassUsageContext context, @NotNull PsiElement position) {
            if (anInterface == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(16);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(17);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(18);
            }
            if (!anInterface.isInterface()) {
                return false;
            }
            if (context.isInImplements()) {
                PhpClass aClass = (PhpClass)position.getParent().getParent();
                for (ClassReference element : aClass.getImplementsList().getReferenceElements()) {
                    if (!anInterface.getName().equalsIgnoreCase(element.getName())) continue;
                    return false;
                }
            }
            return PhpClassRefCompletionProvider.isNotIterable(anInterface) || !context.isInExtends() && !context.isStatic() && !context.isInImplements() && !(position.getParent() instanceof PhpUse);
        }

        private static void addLookupElement(@NotNull PhpClass aClass, @NotNull ClassUsageContext context, @NotNull CompletionResultSetWrapper result) {
            PhpLookupElement lookupElement;
            if (aClass == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(19);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(20);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(21);
            }
            if ((lookupElement = PhpVariantsUtil.getLookupItemForClass(aClass, context)) == null) {
                return;
            }
            result.addElement(lookupElement);
        }

        private static boolean isNotIterable(@NotNull PhpClass anInterface) {
            if (anInterface == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(22);
            }
            return !PhpLangUtil.equalsClassNames(anInterface.getFQN(), "\\iterable");
        }

        private static LookupElement getBindingKeyword(@NotNull String keyword, @NotNull ClassUsageContext context, @NotNull Project project, @Nullable PhpClass phpClass) {
            if (keyword == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(23);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(24);
            }
            if (project == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(25);
            }
            PhpType type = phpClass != null ? phpClass.getType() : null;
            PhpReferenceInsertHandler handler = context.isInNew() ? PhpClassConstructorInsertHandler.getInstance() : PhpClassStaticInsertHandler.getInstance();
            PhpLookupElement element = new PhpLookupElement(keyword, PhpClassIndex.KEY, PhpIcons.STATIC_CLASS, type, project, handler);
            element.bold = true;
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: 
                case 6: 
                case 11: 
                case 18: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traitUseRule";
                    break;
                }
                case 3: 
                case 7: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processingContext";
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 17: 
                case 20: 
                case 24: 
                case 26: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "use";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpClassRefCompletionProvider";
                    break;
                }
                case 16: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anInterface";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyword";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpClassRefCompletionProvider";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addTraitUseRuleTraits";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addClassesContextAware";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addVariants";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAddElement";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElement";
                    break;
                }
                case 15: {
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAddInterface";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupElement";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "isNotIterable";
                    break;
                }
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "getBindingKeyword";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addClassesContextAware$1";
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addClassesContextAware$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class PhpMemberRefCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected PhpMemberRefCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            boolean smart;
            if (parameters == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement().getParent();
            boolean bl = smart = parameters.getCompletionType() == CompletionType.SMART;
            if (PhpCompletionContributor.isNamespace(parameters.getPosition().getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
            if (position instanceof ConstantReference) {
                PhpClass phpClass = (PhpClass)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                if (phpClass != null) {
                    boolean includeMagic;
                    UsageContext usageContext = new UsageContext(PhpModifier.State.DYNAMIC);
                    Method method = (Method)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)Method.INSTANCEOF);
                    usageContext.setScope(method != null ? method.getModifier().getState() : null);
                    usageContext.setTargetObjectClass(phpClass);
                    usageContext.setClassForAccessFilter(phpClass);
                    usageContext.setHavePredecessorClassReference(false);
                    boolean bl2 = includeMagic = parameters.getInvocationCount() > 1 || parameters.getPosition().getText().startsWith("__");
                    if (!includeMagic) {
                        result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                    }
                    if (!PhpCompletionContributor.isIssetOrUnset(position)) {
                        wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, usageContext));
                    }
                    wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getFields(), includeMagic, usageContext));
                }
            } else if (position instanceof MemberReference) {
                boolean includeMagic;
                PhpDebugRuntimeEnvironment environment;
                String string;
                PhpExpression classReference;
                PsiElement parent = position.getParent();
                if (parent instanceof PhpTraitUseRule) {
                    PhpMemberRefCompletionProvider.addTraitUseRuleMethods(result, position, (PhpTraitUseRule)parent);
                    if (parameters.getInvocationCount() <= 1 || smart) {
                        if (!smart) {
                            result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                        }
                        return;
                    }
                }
                if ((classReference = ((MemberReference)position).getClassReference()) == null) {
                    return;
                }
                PhpType phpType = classReference.getType();
                if ((phpType = phpType.globalLocationAware((PsiElement)classReference)).hasUnknown() && classReference instanceof PhpReference && ((PhpReference)classReference).resolveGlobal(false).isEmpty()) {
                    phpType = new PhpType().add(phpType);
                    for (PhpNamedElement phpNamedElement : PhpReferenceImpl.extendedResolve((PhpReference)position)) {
                        phpType.add((PsiElement)phpNamedElement);
                    }
                }
                PsiFile containingFile = classReference.getContainingFile();
                if (classReference instanceof PhpReference && containingFile instanceof PhpExpressionCodeFragment) {
                    Project project = containingFile.getProject();
                    phpType = new PhpType().add(phpType);
                    StreamEx.of((Collection)((PhpExpressionCodeFragment)containingFile).resolve((PhpReference)classReference)).select(PhpTypedElement.class).map(element -> element.getType().global(project)).forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                }
                if (StringUtil.isNotEmpty((String)(string = classReference.getName())) && (environment = PhpDebugUtil.getCurrentRuntimeEnvironment(classReference.getProject())) != null) {
                    phpType = new PhpType().add(phpType).add(environment.getType(string));
                }
                UsageContext usageContext = new UsageContext(((MemberReference)position).getReferenceType());
                usageContext.setHavePredecessorClassReference(true);
                Set set = phpType.getTypes();
                boolean bl3 = includeMagic = parameters.getInvocationCount() > 1 || parameters.getPosition().getText().startsWith("__");
                if (!includeMagic) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                }
                for (String fqn : set) {
                    Project project = position.getProject();
                    while (classReference instanceof MemberReference && ("$this".equals(fqn) || "static".equals(fqn))) {
                        classReference = ((MemberReference)classReference).getClassReference();
                        assert (classReference != null);
                        fqn = (String)ContainerUtil.getFirstItem((Collection)classReference.getType().global(project).getTypesSorted());
                    }
                    if (classReference instanceof Variable && ("$this".equals(fqn) || "static".equals(fqn))) {
                        PhpClass aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                        if (aClass == null) continue;
                        fqn = aClass.getFQN();
                    }
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    ArrayDeque classes = new ArrayDeque(index.getAnyByFQN(fqn));
                    while (classes.size() > 0) {
                        PhpClass phpClass = (PhpClass)classes.removeFirst();
                        if (phpClass.isTrait()) {
                            Collection users = index.getNestedTraitUsages(phpClass, null);
                            classes.addAll(users);
                            usageContext.setTraitUsers(ContainerUtil.newHashSet((Iterable)users));
                        }
                        PhpMemberRefCompletionProvider.addMembersForClass((MemberReference)position, wrappedResult, parent, string, usageContext, includeMagic, phpClass);
                    }
                    if (fqn == null || !fqn.startsWith("__anonymous@")) continue;
                    fqn = fqn.substring("__anonymous@".length());
                    PhpClass anonymousClass = (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)position.getContainingFile(), (int)Integer.parseInt(fqn), PhpClass.class, (boolean)true);
                    if (anonymousClass == null) continue;
                    PhpMemberRefCompletionProvider.addMembersForClass((MemberReference)position, wrappedResult, parent, string, usageContext, includeMagic, anonymousClass);
                }
                if (usageContext.getState().isStatic() && !usageContext.isThis() && PhpProjectConfigurationFacade.getInstance(position.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.CLASS_NAME_CONST)) {
                    wrappedResult.addElement((LookupElement)LookupElementBuilder.create((String)"class"));
                }
            }
        }

        private static void addMembersForClass(MemberReference position, CompletionResultSetWrapper wrappedResult, PsiElement parent, String name, UsageContext usageContext, boolean includeMagic, PhpClass phpClass) {
            PhpClass currentClass = PhpClassImpl.getContainingClass((PhpPsiElement)position);
            boolean resolveThis = includeMagic && currentClass == null && "this".equals(name);
            usageContext.setClassForAccessFilter(resolveThis ? PhpAnnotatorVisitor.resolveThis((PsiElement)position) : currentClass);
            usageContext.setTargetObjectClass(phpClass);
            usageContext.setThis("this".equals(name));
            usageContext.setStaticOrSelfKeyword("static".equals(name) || "self".equals(name));
            if (!(parent instanceof MultiassignmentExpression || parent instanceof Variable && !PhpPsiUtil.isOfType(position.getPrevSibling(), PhpTokenTypes.chLBRACE))) {
                wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, usageContext));
            }
            wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getFields(), includeMagic, usageContext));
        }

        private static void addTraitUseRuleMethods(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull PhpTraitUseRule traitUseRule) {
            if (result == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(3);
            }
            if (position == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(4);
            }
            if (traitUseRule == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(5);
            }
            ClassReference traitReference = PhpCompletionContributor.getTraitReference(traitUseRule);
            PhpClass phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)position, PhpClass.class);
            if (traitReference != null) {
                PsiElement trait = traitReference.resolve();
                if (trait instanceof PhpClass && ((PhpClass)trait).isTrait()) {
                    PhpMemberRefCompletionProvider.addTraitMethods(result, phpClass, (PhpClass)trait);
                }
            } else {
                PhpIndex phpIndex = PhpIndex.getInstance((Project)position.getProject());
                for (String traitName : traitUseRule.getTraitNames()) {
                    for (PhpClass trait : phpIndex.getTraitsByFQN(traitName)) {
                        PhpMemberRefCompletionProvider.addTraitMethods(result, phpClass, trait);
                    }
                }
            }
        }

        private static void addTraitMethods(@NotNull CompletionResultSet result, @Nullable PhpClass phpClass, @NotNull PhpClass trait) {
            if (result == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(6);
            }
            if (trait == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(7);
            }
            UsageContext usageContext = new UsageContext(PhpModifier.State.PARENT);
            usageContext.setClassForAccessFilter(phpClass);
            usageContext.setTargetObjectClass(trait);
            result.addAllElements(PhpVariantsUtil.getLookupItems(trait.getMethods(), false, usageContext));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traitUseRule";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trait";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpMemberRefCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTraitUseRuleMethods";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTraitMethods";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpExpressionGlobalCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final PhpExpressionGlobalCompletionProvider INSTANCE = new PhpExpressionGlobalCompletionProvider();

        private PhpExpressionGlobalCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String fqn;
            if (parameters == null) {
                PhpExpressionGlobalCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpressionGlobalCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpressionGlobalCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PsiElement grandParent = parent.getParent();
            boolean nsp = false;
            PsiElement prev = position.getPrevSibling();
            if (!(!PhpCompletionContributor.isNamespace(prev) || (fqn = PhpCompletionContributor.getNamespace(prev, parent)) != null && PhpLangUtil.isFqn(fqn) && PhpLangUtil.isGlobalNamespaceFQN(fqn))) {
                nsp = true;
            }
            if (!(nsp || PhpCompletionContributor.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position) || !(position instanceof LeafPsiElement) || parent instanceof Variable || parent instanceof ClassReference || parent instanceof MemberReference || parent instanceof FunctionReference || parent instanceof PhpGoto || position instanceof PsiCommentImpl || PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null)) {
                CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
                if (parameters.getInvocationCount() > 0 || wrappedResult.getPrefixMatcher().getPrefix().length() > 0) {
                    boolean isUse = grandParent instanceof PhpUse;
                    if (!isUse || PhpUseImpl.isOfConst((PhpUse)grandParent)) {
                        PhpCompletionContributor.addConstantVariants(position.getProject(), PhpCompletionContributor.getNamespaceNameForGroupUse(position), wrappedResult, isUse);
                    }
                    if (!isUse || PhpUseImpl.isOfFunction((PhpUse)grandParent)) {
                        PhpCompletionContributor.addFunctionVariants(position.getProject(), PhpCompletionContributor.getNamespaceNameForGroupUse(position), wrappedResult, false, isUse);
                    }
                    Collection uses = PhpCompletionContributor.getUses(position);
                    for (PhpUse use : uses) {
                        PhpLookupElement element;
                        if (PhpUseImpl.isOfConst(use)) {
                            element = new PhpLookupElement((PhpNamedElement)use);
                            element.handler = PhpReferenceInsertHandler.getInstance();
                            wrappedResult.addElement(element);
                            continue;
                        }
                        if (!PhpUseImpl.isOfFunction(use)) continue;
                        element = new PhpLookupElement((PhpNamedElement)use);
                        element.handler = PhpFunctionInsertHandler.getInstance();
                        wrappedResult.addElement(element);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpressionGlobalCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpGlobalCompletionProviderFacade
    extends CompletionProvider<CompletionParameters> {
        private PhpGlobalCompletionProviderFacade() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpGlobalCompletionProviderFacade.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpGlobalCompletionProviderFacade.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpGlobalCompletionProviderFacade.$$$reportNull$$$0(2);
            }
            if (CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2 && !StringUtil.isCapitalized((String)result.getPrefixMatcher().getPrefix())) {
                PhpExpressionGlobalCompletionProvider.INSTANCE.addCompletions(parameters, context, result);
                PHP_CLASS_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
            } else {
                PHP_CLASS_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
                PhpExpressionGlobalCompletionProvider.INSTANCE.addCompletions(parameters, context, result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpGlobalCompletionProviderFacade";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpOpeningTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpOpeningTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement prevElement;
            if (parameters == null) {
                PhpOpeningTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpOpeningTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpOpeningTagCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(prevElement = PhpCompletionContributor.findPrevElement(parameters, result), PhpTokenTypes.PHP_OPENING_TAG)) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)PhpCompletionContributor.PHP_OPENING_TAG_LOOKUP_STRING).withPresentableText("<?php"));
                result.stopHere();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpOpeningTagCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

